/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BigBrickBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final BooleanProperty PAIRED = BooleanProperty.func_177716_a((String)"paired");
    public final BrickType TYPE;

    public BigBrickBlock(AbstractBlock.Properties properties) {
        this(properties, BrickType.STONE);
    }

    public BigBrickBlock(AbstractBlock.Properties properties, BrickType type) {
        super(properties);
        this.TYPE = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)PAIRED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        BlockPos targetPos = context.func_195995_a().func_177972_a(face.func_176734_d());
        BlockState targetState = context.func_195991_k().func_180495_p(targetPos);
        boolean pairing = false;
        if (context.func_195999_j() != null && !context.func_195999_j().func_225608_bj_() && this.BrickMatches(this, targetState) && !((Boolean)targetState.func_177229_b((Property)PAIRED)).booleanValue()) {
            pairing = true;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((Property)PAIRED, (Comparable)Boolean.valueOf(pairing));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            if (placer != null && placer.func_225608_bj_()) {
                return;
            }
            BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            if (this.BrickMatches(this, blockstate) && !((Boolean)blockstate.func_177229_b((Property)PAIRED)).booleanValue()) {
                worldIn.func_180501_a(blockpos, (BlockState)((BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)).func_176734_d())).func_206870_a((Property)PAIRED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_230547_a_(pos, Blocks.field_150350_a);
                state.func_235734_a_((IWorld)worldIn, pos, 3);
            }
        }
    }

    private boolean BrickMatches(BigBrickBlock thisBlock, BlockState suspect) {
        if (suspect.func_177230_c() instanceof BigBrickBlock) {
            BigBrickBlock b = (BigBrickBlock)suspect.func_177230_c();
            return b.TYPE == thisBlock.TYPE;
        }
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.equals((Object)stateIn.func_177229_b((Property)FACING)) && ((Boolean)stateIn.func_177229_b((Property)PAIRED)).booleanValue() && !this.BrickMatches(this, worldIn.func_180495_p(facingPos))) {
            return (BlockState)stateIn.func_206870_a((Property)PAIRED, (Comparable)Boolean.valueOf(false));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PAIRED});
    }

    public static enum BrickType {
        STONE,
        END_STONE;

    }
}

