/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import architectspalette.core.registry.APSounds;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CageLanternBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;
    private static final Map<Direction, VoxelShape> SHAPES = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.UP, (Object)Block.func_208617_a((double)5.0, (double)16.0, (double)6.0, (double)11.0, (double)10.0, (double)11.0)).put((Object)Direction.NORTH, (Object)Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)Block.func_208617_a((double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0, (double)10.0)).put((Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).put((Object)Direction.EAST, (Object)Block.func_208617_a((double)16.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0)).build();

    public CageLanternBlock(AbstractBlock.Properties properties, int poweredLightLevel) {
        super(properties.func_235838_a_(CageLanternBlock.getLightValueLit(poweredLightLevel)));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? lightValue : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, WATERLOGGED, FACING, INVERTED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (state.func_177229_b((Property)FACING) == facing && !state.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        boolean lit = this.getLitState(this.func_176223_P(), context.func_195991_k(), context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState newState = (BlockState)state.func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)INVERTED) == false));
        worldIn.func_180501_a(pos, (BlockState)newState.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(this.getLitState(newState, worldIn, pos))), 2);
        SoundEvent click = (Boolean)state.func_177229_b((Property)INVERTED) != false ? (SoundEvent)APSounds.CAGE_LANTERN_TOGGLE_OFF.get() : (SoundEvent)APSounds.CAGE_LANTERN_TOGGLE_ON.get();
        worldIn.func_184133_a(player, pos, click, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    private boolean getLitState(BlockState state, World world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)INVERTED) ^ world.func_175640_z(pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean shouldBeLit;
        boolean lit;
        if (!worldIn.field_72995_K && (lit = ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) != (shouldBeLit = this.getLitState(state, worldIn, pos))) {
            if (lit) {
                worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)LIT), 2);
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 2);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)LIT), 2);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        boolean shouldBeLit = this.getLitState(state, (World)worldIn, pos);
        if (shouldBeLit != (Boolean)state.func_177229_b((Property)LIT)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 2);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

