/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks;

import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SunstoneBlock
extends Block {
    public static final IntegerProperty LIGHT = IntegerProperty.func_177719_a((String)"light", (int)0, (int)2);
    public Function<World, Integer> lightSupplier;

    public SunstoneBlock(AbstractBlock.Properties properties, Function<World, Integer> getLightState) {
        super(properties);
        this.lightSupplier = getLightState;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIGHT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIGHT, (Comparable)this.lightSupplier.apply(context.func_195991_k()));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)LIGHT) * 7;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 100 + rand.nextInt(5));
        Integer lightstate = this.lightSupplier.apply((World)worldIn);
        if (!lightstate.equals(state.func_177229_b((Property)LIGHT))) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIGHT, (Comparable)lightstate));
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
    }

    public static Integer sunstoneLight(World world) {
        MinecraftServer s = world.func_73046_m();
        if (s == null) {
            return 0;
        }
        ServerWorld overworld = s.func_71218_a(World.field_234918_g_);
        if (overworld != null) {
            long time = overworld.func_72820_D() % 24000L;
            if (time >= 12000L) {
                return 0;
            }
            if (time >= 3000L && time <= 9000L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static Integer moonstoneLight(World world) {
        MinecraftServer s = world.func_73046_m();
        if (s == null) {
            return 0;
        }
        ServerWorld overworld = s.func_71218_a(World.field_234918_g_);
        if (overworld != null) {
            long time = (overworld.func_72820_D() + 12000L) % 24000L;
            if (time >= 12000L) {
                return 0;
            }
            if (time >= 3000L && time <= 9000L) {
                return 2;
            }
            return 1;
        }
        return 0;
    }
}

