/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks.abyssaline;

import architectspalette.common.blocks.abyssaline.IAbyssalineChargeable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AbyssalineHelper {
    public static final int CHARGE_LIGHT = 1;
    private static final int RECURSION_MAX = 12;

    public static boolean needsPostProcessing(BlockState stateIn, IBlockReader reader, BlockPos pos) {
        return ((IAbyssalineChargeable)stateIn.func_177230_c()).isCharged(stateIn);
    }

    public static boolean allowsMobSpawning(BlockState stateIn, IBlockReader reader, BlockPos pos, EntityType<?> entity) {
        return !((IAbyssalineChargeable)stateIn.func_177230_c()).isCharged(stateIn);
    }

    public static boolean isAbyssaline(BlockState stateIn) {
        return stateIn.func_177230_c() instanceof IAbyssalineChargeable;
    }

    public static boolean getCharged(BlockState stateIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.func_177230_c();
        return block.isCharged(stateIn);
    }

    public static boolean getOutputsFrom(BlockState stateIn, Direction faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.func_177230_c();
        return block.outputsChargeFrom(stateIn, faceIn);
    }

    public static boolean getAcceptsCharge(BlockState stateIn, Direction faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        IAbyssalineChargeable block = (IAbyssalineChargeable)stateIn.func_177230_c();
        return block.acceptsChargeFrom(stateIn, faceIn);
    }

    public static boolean getPushesPower(BlockState stateIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        return ((IAbyssalineChargeable)stateIn.func_177230_c()).pushesPower(stateIn);
    }

    public static boolean getPullsPower(BlockState stateIn, Direction faceIn) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return false;
        }
        return ((IAbyssalineChargeable)stateIn.func_177230_c()).pullsPowerFrom(stateIn, faceIn);
    }

    public static boolean isValidConnection(BlockState unpoweredState, BlockState poweringState, Direction unpoweredFace) {
        return (AbyssalineHelper.getAcceptsCharge(unpoweredState, unpoweredFace) || AbyssalineHelper.getPushesPower(poweringState)) && (AbyssalineHelper.getOutputsFrom(poweringState, unpoweredFace.func_176734_d()) || AbyssalineHelper.getCharged(poweringState) && AbyssalineHelper.getPullsPower(unpoweredState, unpoweredFace));
    }

    @Nullable
    public static BlockState getChargedState(BlockState stateIn, boolean charge) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.func_177230_c()).getStateWithCharge(stateIn, charge);
    }

    @Nullable
    public static BlockState getStateWithChargeDirection(BlockState stateIn, Direction faceOut) {
        if (!AbyssalineHelper.isAbyssaline(stateIn)) {
            return null;
        }
        return ((IAbyssalineChargeable)stateIn.func_177230_c()).getStateWithChargeDirection(stateIn, faceOut);
    }

    public static boolean createsChargeLoop(BlockState startState, IWorld world, BlockPos pos) {
        BlockPos.Mutable accumulator = new BlockPos(0, 0, 0).func_239590_i_();
        return AbyssalineHelper.checkForLoop(startState, world, pos, 12, accumulator, startState);
    }

    private static boolean checkForLoop(BlockState startState, IWorld world, BlockPos pos, int tries, BlockPos.Mutable accumulator, BlockState chainStarter) {
        Direction facing;
        if (!(startState.func_177230_c() instanceof IAbyssalineChargeable)) {
            return false;
        }
        IAbyssalineChargeable startBlock = (IAbyssalineChargeable)startState.func_177230_c();
        BlockPos offset = startBlock.getSourceOffset(startState);
        BlockPos nextPos = pos.func_177971_a((Vector3i)offset);
        if (nextPos == pos) {
            return false;
        }
        if (AbyssalineHelper.isAllZero((BlockPos)accumulator.func_196234_d(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()))) {
            return true;
        }
        if (AbyssalineHelper.isMagnitudeOne((BlockPos)accumulator) && tries < 12 && AbyssalineHelper.isValidConnection(AbyssalineHelper.getStateWithChargeDirection(chainStarter, facing = AbyssalineHelper.directionFromOffset((BlockPos)accumulator)), world.func_180495_p(pos.func_177972_a(facing)), facing)) {
            return true;
        }
        BlockState nextState = world.func_180495_p(nextPos);
        if (!AbyssalineHelper.getCharged(nextState)) {
            return true;
        }
        if (--tries > 0) {
            return AbyssalineHelper.checkForLoop(nextState, world, nextPos, tries, accumulator, chainStarter);
        }
        return false;
    }

    private static boolean isAllZero(BlockPos pos) {
        return pos.func_177956_o() == 0 && pos.func_177958_n() == 0 && pos.func_177952_p() == 0;
    }

    private static boolean isMagnitudeOne(BlockPos pos) {
        return Math.abs(pos.func_177956_o()) + Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177952_p()) == 1;
    }

    private static Direction directionFromOffset(BlockPos pos) {
        int x = Math.abs(pos.func_177958_n());
        int y = Math.abs(pos.func_177956_o());
        int z = Math.abs(pos.func_177952_p());
        int max = Math.max(Math.max(x, y), z);
        if (x == max) {
            return pos.func_177958_n() > 0 ? Direction.EAST : Direction.WEST;
        }
        if (y == max) {
            return pos.func_177956_o() > 0 ? Direction.UP : Direction.DOWN;
        }
        return pos.func_177952_p() > 0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static BlockState getStateWithNeighborCharge(BlockState stateIn, IWorld world, BlockPos pos) {
        Direction source = null;
        boolean powered = false;
        for (Direction side : Direction.values()) {
            BlockPos offset = pos.func_177972_a(side);
            BlockState state = world.func_180495_p(offset);
            if (!AbyssalineHelper.isValidConnection(stateIn, state, side) || AbyssalineHelper.createsChargeLoop(AbyssalineHelper.getStateWithChargeDirection(stateIn, side), world, pos)) continue;
            source = side;
            powered = true;
            break;
        }
        if (source != null) {
            return AbyssalineHelper.getChargedState(AbyssalineHelper.getStateWithChargeDirection(stateIn, source), powered);
        }
        return AbyssalineHelper.getChargedState(stateIn, false);
    }

    public static void abyssalineTick(BlockState state, ServerWorld worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, AbyssalineHelper.getStateWithNeighborCharge(state, (IWorld)worldIn, pos), 7);
    }

    public static void abyssalineNeighborUpdate(IAbyssalineChargeable thiz, BlockState stateIn, World worldIn, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        boolean interested;
        boolean bl = interested = !thiz.isCharged(stateIn) && neighborBlock instanceof IAbyssalineChargeable || !AbyssalineHelper.isValidConnection(stateIn, worldIn.func_180495_p(pos.func_177971_a((Vector3i)thiz.getSourceOffset(stateIn))), thiz.getSourceDirection(stateIn));
        if (neighborPos.equals((Object)pos.func_177971_a((Vector3i)thiz.getSourceOffset(stateIn))) || interested) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)((Block)thiz), 1);
        }
    }
}

