/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.blocks.abyssaline;

import architectspalette.common.blocks.abyssaline.AbyssalineHelper;
import architectspalette.common.blocks.abyssaline.IAbyssalineChargeable;
import architectspalette.common.blocks.abyssaline.NewAbyssalineBlock;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AbyssalinePillarBlock
extends RotatedPillarBlock
implements IAbyssalineChargeable {
    public AbyssalinePillarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NewAbyssalineBlock.CHARGE_SOURCE, (Comparable)Direction.NORTH)).func_206870_a((Property)NewAbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176298_M, NewAbyssalineBlock.CHARGED, NewAbyssalineBlock.CHARGE_SOURCE});
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return this.isCharged(state) ? 1 : 0;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        context.func_195991_k().func_205220_G_().func_205360_a(context.func_195995_a(), (Object)this, 1);
        return super.func_196258_a(context);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.func_176740_k() == stateIn.func_177229_b((Property)field_176298_M);
    }

    @Override
    public boolean outputsChargeFrom(BlockState stateIn, Direction faceIn) {
        return this.isCharged(stateIn) && faceIn != this.getSourceDirection(stateIn) && faceIn.func_176740_k() == stateIn.func_177229_b((Property)field_176298_M);
    }

    @Override
    public boolean pushesPower(BlockState stateIn) {
        return true;
    }

    @Override
    public boolean pullsPowerFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.func_176740_k() == stateIn.func_177229_b((Property)field_176298_M);
    }

    private static Direction directionFromAxis(Direction.Axis axis, Integer i) {
        switch (axis) {
            case X: {
                return i > 0 ? Direction.EAST : Direction.WEST;
            }
            case Y: {
                return i > 0 ? Direction.UP : Direction.DOWN;
            }
            case Z: {
                return i > 0 ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return Direction.UP;
    }

    private PillarSide fromScalar(int integer) {
        return integer > 0 ? PillarSide.FRONT : PillarSide.BACK;
    }

    private static enum PillarSide implements IStringSerializable
    {
        FRONT,
        BACK;


        public int toScalar() {
            return this == FRONT ? 1 : -1;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == FRONT ? "front" : "back";
        }
    }
}

