/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.common.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette")
public class TradingEventHandler {
    private static final Map<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ITrade>>> professionMap = new HashMap<VillagerProfession, Map<Integer, LinkedList<VillagerTrades.ITrade>>>();

    public static void add_trade(VillagerProfession prof, Integer level, VillagerTrades.ITrade trade) {
        professionMap.putIfAbsent(prof, new HashMap());
        professionMap.get(prof).putIfAbsent(level, new LinkedList());
        professionMap.get(prof).get(level).add(trade);
    }

    private static void clear_map() {
        professionMap.clear();
    }

    @SubscribeEvent
    public static void onTradesLoaded(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Map<Integer, LinkedList<VillagerTrades.ITrade>> prof_trades = professionMap.get(profession);
        if (prof_trades != null) {
            Int2ObjectMap trades = event.getTrades();
            trades.forEach((level, list) -> {
                if (prof_trades.containsKey(level)) {
                    list.addAll((Collection)prof_trades.get(level));
                }
            });
        }
    }
}

