/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core;

import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.data.GatherData;
import architectspalette.core.integration.APBlockData;
import architectspalette.core.integration.APCriterion;
import architectspalette.core.integration.APTrades;
import architectspalette.core.loot.WitheredBoneLootModifier;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.APItems;
import architectspalette.core.registry.APSounds;
import architectspalette.core.registry.APTileEntities;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="architects_palette")
public class ArchitectsPalette {
    public static final String MOD_ID = "architects_palette";
    public static final Logger LOGGER = LogManager.getLogger((String)"architects_palette".toUpperCase());
    public static ArchitectsPalette instance;

    public ArchitectsPalette() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        APSounds.SOUNDS.register(modEventBus);
        APBlocks.BLOCKS.register(modEventBus);
        APItems.ITEMS.register(modEventBus);
        APTileEntities.TILE_ENTITY_TYPES.register(modEventBus);
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerLootSerializers);
        GatherData.load();
    }

    void setupCommon(FMLCommonSetupEvent event) {
        APBlockData.registerFlammables();
        APBlockData.registerStrippables();
        APTrades.registerTrades();
        APCriterion.register();
    }

    void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(WarpingRecipe.TYPE.toString()), (Object)WarpingRecipe.TYPE);
        event.getRegistry().register((IForgeRegistryEntry)WarpingRecipe.SERIALIZER);
    }

    void registerLootSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)WitheredBoneLootModifier.SERIALIZER);
    }

    void setupClient(FMLClientSetupEvent event) {
        APBlockData.setupRenderLayers();
    }
}

