/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.effect.EffectProperties;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.source.FXSource;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.AssetLibrary;
import hellfirepvp.astralsorcery.common.util.Counter;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.order.DependencySorter;
import hellfirepvp.observerlib.common.util.AlternatingSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;

public final class EffectHandler {
    private static final Random STATIC_EFFECT_RAND = new Random();
    private static final EffectHandler INSTANCE = new EffectHandler();
    private boolean cleanRequested = false;
    private boolean acceptsNewEffects = false;
    private final List<PendingEffect> toAddBuffer = Lists.newLinkedList();
    private final AlternatingSet<FXSource<?, ?>> sources = new AlternatingSet();
    private final Map<BatchRenderContext<?>, List<PendingEffect>> effectMap = Maps.newLinkedHashMap();
    private List<BatchRenderContext<?>> orderedEffects = null;

    private EffectHandler() {
    }

    public static EffectHandler getInstance() {
        return INSTANCE;
    }

    public int getEffectCount() {
        Counter c = new Counter(0);
        this.effectMap.values().stream().flatMap(Collection::stream).forEach(p -> c.increment());
        return c.getValue();
    }

    public void render(MatrixStack renderStack, float pTicks) {
        if (this.orderedEffects == null || AssetLibrary.isReloading()) {
            return;
        }
        IDrawRenderTypeBuffer drawBuffer = IDrawRenderTypeBuffer.defaultBuffer();
        this.acceptsNewEffects = false;
        for (BatchRenderContext<?> ctx : this.orderedEffects) {
            List<PendingEffect> effects = this.effectMap.get(ctx);
            if (effects.isEmpty()) continue;
            ctx.renderAll(effects, renderStack, drawBuffer, pTicks);
        }
        this.acceptsNewEffects = true;
    }

    void tick() throws IOException {
        Entity rView;
        if (this.cleanRequested) {
            this.toAddBuffer.clear();
            this.sources.clear();
            this.effectMap.values().forEach(effects -> effects.stream().map(PendingEffect::getEffect).forEach(EntityComplexFX::flagAsRemoved));
            this.effectMap.values().forEach(List::clear);
            this.cleanRequested = false;
        }
        if ((rView = Minecraft.func_71410_x().func_175606_aa()) == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        if (rView == null) {
            EffectHandler.cleanUp();
            return;
        }
        if (this.orderedEffects == null) {
            this.orderedEffects = DependencySorter.getSorted(EffectTemplatesAS.LIST_ALL_RENDER_CONTEXT);
            this.orderedEffects.forEach(ctx -> {
                List cfr_ignored_0 = this.effectMap.put((BatchRenderContext<?>)ctx, new ArrayList());
            });
        }
        this.acceptsNewEffects = false;
        this.effectMap.values().forEach(l -> {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                PendingEffect effect = (PendingEffect)iterator.next();
                EntityVisualFX fx = effect.getEffect();
                ((EntityComplexFX)fx).tick();
                if (!fx.canRemove()) continue;
                iterator.remove();
                fx.flagAsRemoved();
            }
        });
        this.sources.forEach(src -> {
            src.tick();
            src.tickSpawnFX(new EffectRegistrar((FXSource)src));
            if (src.canRemove()) {
                src.flagAsRemoved();
                return false;
            }
            return true;
        });
        this.acceptsNewEffects = true;
        this.toAddBuffer.forEach(this::registerUnsafe);
        this.toAddBuffer.clear();
    }

    void queueSource(FXSource<?, ?> source) {
        this.sources.add(source);
    }

    void queueParticle(PendingEffect pendingEffect) {
        if (this.acceptsNewEffects) {
            this.registerUnsafe(pendingEffect);
        } else {
            this.toAddBuffer.add(pendingEffect);
        }
    }

    private void registerUnsafe(PendingEffect pendingEffect) {
        if (!this.mayAcceptParticle(pendingEffect.getProperties())) {
            return;
        }
        EntityVisualFX effect = pendingEffect.getEffect();
        BatchRenderContext<?> ctx = pendingEffect.getProperties().getContext();
        pendingEffect.getProperties().applySpecialEffects(effect);
        this.effectMap.get(ctx).add(pendingEffect);
        effect.setActive();
    }

    private boolean mayAcceptParticle(EffectProperties<?> properties) {
        if (properties.ignoresSpawnLimit()) {
            return true;
        }
        RenderingConfig.ParticleAmount cfg = (RenderingConfig.ParticleAmount)((Object)RenderingConfig.CONFIG.particleAmount.get());
        if (!Minecraft.func_71375_t()) {
            cfg = cfg.less();
        }
        return cfg.shouldSpawn(STATIC_EFFECT_RAND);
    }

    public static void cleanUp() {
        EffectHandler.getInstance().cleanRequested = true;
    }

    public static class PendingEffect {
        private final EntityVisualFX effect;
        private final EffectProperties<?> runProperties;

        PendingEffect(EntityVisualFX effect, EffectProperties<?> runProperties) {
            this.effect = effect;
            this.runProperties = runProperties;
        }

        EffectProperties<?> getProperties() {
            return this.runProperties;
        }

        public EntityVisualFX getEffect() {
            return this.effect;
        }
    }

    private static class EffectRegistrar<E extends EntityVisualFX>
    implements Function<Vector3, E> {
        private final FXSource<E, ?> source;

        private EffectRegistrar(FXSource<E, ?> source) {
            this.source = source;
        }

        @Override
        public E apply(Vector3 pos) {
            EffectHelper.Builder<E> prop = this.source.generateFX();
            Object fx = prop.getContext().makeParticle(pos);
            PendingEffect effect = new PendingEffect((EntityVisualFX)fx, (EffectProperties<?>)prop);
            EffectHandler.getInstance().registerUnsafe(effect);
            return (E)fx;
        }
    }
}

