/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.ConstellationDiscoveryScreen;
import hellfirepvp.astralsorcery.client.screen.base.SkyScreen;
import hellfirepvp.astralsorcery.client.screen.telescope.PlayerAngledConstellationInformation;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import org.lwjgl.opengl.GL11;

public class ScreenHandTelescope
extends ConstellationDiscoveryScreen<ConstellationDiscoveryScreen.DrawArea> {
    private static final int randomStars = 40;
    private final List<Point2D.Float> usedStars = new ArrayList<Point2D.Float>(40);

    public ScreenHandTelescope() {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.hand_telescope"), 216, 216);
    }

    @Override
    @Nonnull
    protected List<ConstellationDiscoveryScreen.DrawArea> createDrawAreas() {
        return Lists.newArrayList((Object[])new ConstellationDiscoveryScreen.DrawArea[]{new ConstellationDiscoveryScreen.DrawArea(this.getGuiBox())});
    }

    @Override
    protected void fillConstellations(WorldContext ctx, List<ConstellationDiscoveryScreen.DrawArea> drawAreas) {
        Random gen = ctx.getDayRandom();
        HashSet<IConstellation> used = new HashSet<IConstellation>();
        for (ConstellationDiscoveryScreen.DrawArea area : drawAreas) {
            ArrayList available = Lists.newArrayList(ctx.getActiveCelestialsHandler().getActiveConstellations());
            available.removeIf(c -> !(c instanceof IMajorConstellation) || used.contains(c) || !c.canDiscover((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ResearchHelper.getClientProgress()));
            IConstellation cst = (IConstellation)MiscUtils.getRandomEntry(available, gen);
            if (!(cst instanceof IMajorConstellation)) continue;
            used.add(cst);
            float yaw = gen.nextFloat() * 360.0f - 180.0f;
            float pitch = -90.0f + gen.nextFloat() * 25.0f;
            area.addConstellationToArea(cst, new PlayerAngledConstellationInformation(150.0f, yaw, pitch));
        }
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 6;
        int height = this.guiHeight - 6;
        for (int i = 0; i < 40; ++i) {
            this.usedStars.add(new Point2D.Float((float)offsetX + gen.nextFloat() * (float)width, (float)offsetY + gen.nextFloat() * (float)height));
        }
    }

    @Override
    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableDepthTest();
        super.func_230430_a_(renderStack, mouseX, mouseY, pTicks);
        this.drawWHRect(renderStack, TexturesAS.TEX_GUI_HAND_TELESCOPE);
        this.drawTelescopeCell(renderStack, pTicks);
    }

    private void drawTelescopeCell(MatrixStack renderStack, float pTicks) {
        boolean canSeeSky = this.canObserverSeeSky(Minecraft.func_71410_x().field_71439_g.func_233580_cy_(), 1);
        float pitch = Minecraft.func_71410_x().field_71439_g.func_195050_f(pTicks);
        float angleOpacity = 0.0f;
        if (pitch < -60.0f) {
            angleOpacity = 1.0f;
        } else if (pitch < -10.0f) {
            angleOpacity = (Math.abs(pitch) - 10.0f) / 50.0f;
            if (DayTimeHelper.isNight((World)Minecraft.func_71410_x().field_71441_e)) {
                angleOpacity *= angleOpacity;
            }
        }
        float brMultiplier = angleOpacity;
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.disableAlphaTest();
        this.func_230926_e_(-10);
        this.drawSkyBackground(renderStack, pTicks, canSeeSky, angleOpacity);
        if (!this.isInitialized()) {
            this.func_230926_e_(0);
            RenderSystem.enableAlphaTest();
            Blending.DEFAULT.apply();
            RenderSystem.disableBlend();
            return;
        }
        WorldContext ctx = SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
        if (ctx != null && canSeeSky) {
            Random gen = ctx.getDayRandom();
            double guiFactor = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
            float playerYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z % 360.0f;
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
            }
            if (playerYaw >= 180.0f) {
                playerYaw -= 360.0f;
            }
            float playerPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
            this.func_230926_e_(-9);
            float starSize = 5.0f;
            TexturesAS.TEX_STAR_1.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                for (Point2D.Float pos : this.usedStars) {
                    float brightness = 0.4f + RenderingConstellationUtils.stdFlicker(ClientScheduler.getClientTick(), pTicks, 10 + gen.nextInt(20)) * 0.5f;
                    brightness = this.multiplyStarBrightness(pTicks, brightness);
                    RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, pos.x + (float)this.getGuiLeft(), pos.y + (float)this.getGuiTop(), this.getGuiZLevel(), starSize, starSize).color(brightness *= brMultiplier, brightness, brightness, brightness).draw();
                }
            });
            this.func_230926_e_(-7);
            for (ConstellationDiscoveryScreen.DrawArea areas : this.getVisibleDrawAreas()) {
                for (IConstellation cst : areas.getDisplayMap().keySet()) {
                    ConstellationDiscoveryScreen.ConstellationDisplayInformation info = areas.getDisplayMap().get(cst);
                    info.getFrameDrawInformation().clear();
                    if (!(info instanceof PlayerAngledConstellationInformation)) continue;
                    PlayerAngledConstellationInformation cstInfo = (PlayerAngledConstellationInformation)info;
                    float diffYaw = playerYaw - cstInfo.getYaw();
                    float diffPitch = playerPitch - cstInfo.getPitch();
                    float maxDistance = 35.0f;
                    if (!(Math.abs(diffYaw) <= maxDistance) && !(Math.abs(playerYaw + 360.0f) <= maxDistance) || !(Math.abs(diffPitch) <= maxDistance)) continue;
                    float rainBr = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(pTicks);
                    int wPart = MathHelper.func_76141_d((float)((float)this.getGuiWidth() * 0.1f));
                    int hPart = MathHelper.func_76141_d((float)((float)this.getGuiHeight() * 0.1f));
                    float xFactor = diffYaw / 8.0f;
                    float yFactor = diffPitch / 8.0f;
                    GL11.glEnable((int)3089);
                    GL11.glScissor((int)MathHelper.func_76128_c((double)((double)(this.getGuiLeft() + 5) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.getGuiTop() + 5) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.getGuiWidth() - 10) * guiFactor)), (int)MathHelper.func_76128_c((double)((double)(this.getGuiHeight() - 10) * guiFactor)));
                    Map<StarLocation, Rectangle2D.Float> cstRenderInfo = RenderingConstellationUtils.renderConstellationIntoGUI(cst.getTierRenderColor(), cst, renderStack, this.getGuiLeft() + wPart + MathHelper.func_76128_c((double)((double)xFactor / guiFactor * (double)this.getGuiWidth())), this.getGuiTop() + hPart + MathHelper.func_76128_c((double)((double)yFactor / guiFactor * (double)this.getGuiHeight())), this.getGuiZLevel(), this.getGuiWidth() - MathHelper.func_76141_d((float)((float)wPart * 1.5f)), this.getGuiHeight() - MathHelper.func_76141_d((float)((float)hPart * 1.5f)), 2.0, () -> Float.valueOf((0.3f + 0.7f * RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + gen.nextInt(15))) * rainBr * brMultiplier), ResearchHelper.getClientProgress().hasConstellationDiscovered(cst), true);
                    GL11.glDisable((int)3089);
                    info.getFrameDrawInformation().putAll(cstRenderInfo);
                }
            }
            this.func_230926_e_(-5);
            this.renderDrawnLines(renderStack, gen, pTicks);
        }
        this.func_230926_e_(0);
        RenderSystem.enableAlphaTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
    }

    public void func_212927_b(double xPos, double yPos) {
        if (!Minecraft.func_71410_x().field_71417_B.func_198035_h()) {
            return;
        }
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 12;
        int height = this.guiHeight - 12;
        Minecraft mc = Minecraft.func_71410_x();
        double xDiff = mc.field_71417_B.func_198024_e() - xPos / ((double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        double yDiff = mc.field_71417_B.func_198026_f() - yPos / ((double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_195050_f(1.0f) <= -89.99f && yDiff > 0.0) {
            yDiff = 0.0;
        }
        for (Point2D.Float sl : this.usedStars) {
            sl.x = (float)((double)sl.x - xDiff);
            sl.y = (float)((double)sl.y + yDiff);
            if (sl.x < (float)offsetX) {
                sl.x += (float)width;
            } else if (sl.x > (float)(offsetX + width)) {
                sl.x -= (float)width;
            }
            if (sl.y < (float)offsetY) {
                sl.y += (float)height;
                continue;
            }
            if (!(sl.y > (float)(offsetY + height))) continue;
            sl.y -= (float)height;
        }
    }

    private void drawSkyBackground(MatrixStack renderStack, float pTicks, boolean canSeeSky, float angleOpacity) {
        Tuple<Color, Color> rgbFromTo = SkyScreen.getSkyGradient(canSeeSky, angleOpacity, pTicks);
        RenderingDrawUtils.drawGradientRect(renderStack, this.getGuiZLevel(), this.guiLeft + 4, this.guiTop + 4, this.guiLeft + this.guiWidth - 8, this.guiTop + this.guiHeight - 8, ((Color)rgbFromTo.func_76341_a()).getRGB(), ((Color)rgbFromTo.func_76340_b()).getRGB());
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }
}

