/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.client.screen.journal.bookmark.BookmarkProvider;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;

public class ScreenJournal
extends WidthHeightScreen {
    public static final int NO_BOOKMARK = -1;
    protected static List<BookmarkProvider> bookmarks = Lists.newArrayList();
    protected final int bookmarkIndex;
    protected Map<Rectangle, BookmarkProvider> drawnBookmarks = Maps.newHashMap();

    protected ScreenJournal(ITextComponent titleIn, int bookmarkIndex) {
        this(titleIn, 270, 420, bookmarkIndex);
    }

    public ScreenJournal(ITextComponent titleIn, int guiHeight, int guiWidth, int bookmarkIndex) {
        super(titleIn, guiHeight, guiWidth);
        this.bookmarkIndex = bookmarkIndex;
    }

    public static boolean addBookmark(BookmarkProvider bookmarkProvider) {
        int index = bookmarkProvider.getIndex();
        if (MiscUtils.contains(bookmarks, bm -> bm.getIndex() == index)) {
            return false;
        }
        bookmarks.add(bookmarkProvider);
        return true;
    }

    protected IReorderingProcessor localize(ITextProperties txt) {
        return LanguageMap.func_74808_a().func_241870_a(txt);
    }

    protected void drawDefault(MatrixStack renderStack, AbstractRenderableTexture texture, int mouseX, int mouseY) {
        this.func_230926_e_(100);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.drawWHRect(renderStack, texture);
        RenderSystem.disableBlend();
        this.drawBookmarks(renderStack, mouseX, mouseY);
        this.func_230926_e_(0);
    }

    private void drawBookmarks(MatrixStack renderStack, int mouseX, int mouseY) {
        this.drawnBookmarks.clear();
        int bookmarkWidth = 67;
        int bookmarkHeight = 15;
        float bookmarkGap = 18.0f;
        float offsetX = (float)(this.guiLeft + this.guiWidth) - 17.25f;
        float offsetY = this.guiTop + 20;
        bookmarks.sort(Comparator.comparing(BookmarkProvider::getIndex));
        for (BookmarkProvider bookmarkProvider : bookmarks) {
            if (!bookmarkProvider.canSee()) continue;
            Rectangle r = this.drawBookmark(renderStack, offsetX, offsetY, bookmarkWidth, bookmarkHeight, bookmarkWidth + (this.bookmarkIndex == bookmarkProvider.getIndex() ? 0 : 5), this.getGuiZLevel(), bookmarkProvider.getUnlocalizedName(), -572662307, mouseX, mouseY, bookmarkProvider.getTextureBookmark(), bookmarkProvider.getTextureBookmarkStretched());
            this.drawnBookmarks.put(r, bookmarkProvider);
            offsetY += bookmarkGap;
        }
    }

    private Rectangle drawBookmark(MatrixStack renderStack, float offsetX, float offsetY, int width, int height, int mouseOverWidth, float zLevel, IFormattableTextComponent title, int titleRGBColor, int mouseX, int mouseY, AbstractRenderableTexture texture, AbstractRenderableTexture textureStretched) {
        texture.bindTexture();
        Rectangle r = new Rectangle(MathHelper.func_76141_d((float)offsetX), MathHelper.func_76141_d((float)offsetY), MathHelper.func_76141_d((float)width), MathHelper.func_76141_d((float)height));
        if (r.contains(mouseX, mouseY)) {
            if (mouseOverWidth > width) {
                textureStretched.bindTexture();
            }
            width = mouseOverWidth;
            r = new Rectangle(MathHelper.func_76141_d((float)offsetX), MathHelper.func_76141_d((float)offsetY), MathHelper.func_76141_d((float)width), MathHelper.func_76141_d((float)height));
        }
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        int actualWidth = width;
        RenderingUtils.draw(7, DefaultVertexFormats.field_181707_g, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, offsetX, offsetY, zLevel, actualWidth, height).draw());
        RenderSystem.disableBlend();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)(offsetX + 2.0f), (double)(offsetY + 4.0f), (double)(zLevel + 50.0f));
        renderStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        RenderingDrawUtils.renderStringAt(null, renderStack, (ITextProperties)title, titleRGBColor);
        renderStack.func_227865_b_();
        return r;
    }

    protected boolean handleBookmarkClick(double mouseX, double mouseY) {
        return this.handleJournalNavigationBookmarkClick(mouseX, mouseY);
    }

    private boolean handleJournalNavigationBookmarkClick(double mouseX, double mouseY) {
        for (Rectangle bookmarkRectangle : this.drawnBookmarks.keySet()) {
            BookmarkProvider provider = this.drawnBookmarks.get(bookmarkRectangle);
            if (this.bookmarkIndex == provider.getIndex() || !bookmarkRectangle.contains(mouseX, mouseY)) continue;
            ScreenJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a(provider.getGuiScreen());
            return true;
        }
        return false;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

