/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.NavigationArrowScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalConstellationDetail;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ScreenJournalConstellationOverview
extends ScreenJournal
implements NavigationArrowScreen {
    private static final int CONSTELLATIONS_PER_PAGE = 4;
    private static final int width = 80;
    private static final int height = 110;
    private static final Map<Integer, Point> offsetMap = new HashMap<Integer, Point>();
    private final List<IConstellation> constellations;
    private final int pageId;
    private final Map<Rectangle, IConstellation> rectCRenderMap = new HashMap<Rectangle, IConstellation>();
    private Rectangle rectPrev;
    private Rectangle rectNext;

    private ScreenJournalConstellationOverview(int pageId, List<IConstellation> constellations) {
        super((ITextComponent)new TranslationTextComponent("screen.astralsorcery.tome.constellations"), 20);
        this.constellations = constellations;
        this.pageId = pageId;
    }

    private ScreenJournalConstellationOverview(List<IConstellation> constellations) {
        this(0, constellations);
    }

    public static ScreenJournal getConstellationScreen() {
        PlayerProgress client = ResearchHelper.getClientProgress();
        return new ScreenJournalConstellationOverview(client.getSeenConstellations().stream().map(ConstellationRegistry::getConstellation).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        this.drawConstellationBackground(renderStack);
        this.drawDefault(renderStack, TexturesAS.TEX_GUI_BOOK_FRAME_FULL, mouseX, mouseY);
        this.func_230926_e_(250);
        this.drawNavArrows(renderStack, pTicks, mouseX, mouseY);
        this.drawConstellations(renderStack, pTicks, mouseX, mouseY);
        this.func_230926_e_(0);
    }

    private void drawConstellationBackground(MatrixStack renderStack) {
        TexturesAS.TEX_BLACK.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + this.guiHeight - 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + this.guiWidth - 15), (float)(this.guiTop + this.guiHeight - 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + this.guiWidth - 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        TexturesAS.TEX_GUI_BACKGROUND_CONSTELLATIONS.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + this.guiHeight - 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.1f, 0.9f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + this.guiWidth - 15), (float)(this.guiTop + this.guiHeight - 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.9f, 0.9f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + this.guiWidth - 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.9f, 0.1f).func_181675_d();
            buf.func_227888_a_(offset, (float)(this.guiLeft + 15), (float)(this.guiTop + 10), (float)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.1f, 0.1f).func_181675_d();
        });
        RenderSystem.disableBlend();
    }

    private void drawConstellations(MatrixStack renderStack, float partial, int mouseX, int mouseY) {
        this.rectCRenderMap.clear();
        List<IConstellation> cs = this.constellations.subList(this.pageId * 4, Math.min((this.pageId + 1) * 4, this.constellations.size()));
        for (int i = 0; i < cs.size(); ++i) {
            IConstellation c = cs.get(i);
            Point p = offsetMap.get(i);
            Rectangle cstRct = this.drawConstellation(renderStack, c, this.guiLeft + p.x, this.guiTop + p.y, this.getGuiZLevel(), partial, mouseX, mouseY);
            this.rectCRenderMap.put(cstRct, c);
        }
    }

    private Rectangle drawConstellation(MatrixStack renderStack, IConstellation display, double offsetX, double offsetY, float zLevel, float partial, int mouseX, int mouseY) {
        Rectangle rect = new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), 80, 110);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(offsetX + 40.0, offsetY + 40.0, (double)zLevel);
        if (rect.contains(mouseX, mouseY)) {
            renderStack.func_227862_a_(1.1f, 1.1f, 1.0f);
        }
        renderStack.func_227861_a_(-40.0, -40.0, (double)zLevel);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Random rand = new Random(4726142277924544921L);
        RenderingConstellationUtils.renderConstellationIntoGUI(display.getConstellationColor(), display, renderStack, 0.0f, 0.0f, 0.0f, 95.0f, 95.0f, 1.6f, () -> Float.valueOf(0.5f + 0.5f * RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), partial, 12 + rand.nextInt(10))), true, false);
        RenderSystem.disableBlend();
        IFormattableTextComponent cstName = display.getConstellationName();
        float fullLength = 40.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)cstName) / 2.0f;
        renderStack.func_227861_a_((double)fullLength, 90.0, 10.0);
        RenderingDrawUtils.renderStringAt((ITextProperties)cstName, renderStack, this.field_230712_o_, -1143087651, false);
        renderStack.func_227865_b_();
        return rect;
    }

    private void drawNavArrows(MatrixStack renderStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.rectNext = null;
        this.rectPrev = null;
        int cIndex = this.pageId * 4;
        if (cIndex > 0) {
            this.rectPrev = this.drawArrow(renderStack, this.guiLeft + 15, this.guiTop + 127, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        }
        int nextIndex = cIndex + 4;
        if (this.constellations.size() >= nextIndex + 1) {
            this.rectNext = this.drawArrow(renderStack, this.guiLeft + 367, this.guiTop + 127, this.getGuiZLevel(), NavigationArrowScreen.Type.RIGHT, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton != 0) {
            return false;
        }
        if (this.handleBookmarkClick(mouseX, mouseY)) {
            return true;
        }
        for (Rectangle r : this.rectCRenderMap.keySet()) {
            if (!r.contains(mouseX, mouseY)) continue;
            IConstellation c = this.rectCRenderMap.get(r);
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenJournalConstellationDetail(this, c));
        }
        if (this.rectPrev != null && this.rectPrev.contains(mouseX, mouseY)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenJournalConstellationOverview(this.pageId - 1, this.constellations));
            return true;
        }
        if (this.rectNext != null && this.rectNext.contains(mouseX, mouseY)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenJournalConstellationOverview(this.pageId + 1, this.constellations));
            return true;
        }
        return false;
    }

    static {
        offsetMap.put(0, new Point(45, 55));
        offsetMap.put(1, new Point(125, 105));
        offsetMap.put(2, new Point(200, 45));
        offsetMap.put(3, new Point(280, 110));
    }
}

