/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.sky;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.data.config.entry.RenderingConfig;
import hellfirepvp.astralsorcery.client.sky.astral.AstralSkyRenderer;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ISkyRenderHandler;

public class ChainingSkyRenderer
implements ISkyRenderHandler {
    private final ISkyRenderHandler existingSkyRenderer;

    public ChainingSkyRenderer(ISkyRenderHandler existingSkyRenderer) {
        this.existingSkyRenderer = existingSkyRenderer;
    }

    public void render(int ticks, float partialTicks, MatrixStack renderStack, ClientWorld world, Minecraft mc) {
        EventFlags.SKY_RENDERING.executeWithFlag(() -> {
            RegistryKey dim = world.func_234923_W_();
            if (world.func_239132_a_().func_241683_c_() == DimensionRenderInfo.FogType.NORMAL) {
                if (((List)RenderingConfig.CONFIG.dimensionsWithOnlyConstellationRendering.get()).contains(dim.func_240901_a_())) {
                    if (this.existingSkyRenderer != null) {
                        this.existingSkyRenderer.render(ticks, partialTicks, renderStack, world, mc);
                    } else {
                        ISkyRenderHandler existing = world.func_239132_a_().getSkyRenderHandler();
                        world.func_239132_a_().setSkyRenderHandler(null);
                        Minecraft.func_71410_x().field_71438_f.func_228424_a_(renderStack, partialTicks);
                        world.func_239132_a_().setSkyRenderHandler(existing);
                    }
                    this.renderConstellations(world, renderStack, partialTicks);
                } else {
                    AstralSkyRenderer.INSTANCE.render(ticks, partialTicks, renderStack, world, mc);
                }
            } else {
                ISkyRenderHandler existing = world.func_239132_a_().getSkyRenderHandler();
                world.func_239132_a_().setSkyRenderHandler(null);
                Minecraft.func_71410_x().field_71438_f.func_228424_a_(renderStack, partialTicks);
                world.func_239132_a_().setSkyRenderHandler(existing);
            }
        });
    }

    private void renderConstellations(ClientWorld world, MatrixStack renderStack, float pTicks) {
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.ADDITIVE_ALPHA.apply();
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)false);
        float alphaSubRain = 1.0f - world.func_72867_j(pTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaSubRain);
        renderStack.func_227860_a_();
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        AstralSkyRenderer.renderConstellationsSky(world, renderStack, pTicks);
        renderStack.func_227865_b_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableTexture();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }
}

