/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.color.ColorThief;
import hellfirepvp.astralsorcery.common.util.ColorUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.Unit;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.resource.SelectiveReloadStateHandler;
import net.minecraftforge.resource.VanillaResourceType;

public class ColorizationHelper {
    private static final Map<Item, Optional<Color>> itemColors = new HashMap<Item, Optional<Color>>();
    private static final Map<Fluid, Optional<Color>> fluidColors = new HashMap<Fluid, Optional<Color>>();

    private ColorizationHelper() {
    }

    @Nonnull
    public static Optional<Color> getColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        Item i = stack.func_77973_b();
        if (!itemColors.containsKey(i)) {
            TextureAtlasSprite tas = RenderingUtils.getParticleTexture(stack);
            if (tas != null) {
                itemColors.put(i, ColorizationHelper.getDominantColor(tas));
            } else {
                itemColors.put(i, Optional.empty());
            }
        }
        return itemColors.get(i).map(c -> ColorUtils.overlayColor(c, new Color(ColorUtils.getOverlayColor(stack))));
    }

    @Nonnull
    public static Optional<Color> getColor(FluidStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Fluid fluid = stack.getFluid();
        if (!fluidColors.containsKey(fluid)) {
            TextureAtlasSprite tas = RenderingUtils.getParticleTexture(stack);
            if (tas != null) {
                fluidColors.put(fluid, ColorizationHelper.getDominantColor(tas));
            } else {
                fluidColors.put(fluid, Optional.empty());
            }
        }
        return fluidColors.get(fluid).map(c -> ColorUtils.overlayColor(c, new Color(ColorUtils.getOverlayColor(stack))));
    }

    private static Optional<Color> getDominantColor(TextureAtlasSprite tas) {
        if (tas == null) {
            return Optional.empty();
        }
        try {
            BufferedImage extractedImage = ColorizationHelper.extractImage(tas);
            int[] dominantColor = ColorThief.getColor(extractedImage);
            int color = (dominantColor[0] & 0xFF) << 16 | (dominantColor[1] & 0xFF) << 8 | dominantColor[2] & 0xFF;
            return Optional.of(new Color(color));
        }
        catch (Exception exc) {
            AstralSorcery.log.error("Item Colorization Helper: Ignoring non-resolvable image " + tas.func_195668_m().toString());
            exc.printStackTrace();
            return Optional.empty();
        }
    }

    @Nullable
    private static BufferedImage extractImage(TextureAtlasSprite tas) {
        int w = tas.func_94211_a();
        int h = tas.func_94216_b();
        int count = tas.func_110970_k();
        if (w <= 0 || h <= 0 || count <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(w, h * count, 6);
        for (int i = 0; i < count; ++i) {
            int[] pxArray = new int[tas.func_94211_a() * tas.func_94216_b()];
            for (int xx = 0; xx < tas.func_94211_a(); ++xx) {
                for (int zz = 0; zz < tas.func_94216_b(); ++zz) {
                    int argb = tas.getPixelRGBA(0, xx, zz + i * tas.func_94216_b());
                    pxArray[zz * tas.func_94211_a() + xx] = argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
                }
            }
            bufferedImage.setRGB(0, i * h, w, h, pxArray, 0, w);
        }
        return bufferedImage;
    }

    public static IFutureReloadListener onReload() {
        return (stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> {
            if (!SelectiveReloadStateHandler.INSTANCE.get().test(VanillaResourceType.TEXTURES)) {
                return;
            }
            itemColors.clear();
            fluidColors.clear();
        });
    }
}

