/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.base.CEffectAbstractList;
import hellfirepvp.astralsorcery.common.constellation.effect.base.ListEntries;
import hellfirepvp.astralsorcery.common.event.PlayerAffectionFlags;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.block.ILocatable;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockPositionGenerator;
import hellfirepvp.astralsorcery.common.util.block.iterator.BlockSpherePositionGenerator;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CEffectEvorsio
extends CEffectAbstractList<ListEntries.PosEntry> {
    public static PlayerAffectionFlags.AffectionFlag FLAG = CEffectEvorsio.makeAffectionFlag("evorsio");
    public static EvorsioConfig CONFIG = new EvorsioConfig();

    public CEffectEvorsio(@Nonnull ILocatable origin) {
        super(origin, ConstellationsAS.evorsio, 1, (world, pos, state) -> true);
        this.excludeRitualPositions();
    }

    @Override
    @Nonnull
    protected BlockPositionGenerator createPositionStrategy() {
        return new BlockSpherePositionGenerator();
    }

    @Override
    @Nullable
    public ListEntries.PosEntry recreateElement(CompoundNBT tag, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @Nullable
    public ListEntries.PosEntry createElement(World world, BlockPos pos) {
        return new ListEntries.PosEntry(pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float alphaMultiplier, boolean extended) {
        float addY = 1.0f;
        if (!pedestal.func_174877_v().equals((Object)pos)) {
            addY = 0.0f;
        }
        Vector3 motion = Vector3.random().multiply(0.1);
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5).addY(addY))).alpha(VFXAlphaFunction.FADE_OUT)).setMotion(motion)).color(VFXColorFunction.constant(ColorsAS.CONSTELLATION_EVORSIO))).setScaleMultiplier(0.3f + rand.nextFloat() * 0.4f)).setMaxAge(50);
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, ConstellationEffectProperties properties, @Nullable IMinorConstellation trait) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        return this.peekNewPosition(world, pos, properties).mapLeft(newEntry -> {
            BlockPos at = newEntry.getPos();
            if (properties.isCorrupted()) {
                if (at.func_177956_o() < pos.func_177956_o() && world.func_175623_d(at)) {
                    double distance = pos.func_177951_i((Vector3i)at) / (properties.getSize() * properties.getSize());
                    BlockState state = Blocks.field_150347_e.func_176223_P();
                    if (distance >= (double)0.85f && rand.nextInt(4) == 0) {
                        state = Blocks.field_150346_d.func_176223_P();
                    }
                    if (distance <= 0.25) {
                        state = Blocks.field_150348_b.func_176223_P();
                    } else if (distance <= (double)0.1f && rand.nextInt(5) == 0) {
                        state = Blocks.field_150343_Z.func_176223_P();
                    }
                    world.func_180501_a(at, state, 11);
                }
                return false;
            }
            TileRitualPedestal pedestal = this.getPedestal(world, pos);
            if (pedestal != null) {
                BlockState state = world.func_180495_p(at);
                if (this.canBreakBlock(world, at, state, this.buildFilter(pedestal))) {
                    BlockDropCaptureAssist.startCapturing();
                    try {
                        BlockUtils.breakBlockWithoutPlayer((ServerWorld)world, at, state, ItemStack.field_190927_a, true, true);
                    }
                    finally {
                        NonNullList<ItemStack> captured = BlockDropCaptureAssist.getCapturedStacksAndStop();
                        captured.forEach(stack -> ItemUtils.dropItemNaturally(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, stack));
                    }
                    return true;
                }
                this.sendConstellationPing(world, new Vector3((Vector3i)at).add(0.5, 0.5, 0.5));
            }
            return false;
        }).ifRight(attemptedBreak -> this.sendConstellationPing(world, new Vector3((Vector3i)attemptedBreak).add(0.5, 0.5, 0.5))).left().orElse(false);
    }

    private boolean canBreakBlock(World world, BlockPos pos, BlockState state, Predicate<BlockState> blacklist) {
        if (blacklist.test(state)) {
            return false;
        }
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (hardness < 0.0f || hardness >= 75.0f) {
            return false;
        }
        return !state.isAir((IBlockReader)world, pos);
    }

    private Predicate<BlockState> buildFilter(TileRitualPedestal pedestal) {
        List<Predicate<BlockState>> filteredBlocks = pedestal.getConfiguredBlockStates().stream().map(blockState -> blockState::equals).collect(Collectors.toList());
        this.addDefaultBreakBlacklist(filteredBlocks);
        return blockState -> {
            for (Predicate filterTest : filteredBlocks) {
                if (!filterTest.test(blockState)) continue;
                return true;
            }
            return false;
        };
    }

    private void addDefaultBreakBlacklist(List<Predicate<BlockState>> out) {
        out.add(state -> state.func_177230_c().equals(BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL));
        out.add(state -> state.func_177230_c().equals(BlocksAS.ROCK_COLLECTOR_CRYSTAL));
        out.add(state -> state.func_177230_c().equals(BlocksAS.LENS));
        out.add(state -> state.func_177230_c().equals(BlocksAS.PRISM));
    }

    @Override
    public ConstellationEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    public PlayerAffectionFlags.AffectionFlag getPlayerAffectionFlag() {
        return FLAG;
    }

    private static class EvorsioConfig
    extends ConstellationEffect.Config {
        public EvorsioConfig() {
            super("evorsio", 6.0, 1.0);
        }
    }
}

