/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectArmara
extends MantleEffect {
    public static ArmaraConfig CONFIG = new ArmaraConfig();

    public MantleEffectArmara() {
        super(ConstellationsAS.armara);
    }

    @Override
    protected void attachEventListeners(IEventBus bus) {
        super.attachEventListeners(bus);
        bus.addListener(EventPriority.HIGH, this::onHurt);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        super.tickServer(player);
        if (this.getCurrentImmunityStacks((LivingEntity)player) >= (Integer)MantleEffectArmara.CONFIG.immunityStacks.get()) {
            this.setCurrentImmunityRechargeTick((LivingEntity)player, (Integer)MantleEffectArmara.CONFIG.immunityRechargeTicks.get());
            return;
        }
        int tick = this.getCurrentImmunityRechargeTick((LivingEntity)player);
        if (--tick <= 0) {
            if (AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectArmara.CONFIG.chargeCostPerStack.get()).intValue())) {
                this.setCurrentImmunityRechargeTick((LivingEntity)player, (Integer)MantleEffectArmara.CONFIG.immunityRechargeTicks.get());
                this.setCurrentImmunityStacks((LivingEntity)player, this.getCurrentImmunityStacks((LivingEntity)player) + 1);
                AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectArmara.CONFIG.chargeCostPerStack.get()).intValue(), false);
            }
        } else {
            this.setCurrentImmunityRechargeTick((LivingEntity)player, tick);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.15f);
        Vector3 at = Vector3.atEntityCorner((Entity)player);
        at.addY(player.func_213302_cg() / 3.0f * 2.0f);
        Vector3 lookVec = new Vector3(player.func_70040_Z()).normalize();
        int stacks = this.getCurrentImmunityStacks((LivingEntity)player);
        if (stacks > 0) {
            Random sRand = new Random(player.func_110124_au().hashCode());
            for (int i = 0; i < stacks; ++i) {
                float deg;
                Vector3 axis = Vector3.random(sRand);
                axis.setX(axis.getX() * (double)0.35f);
                axis.setZ(axis.getZ() * (double)0.35f);
                Vector3 perpEffect = axis.clone().perpendicular();
                float scale = rand.nextFloat() * 0.2f + 0.2f;
                int ticksPerCircle = 80 + sRand.nextInt(50);
                int tick = player.field_70173_aa % ticksPerCircle;
                Vector3 anglePlayer = perpEffect.normalize().rotate(Math.toRadians(360.0f * ((float)tick / (float)ticksPerCircle)), axis).normalize();
                Vector3 pos = anglePlayer.clone().multiply(sRand.nextFloat() * 0.4f + 0.9f).add(at);
                float alpha = 0.8f;
                if (Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a() && (deg = (float)Math.toDegrees(lookVec.angle(anglePlayer))) < 70.0f) {
                    float tansparentDegree = 40.0f;
                    alpha *= MathHelper.func_76131_a((float)((deg - tansparentDegree) / (80.0f - tansparentDegree)), (float)0.0f, (float)1.0f);
                }
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setAlphaMultiplier(alpha)).color(VFXColorFunction.constant(ColorsAS.MANTLE_ARMARA_STACKS))).setScaleMultiplier(scale)).setMaxAge(20 + rand.nextInt(20));
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setAlphaMultiplier(alpha)).color(VFXColorFunction.WHITE)).setScaleMultiplier(scale * 0.4f)).setMaxAge(10 + rand.nextInt(10));
            }
        }
    }

    private void onHurt(LivingHurtEvent event) {
        World world = event.getEntity().func_130014_f_();
        LivingEntity hurt = event.getEntityLiving();
        if (world.func_201670_d()) {
            return;
        }
        MantleEffectArmara armara = (MantleEffectArmara)((Object)ItemMantle.getEffect(hurt, (IWeakConstellation)ConstellationsAS.armara));
        if (armara != null && this.shouldPreventDamage(hurt, event.getSource(), false)) {
            event.setCanceled(true);
        }
    }

    private boolean shouldPreventDamage(LivingEntity hurt, DamageSource source, boolean simulate) {
        if (source.func_76357_e()) {
            return false;
        }
        int stacks = this.getCurrentImmunityStacks(hurt);
        if (stacks <= 0) {
            return false;
        }
        if (!simulate) {
            this.setCurrentImmunityStacks(hurt, --stacks);
        }
        return true;
    }

    private int getCurrentImmunityRechargeTick(LivingEntity entity) {
        return this.getData(entity).func_74762_e("ITick");
    }

    private void setCurrentImmunityRechargeTick(LivingEntity entity, int tick) {
        this.getData(entity).func_74768_a("ITick", tick);
    }

    private int getCurrentImmunityStacks(LivingEntity entity) {
        return this.getData(entity).func_74762_e("IStacks");
    }

    private void setCurrentImmunityStacks(LivingEntity entity, int stacks) {
        this.getData(entity).func_74768_a("IStacks", stacks);
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static class ArmaraConfig
    extends MantleEffect.Config {
        private final int defaultImmunityStacks = 3;
        private final int defaultImmunityRechargeTicks = 300;
        private final int defaultChargeCostPerStack = 750;
        public ForgeConfigSpec.IntValue immunityStacks;
        public ForgeConfigSpec.IntValue immunityRechargeTicks;
        public ForgeConfigSpec.IntValue chargeCostPerStack;

        public ArmaraConfig() {
            super("armara");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.immunityStacks = cfgBuilder.comment("Set the max amount of immunity stacks.").translation(this.translationKey("immunityStacks")).defineInRange("immunityStacks", this.defaultImmunityStacks, 0, 10);
            this.immunityRechargeTicks = cfgBuilder.comment("Sets the amount of ticks between immunity stack recharges.").translation(this.translationKey("immunityRechargeTicks")).defineInRange("immunityRechargeTicks", this.defaultImmunityRechargeTicks, 20, 1000000);
            this.chargeCostPerStack = cfgBuilder.comment("Set the amount alignment charge consumed per created immunity stack").translation(this.translationKey("chargeCostPerStack")).defineInRange("chargeCostPerStack", this.defaultChargeCostPerStack, 0, 1000);
        }
    }
}

