/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.crafting.helper.ingredient.FluidIngredient;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredientSerializer
implements IIngredientSerializer<FluidIngredient> {
    public FluidIngredient parse(JsonObject json) {
        if (!json.has("fluid")) {
            throw new JsonSyntaxException("Expected an array at 'fluid' or a single fluid defined at key 'fluid'.");
        }
        ArrayList<FluidStack> foundFluids = new ArrayList<FluidStack>();
        JsonElement element = json.get("fluid");
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(e -> {
                if (e.isJsonObject()) {
                    JsonObject object = e.getAsJsonObject();
                    ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"fluid"));
                    if (!ForgeRegistries.FLUIDS.containsKey(key)) {
                        throw new JsonSyntaxException("Unknown fluid '" + key + "'");
                    }
                    int amount = 1000;
                    if (object.has("amount")) {
                        amount = JSONUtils.func_151203_m((JsonObject)object, (String)"amount");
                    }
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(key);
                    foundFluids.add(new FluidStack(fluid, amount));
                } else if (e.isJsonPrimitive()) {
                    ResourceLocation key = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)"fluid"));
                    if (!ForgeRegistries.FLUIDS.containsKey(key)) {
                        throw new JsonSyntaxException("Unknown fluid '" + key + "'");
                    }
                    Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(key);
                    foundFluids.add(new FluidStack(fluid, 1000));
                } else {
                    throw new JsonSyntaxException("Value at key 'fluid' has to be a fluid name or an array of fluid names or objects containing 'fluid'.");
                }
            });
        } else if (element.isJsonPrimitive()) {
            ResourceLocation key = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)element, (String)"fluid"));
            if (!ForgeRegistries.FLUIDS.containsKey(key)) {
                throw new JsonSyntaxException("Unknown fluid '" + key + "'");
            }
            int amount = 1000;
            if (json.has("amount")) {
                amount = JSONUtils.func_151203_m((JsonObject)json, (String)"amount");
            }
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(key);
            foundFluids.add(new FluidStack(fluid, amount));
        } else {
            throw new JsonSyntaxException("Value at key 'fluid' has to be a fluid name or an array of fluid names or objects containing 'fluid'.");
        }
        return new FluidIngredient(foundFluids);
    }

    public FluidIngredient parse(PacketBuffer buffer) {
        return new FluidIngredient(ByteBufUtils.readList(buffer, ByteBufUtils::readFluidStack));
    }

    public void write(PacketBuffer buffer, FluidIngredient ingredient) {
        ByteBufUtils.writeCollection(buffer, ingredient.getFluids(), ByteBufUtils::writeFluidStack);
    }
}

