/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidRarityEntry
implements ConfigDataSet {
    private final ResourceLocation fluidName;
    private final int guaranteedAmount;
    private final int additionalRandomAmount;
    private final int rarity;

    public FluidRarityEntry(ResourceLocation fluidName, int rarity, int guaranteedAmount) {
        this(fluidName, rarity, guaranteedAmount, guaranteedAmount / 2);
    }

    public FluidRarityEntry(ResourceLocation fluidName, int rarity, int guaranteedAmount, int additionalRandomAmount) {
        this.fluidName = fluidName;
        this.rarity = rarity;
        this.guaranteedAmount = guaranteedAmount;
        this.additionalRandomAmount = additionalRandomAmount;
    }

    public Fluid getFluid() {
        return (Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidName);
    }

    public int getRarity() {
        return this.rarity;
    }

    public int getRandomAmount(Random rand) {
        return this.guaranteedAmount + (this.additionalRandomAmount > 0 ? rand.nextInt(this.additionalRandomAmount) : 0);
    }

    @Override
    @Nonnull
    public String serialize() {
        return this.fluidName + ";" + this.guaranteedAmount + ";" + this.additionalRandomAmount + ";" + this.rarity;
    }

    @Nullable
    public static FluidRarityEntry deserialize(String str) throws IllegalArgumentException {
        int rarity;
        int randomAmt;
        int guaranteed;
        String[] split = str.split(";");
        if (split.length != 4) {
            return null;
        }
        ResourceLocation fluidName = new ResourceLocation(split[0]);
        if (ForgeRegistries.FLUIDS.getValue(fluidName) == null) {
            throw new IllegalArgumentException("Unknown Fluid: " + fluidName);
        }
        String strGAmount = split[1];
        String strRAmount = split[2];
        String strRarity = split[3];
        try {
            guaranteed = Integer.parseInt(strGAmount);
            randomAmt = Integer.parseInt(strRAmount);
            rarity = Integer.parseInt(strRarity);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new FluidRarityEntry(fluidName, rarity, guaranteed, randomAmt);
    }
}

