/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PerkAllocationType;
import hellfirepvp.astralsorcery.common.data.research.PerkRemovalResult;
import hellfirepvp.astralsorcery.common.data.research.PlayerPerkAllocation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.perk.PerkTree;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PlayerPerkData {
    private Set<ResourceLocation> freePointTokens = new HashSet<ResourceLocation>();
    private Map<AbstractPerk, AppliedPerk> perks = new HashMap<AbstractPerk, AppliedPerk>();
    private double perkExp = 0.0;

    public Collection<AbstractPerk> getSealedPerks() {
        return this.perks.values().stream().filter(AppliedPerk::isSealed).map(AppliedPerk::getPerk).collect(Collectors.toList());
    }

    public Collection<AbstractPerk> getEffectGrantingPerks() {
        return this.perks.values().stream().filter(appliedPerk -> !appliedPerk.isSealed()).map(AppliedPerk::getPerk).collect(Collectors.toList());
    }

    public Collection<AbstractPerk> getAllocatedPerks(PerkAllocationType type) {
        return this.perks.values().stream().filter(appliedPerk -> appliedPerk.isAllocated(type)).map(AppliedPerk::getPerk).collect(Collectors.toList());
    }

    public Collection<PerkAllocationType> getAllocationTypes(AbstractPerk perk) {
        return this.findAppliedPerk(perk).map(AppliedPerk::getApplicationTypes).orElse(Collections.emptySet());
    }

    public boolean hasPerkEffect(Predicate<AbstractPerk> perkMatch) {
        return this.hasPerkAllocation(perkMatch) && !this.isPerkSealed(perkMatch);
    }

    public boolean hasPerkEffect(AbstractPerk perk) {
        return this.hasPerkAllocation(perk) && !this.isPerkSealed(perk);
    }

    public boolean hasPerkAllocation(Predicate<AbstractPerk> perkMatch) {
        return this.findAppliedPerk(perkMatch).isPresent();
    }

    public boolean hasPerkAllocation(AbstractPerk perk) {
        return this.findAppliedPerk(perk).isPresent();
    }

    public boolean hasPerkAllocation(AbstractPerk perk, PerkAllocationType type) {
        return this.findAppliedPerk(perk).map(appliedPerk -> appliedPerk.isAllocated(type)).orElse(false);
    }

    protected boolean canSealPerk(AbstractPerk perk) {
        return !this.isPerkSealed(perk) && this.hasPerkAllocation(perk);
    }

    public boolean isPerkSealed(AbstractPerk perk) {
        return this.findAppliedPerk(perk).map(AppliedPerk::isSealed).orElse(false);
    }

    public boolean isPerkSealed(Predicate<AbstractPerk> perkMatch) {
        return this.findAppliedPerk(perkMatch).map(AppliedPerk::isSealed).orElse(false);
    }

    protected boolean sealPerk(AbstractPerk perk) {
        if (!this.canSealPerk(perk)) {
            return false;
        }
        return this.findAppliedPerk(perk).map(appliedPerk -> appliedPerk.setSealed(true)).orElse(false);
    }

    protected boolean breakSeal(AbstractPerk perk) {
        return this.findAppliedPerk(perk).filter(AppliedPerk::isSealed).map(appliedPerk -> appliedPerk.setSealed(false)).orElse(false);
    }

    public boolean updatePerkData(AbstractPerk perk, CompoundNBT data) {
        AppliedPerk appliedPerk = this.perks.get(perk);
        if (appliedPerk == null) {
            return false;
        }
        appliedPerk.perkData = data.func_74737_b();
        return true;
    }

    public boolean applyPerkAllocation(AbstractPerk perk, PlayerPerkAllocation allocation, boolean simulate) {
        if (simulate && !this.perks.containsKey(perk)) {
            return true;
        }
        AppliedPerk appliedPerk = this.perks.computeIfAbsent(perk, AppliedPerk::new);
        return appliedPerk.addAllocation(allocation, simulate);
    }

    public PerkRemovalResult removePerkAllocation(AbstractPerk perk, PlayerPerkAllocation allocation, boolean simulate) {
        AppliedPerk appliedPerk = this.perks.get(perk);
        if (appliedPerk == null) {
            return PerkRemovalResult.FAILURE;
        }
        if (appliedPerk.isAllocated(allocation.getType())) {
            PerkRemovalResult result = appliedPerk.removeAllocation(allocation, simulate);
            if (result.isFailure()) {
                return result;
            }
            if (!simulate && result == PerkRemovalResult.REMOVE_PERK) {
                this.perks.remove(perk);
            }
            return result;
        }
        return PerkRemovalResult.FAILURE;
    }

    @Nullable
    public CompoundNBT getData(AbstractPerk perk) {
        return this.findAppliedPerk(perk).map(AppliedPerk::getPerkData).orElse(null);
    }

    @Nullable
    public CompoundNBT getMetaData(AbstractPerk perk) {
        return this.findAppliedPerk(perk).map(AppliedPerk::getApplicationData).orElse(null);
    }

    private Optional<AppliedPerk> findAppliedPerk(AbstractPerk perk) {
        return Optional.ofNullable(this.perks.get(perk));
    }

    private Optional<AppliedPerk> findAppliedPerk(Predicate<AbstractPerk> perkFilter) {
        return MapStream.of(this.perks).filterKey(perkFilter).valueStream().findFirst();
    }

    protected boolean grantFreeAllocationPoint(ResourceLocation freePointToken) {
        if (this.freePointTokens.contains(freePointToken)) {
            return false;
        }
        this.freePointTokens.add(freePointToken);
        return true;
    }

    protected boolean tryRevokeAllocationPoint(ResourceLocation token) {
        return this.freePointTokens.remove(token);
    }

    public Collection<ResourceLocation> getFreePointTokens() {
        return Collections.unmodifiableCollection(this.freePointTokens);
    }

    public int getAvailablePerkPoints(PlayerEntity player, LogicalSide side) {
        int allocatedPerks = (int)this.perks.values().stream().filter(perk -> perk.isAllocated(PerkAllocationType.UNLOCKED)).count() - 1;
        int allocationLevels = PerkLevelManager.getLevel(this.getPerkExp(), player, side);
        return allocationLevels + this.freePointTokens.size() - allocatedPerks;
    }

    public boolean hasFreeAllocationPoint(PlayerEntity player, LogicalSide side) {
        return this.getAvailablePerkPoints(player, side) > 0;
    }

    public double getPerkExp() {
        return this.perkExp;
    }

    public int getPerkLevel(PlayerEntity player, LogicalSide side) {
        return PerkLevelManager.getLevel(this.getPerkExp(), player, side);
    }

    public float getPercentToNextLevel(PlayerEntity player, LogicalSide side) {
        return PerkLevelManager.getNextLevelPercent(this.getPerkExp(), player, side);
    }

    protected void modifyExp(double exp, PlayerEntity player) {
        int currLevel = PerkLevelManager.getLevel(this.getPerkExp(), player, LogicalSide.SERVER);
        if (exp >= 0.0 && currLevel >= PerkLevelManager.getLevelCap(LogicalSide.SERVER, player)) {
            return;
        }
        long expThisLevel = PerkLevelManager.getExpForLevel(currLevel, player, LogicalSide.SERVER);
        long expNextLevel = PerkLevelManager.getExpForLevel(currLevel + 1, player, LogicalSide.SERVER);
        long cap = MathHelper.func_76124_d((double)((float)(expNextLevel - expThisLevel) * 0.08f));
        if (exp > (double)cap) {
            exp = cap;
        }
        this.perkExp = Math.max(this.perkExp + exp, 0.0);
    }

    protected void setExp(double exp) {
        this.perkExp = Math.max(exp, 0.0);
    }

    void load(PlayerProgress progress, CompoundNBT tag) {
        this.perks.clear();
        this.freePointTokens.clear();
        this.perkExp = 0.0;
        if (this.isLegacyData(tag)) {
            this.loadLegacyData(progress, tag);
            return;
        }
        this.perkExp = tag.func_74769_h("perkExp");
        long perkTreeVersion = tag.func_74763_f("perkTreeVersion");
        if (PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).map(v -> !v.equals(perkTreeVersion)).orElse(true).booleanValue()) {
            RootPerk root;
            AstralSorcery.log.info("Clearing perk-tree because the player's skill-tree version was outdated!");
            if (progress.getAttunedConstellation() != null && (root = PerkTree.PERK_TREE.getRootPerk(LogicalSide.SERVER, progress.getAttunedConstellation())) != null) {
                AppliedPerk newPerk = new AppliedPerk(root);
                newPerk.addAllocation(PlayerPerkAllocation.unlock(), false);
                root.onUnlockPerkServer(null, PerkAllocationType.UNLOCKED, progress, newPerk.getPerkData());
                this.perks.put(root, newPerk);
            }
            return;
        }
        this.freePointTokens.addAll(NBTHelper.readList(tag, "tokens", 8, nbt -> new ResourceLocation(nbt.func_150285_a_().replace("-", "_"))));
        ListNBT list = tag.func_150295_c("perks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt2 = list.func_150305_b(i);
            AppliedPerk.deserialize(nbt2).ifPresent(perk -> this.perks.put(perk.getPerk(), (AppliedPerk)perk));
        }
    }

    void save(CompoundNBT tag) {
        PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).ifPresent(version -> tag.func_74772_a("perkTreeVersion", version.longValue()));
        tag.func_74780_a("perkExp", this.perkExp);
        ListNBT tokens = new ListNBT();
        for (ResourceLocation key : this.freePointTokens) {
            tokens.add((Object)StringNBT.func_229705_a_((String)key.toString()));
        }
        tag.func_218657_a("tokens", (INBT)tokens);
        ListNBT perks = new ListNBT();
        for (AppliedPerk perk : this.perks.values()) {
            perks.add((Object)perk.serialize());
        }
        tag.func_218657_a("perks", (INBT)perks);
    }

    public void write(PacketBuffer buf) {
        buf.writeDouble(this.perkExp);
        ByteBufUtils.writeCollection(buf, this.freePointTokens, ByteBufUtils::writeResourceLocation);
        ByteBufUtils.writeCollection(buf, this.perks.values(), (buffer, perk) -> {
            ByteBufUtils.writeResourceLocation(buffer, perk.getPerk().getRegistryName());
            ((AppliedPerk)perk).write(buffer);
        });
    }

    public static PlayerPerkData read(PacketBuffer buf, LogicalSide side) {
        PlayerPerkData data = new PlayerPerkData();
        data.perkExp = buf.readDouble();
        data.freePointTokens = ByteBufUtils.readSet(buf, ByteBufUtils::readResourceLocation);
        Set<AppliedPerk> appliedPerks = ByteBufUtils.readSet(buf, buffer -> {
            ResourceLocation key = ByteBufUtils.readResourceLocation(buffer);
            return PerkTree.PERK_TREE.getPerk(side, key).map(AppliedPerk::new).map(perk -> {
                ((AppliedPerk)perk).read(buffer);
                return perk;
            }).orElseThrow(() -> new IllegalArgumentException("Unknown perk: " + key));
        });
        appliedPerks.forEach(appliedPerk -> data.perks.put(appliedPerk.getPerk(), (AppliedPerk)appliedPerk));
        return data;
    }

    @OnlyIn(value=Dist.CLIENT)
    void receive(PktSyncKnowledge message) {
        PlayerPerkData copyFrom = message.perkData;
        this.perkExp = copyFrom.perkExp;
        this.freePointTokens = copyFrom.freePointTokens;
        this.perks = copyFrom.perks;
    }

    private boolean isLegacyData(CompoundNBT tag) {
        return tag.func_74764_b("sealedPerks");
    }

    private void loadLegacyData(PlayerProgress progress, CompoundNBT compound) {
        long perkTreeLevel = compound.func_74763_f("perkTreeVersion");
        if (PerkTree.PERK_TREE.getVersion(LogicalSide.SERVER).map(v -> !v.equals(perkTreeLevel)).orElse(true).booleanValue()) {
            RootPerk root;
            AstralSorcery.log.info("Clearing perk-tree because the player's skill-tree version was outdated!");
            if (progress.getAttunedConstellation() != null && (root = PerkTree.PERK_TREE.getRootPerk(LogicalSide.SERVER, progress.getAttunedConstellation())) != null) {
                AppliedPerk newPerk = new AppliedPerk(root);
                newPerk.addAllocation(PlayerPerkAllocation.unlock(), false);
                root.onUnlockPerkServer(null, PerkAllocationType.UNLOCKED, progress, newPerk.getPerkData());
                this.perks.put(root, newPerk);
            }
        } else {
            String perkRegName;
            CompoundNBT tag;
            int i;
            ListNBT list;
            if (compound.func_74764_b("perks")) {
                list = compound.func_150295_c("perks", 10);
                for (i = 0; i < list.size(); ++i) {
                    tag = list.func_150305_b(i);
                    perkRegName = tag.func_74779_i("perkName");
                    CompoundNBT data = tag.func_74775_l("perkData");
                    PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, new ResourceLocation(perkRegName)).ifPresent(perk -> {
                        AppliedPerk appliedPerk = new AppliedPerk((AbstractPerk)perk);
                        appliedPerk.addAllocation(PlayerPerkAllocation.unlock(), false);
                        appliedPerk.perkData = data;
                        this.perks.put((AbstractPerk)perk, appliedPerk);
                    });
                }
            }
            if (compound.func_74764_b("sealedPerks")) {
                list = compound.func_150295_c("sealedPerks", 10);
                for (i = 0; i < list.size(); ++i) {
                    tag = list.func_150305_b(i);
                    perkRegName = tag.func_74779_i("perkName");
                    PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, new ResourceLocation(perkRegName)).ifPresent(perk -> {
                        AppliedPerk newPerk = this.perks.get(perk);
                        if (newPerk != null) {
                            newPerk.setSealed(true);
                        }
                    });
                }
            }
            if (compound.func_74764_b("pointTokens")) {
                list = compound.func_150295_c("pointTokens", 8);
                for (i = 0; i < list.size(); ++i) {
                    String[] resource = PlayerPerkData.legacySplitKey(list.func_150307_f(i).toLowerCase(Locale.ROOT));
                    resource[1] = resource[1].replace("-", "_").replace(":", "_");
                    this.freePointTokens.add(AstralSorcery.key(resource[1]));
                }
            }
        }
        if (compound.func_74764_b("perkExp")) {
            this.perkExp = compound.func_74769_h("perkExp");
        }
    }

    private static String[] legacySplitKey(String resource) {
        String[] keyParts = new String[]{"minecraft", resource};
        int i = resource.indexOf(":");
        if (i >= 0) {
            keyParts[1] = resource.substring(i + 1);
        }
        return keyParts;
    }

    public static class AppliedPerk {
        private static final String SEALED_KEY = "sealed";
        private static final String APPLICATION_KEYS = "application";
        private final AbstractPerk perk;
        private CompoundNBT perkData = new CompoundNBT();
        private CompoundNBT applicationData = new CompoundNBT();
        private Set<PerkAllocationType> applicationTypes = new HashSet<PerkAllocationType>();

        public AppliedPerk(AbstractPerk perk) {
            this.perk = perk;
        }

        public boolean isSealed() {
            return this.applicationData.func_74764_b(SEALED_KEY);
        }

        public boolean setSealed(boolean sealed) {
            if (sealed) {
                this.applicationData.func_74757_a(SEALED_KEY, true);
            } else {
                this.applicationData.func_82580_o(SEALED_KEY);
            }
            return true;
        }

        public AbstractPerk getPerk() {
            return this.perk;
        }

        public CompoundNBT getPerkData() {
            return this.perkData;
        }

        public CompoundNBT getApplicationData() {
            return this.applicationData;
        }

        private int getTotalAllocationCount() {
            int sum = 0;
            for (PerkAllocationType type : PerkAllocationType.values()) {
                sum += this.getAllocationCount(type);
            }
            return sum;
        }

        private int getAllocationCount(PerkAllocationType type) {
            CompoundNBT metaData = this.getApplicationData();
            if (!metaData.func_150297_b(APPLICATION_KEYS, 10)) {
                return 0;
            }
            CompoundNBT applicationMeta = metaData.func_74775_l(APPLICATION_KEYS);
            ListNBT allocations = applicationMeta.func_150295_c(type.getSaveKey(), 10);
            return allocations.size();
        }

        public boolean isAllocated(PerkAllocationType type) {
            return this.applicationTypes.contains((Object)type);
        }

        private PerkRemovalResult removeAllocation(PlayerPerkAllocation type, boolean simulate) {
            CompoundNBT metaData = this.getApplicationData();
            if (!metaData.func_150297_b(APPLICATION_KEYS, 10)) {
                return PerkRemovalResult.FAILURE;
            }
            CompoundNBT applicationMeta = metaData.func_74775_l(APPLICATION_KEYS);
            ListNBT allocations = applicationMeta.func_150295_c(type.getType().getSaveKey(), 10);
            if (allocations.isEmpty()) {
                return PerkRemovalResult.FAILURE;
            }
            boolean removedMatch = false;
            UUID removeUUID = type.getLockUUID();
            for (int i = 0; i < allocations.size(); ++i) {
                CompoundNBT tag = allocations.func_150305_b(i);
                UUID lockUUID = tag.func_186857_a("uuid");
                if (!lockUUID.equals(removeUUID)) continue;
                if (!simulate) {
                    allocations.remove(i);
                }
                removedMatch = true;
                break;
            }
            if (!removedMatch) {
                return PerkRemovalResult.FAILURE;
            }
            if (simulate && allocations.size() <= 1) {
                if (this.applicationTypes.size() > 1) {
                    return PerkRemovalResult.REMOVE_ALLOCATION_TYPE;
                }
                return PerkRemovalResult.REMOVE_PERK;
            }
            if (allocations.isEmpty()) {
                this.applicationTypes.remove((Object)type.getType());
                if (this.applicationTypes.isEmpty()) {
                    return PerkRemovalResult.REMOVE_PERK;
                }
                return PerkRemovalResult.REMOVE_ALLOCATION_TYPE;
            }
            return PerkRemovalResult.REMOVE_ALLOCATION;
        }

        public boolean addAllocation(PlayerPerkAllocation type, boolean simulate) {
            String key;
            CompoundNBT applicationMeta;
            CompoundNBT metaData;
            if (!simulate) {
                this.applicationTypes.add(type.getType());
            }
            if (!(metaData = this.getApplicationData()).func_150297_b(APPLICATION_KEYS, 10)) {
                if (simulate) {
                    return true;
                }
                metaData.func_218657_a(APPLICATION_KEYS, (INBT)new CompoundNBT());
            }
            if (!(applicationMeta = metaData.func_74775_l(APPLICATION_KEYS)).func_150297_b(key = type.getType().getSaveKey(), 9)) {
                if (simulate) {
                    return true;
                }
                applicationMeta.func_218657_a(key, (INBT)new ListNBT());
            }
            ListNBT allocations = applicationMeta.func_150295_c(key, 10);
            UUID newUUID = type.getLockUUID();
            CompoundNBT newKeyTag = new CompoundNBT();
            newKeyTag.func_186854_a("uuid", newUUID);
            if (allocations.isEmpty()) {
                if (!simulate) {
                    allocations.add((Object)newKeyTag);
                }
                return true;
            }
            for (int i = 0; i < allocations.size(); ++i) {
                CompoundNBT tag = allocations.func_150305_b(i);
                UUID lockUUID = tag.func_186857_a("uuid");
                if (!lockUUID.equals(newUUID)) continue;
                return false;
            }
            if (simulate) {
                return true;
            }
            return allocations.add((Object)newKeyTag);
        }

        public Set<PerkAllocationType> getApplicationTypes() {
            return this.applicationTypes;
        }

        private CompoundNBT serialize() {
            CompoundNBT out = new CompoundNBT();
            out.func_74778_a("perk", this.perk.getRegistryName().toString());
            out.func_218657_a("perkData", (INBT)this.perkData);
            out.func_218657_a("applicationData", (INBT)this.applicationData);
            int[] types = this.applicationTypes.stream().mapToInt(Enum::ordinal).toArray();
            out.func_74783_a("applicationTypes", types);
            return out;
        }

        private static Optional<AppliedPerk> deserialize(CompoundNBT tag) {
            ResourceLocation key = new ResourceLocation(tag.func_74779_i("perk"));
            return PerkTree.PERK_TREE.getPerk(LogicalSide.SERVER, key).map(AppliedPerk::new).map(appliedPerk -> {
                appliedPerk.perkData = tag.func_74775_l("perkData");
                appliedPerk.applicationData = tag.func_74775_l("applicationData");
                int[] types = tag.func_74759_k("applicationTypes");
                appliedPerk.applicationTypes = IntStream.of(types).mapToObj(type -> PerkAllocationType.values()[type]).collect(Collectors.toSet());
                return appliedPerk;
            });
        }

        private void write(PacketBuffer buf) {
            ByteBufUtils.writeNBTTag(buf, this.perkData);
            ByteBufUtils.writeNBTTag(buf, this.applicationData);
            ByteBufUtils.writeCollection(buf, this.applicationTypes, ByteBufUtils::writeEnumValue);
        }

        private void read(PacketBuffer buf) {
            this.perkData = ByteBufUtils.readNBTTag(buf);
            this.applicationData = ByteBufUtils.readNBTTag(buf);
            this.applicationTypes = ByteBufUtils.readSet(buf, buffer -> ByteBufUtils.readEnumValue(buffer, PerkAllocationType.class));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppliedPerk that = (AppliedPerk)o;
            return Objects.equals(this.perk.getRegistryName(), that.perk.getRegistryName());
        }

        public int hashCode() {
            return Objects.hash(this.perk.getRegistryName());
        }
    }
}

