/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.event.helper;

import hellfirepvp.astralsorcery.common.util.tick.TimeoutList;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class EventHelperInvulnerability {
    private static TimeoutList<PlayerEntity> invulnerabilityCooldown = new TimeoutList<PlayerEntity>(p -> p.func_184224_h(false), TickEvent.Type.SERVER);

    public static void makeInvulnerable(PlayerEntity player) {
        player.func_184224_h(true);
        invulnerabilityCooldown.add(10, player);
    }

    public static void clearServer() {
        invulnerabilityCooldown.clear();
    }

    public static void attachTickListener(Consumer<ITickHandler> registrar) {
        registrar.accept(invulnerabilityCooldown);
    }

    public static void attachListeners(IEventBus eventBus) {
        eventBus.addListener(EventHelperInvulnerability::onDisconnect);
        eventBus.addListener(EventHelperInvulnerability::onTarget);
        eventBus.addListener(EventPriority.LOW, EventHelperInvulnerability::onHurt);
    }

    private static void onDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        invulnerabilityCooldown.remove(event.getPlayer());
    }

    private static void onTarget(LivingSetAttackTargetEvent event) {
        PlayerEntity targetedPlayer;
        LivingEntity target = event.getTarget();
        if (target != null && target.func_70089_S() && target instanceof PlayerEntity && invulnerabilityCooldown.contains(targetedPlayer = (PlayerEntity)target)) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (entity instanceof PlayerEntity && invulnerabilityCooldown.contains((PlayerEntity)entity)) {
            event.setCanceled(true);
        }
    }
}

