/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.fluid;

import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.crafting.nojson.LiquidStarlightCraftingRegistry;
import hellfirepvp.astralsorcery.common.data.config.entry.CraftingConfig;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockLiquidStarlight
extends FlowingFluidBlock {
    public BlockLiquidStarlight(Supplier<? extends FlowingFluid> fluidSupplier) {
        super(fluidSupplier, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_235838_a_(state -> 15).func_200943_b(100.0f).func_222380_e());
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(state, world, pos, entity);
        if ((Integer)state.func_177229_b((Property)field_176367_b) != 0) {
            return;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76439_r, 300, 0, true, true));
        } else if (entity instanceof ItemEntity) {
            LiquidStarlightCraftingRegistry.tryCraft((ItemEntity)entity, pos);
            if (!world.func_201670_d() && ((ItemEntity)entity).func_92059_d().func_190926_b()) {
                entity.func_70106_y();
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)worldIn));
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.reactWithNeighbors(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.getFluid().func_205569_a((IWorldReader)worldIn));
        }
    }

    private boolean reactWithNeighbors(World world, BlockPos pos, BlockState state) {
        for (Direction dir : Direction.values()) {
            BlockState generate;
            boolean isHot;
            FluidState otherState = world.func_204610_c(pos.func_177972_a(dir));
            Fluid otherFluid = otherState.func_206886_c();
            if (otherFluid instanceof FlowingFluid) {
                otherFluid = ((FlowingFluid)otherFluid).func_210198_f();
            }
            if (otherFluid instanceof EmptyFluid || otherFluid.equals(this.getFluid())) continue;
            boolean bl = isHot = otherFluid.getAttributes().getTemperature((IBlockDisplayReader)world, pos.func_177972_a(dir)) > 600;
            if (isHot) {
                if (((Boolean)CraftingConfig.CONFIG.liquidStarlightInteractionSand.get()).booleanValue()) {
                    generate = Blocks.field_150354_m.func_176223_P();
                    if (((Boolean)CraftingConfig.CONFIG.liquidStarlightInteractionAquamarine.get()).booleanValue() && world.field_73012_v.nextInt(800) == 0) {
                        generate = BlocksAS.AQUAMARINE_SAND_ORE.func_176223_P();
                    }
                } else {
                    generate = Blocks.field_150347_e.func_176223_P();
                }
            } else {
                generate = (Boolean)CraftingConfig.CONFIG.liquidStarlightInteractionIce.get() != false ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_150347_e.func_176223_P();
            }
            world.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)world, (BlockPos)pos, (BlockPos)pos, (BlockState)generate));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        Integer level = (Integer)state.func_177229_b((Property)field_176367_b);
        double percHeight = 1.0 - ((double)level.intValue() + 1.0) / 8.0;
        BlockLiquidStarlight.playLiquidStarlightBlockEffect(rand, new Vector3((Vector3i)pos).addY(percHeight * (double)rand.nextFloat()), 1.0f);
        BlockLiquidStarlight.playLiquidStarlightBlockEffect(rand, new Vector3((Vector3i)pos).addY(percHeight * (double)rand.nextFloat()), 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playLiquidStarlightBlockEffect(Random rand, Vector3 at, float blockSize) {
        if (rand.nextInt(3) == 0) {
            ((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at.clone().add(0.5 + (double)(rand.nextFloat() * (blockSize / 2.0f) * (float)(rand.nextBoolean() ? 1 : -1)), 0.0, 0.5 + (double)(rand.nextFloat() * (blockSize / 2.0f) * (float)(rand.nextBoolean() ? 1 : -1))))).setScaleMultiplier(0.1f + rand.nextFloat() * 0.06f)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.ROCK_CRYSTAL));
        }
    }
}

