/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInteraction;
import hellfirepvp.astralsorcery.common.crafting.recipe.LiquidInteractionContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.interaction.jei.JEIInteractionResultRegistry;
import hellfirepvp.astralsorcery.common.integration.IntegrationJEI;
import hellfirepvp.astralsorcery.common.integration.jei.JEICategory;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class CategoryLiquidInteraction
extends JEICategory<LiquidInteraction> {
    private static final DecimalFormat FORMAT_CHANCE = new DecimalFormat("0.00");
    private final IDrawable background;
    private final IDrawable icon;

    public CategoryLiquidInteraction(IGuiHelper guiHelper) {
        super(IntegrationJEI.CATEGORY_LIQUID_INTERACTION);
        this.background = guiHelper.createDrawable(AstralSorcery.key("textures/gui/jei/interaction.png"), 0, 0, 112, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlocksAS.CHALICE));
    }

    public Class<? extends LiquidInteraction> getRecipeClass() {
        return LiquidInteraction.class;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public List<LiquidInteraction> getRecipes() {
        return RecipeTypesAS.TYPE_LIQUID_INTERACTION.getAllRecipes();
    }

    public void draw(LiquidInteraction recipe, MatrixStack renderStack, double mouseX, double mouseY) {
        this.icon.draw(renderStack, 3, 36);
        this.icon.draw(renderStack, 93, 36);
        JEIInteractionResultRegistry.get(recipe.getResult().getId()).ifPresent(handler -> handler.drawRecipe(recipe, mouseX, mouseY));
        FluidStack testMatch1 = new FluidStack(recipe.getReactant1(), 1000);
        FluidStack testMatch2 = new FluidStack(recipe.getReactant2(), 1000);
        LiquidInteractionContext ctx = new LiquidInteractionContext(testMatch1, testMatch2);
        List<LiquidInteraction> sameInteractions = RecipeTypesAS.TYPE_LIQUID_INTERACTION.findMatchingRecipes(ctx);
        if (!sameInteractions.isEmpty()) {
            int totalWeight = sameInteractions.stream().mapToInt(LiquidInteraction::getWeight).sum();
            float perc = (float)recipe.getWeight() / (float)totalWeight * 100.0f;
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            TranslationTextComponent txt = new TranslationTextComponent("jei.astralsorcery.tip.chance", new Object[]{FORMAT_CHANCE.format(perc)});
            int width = fr.func_238414_a_((ITextProperties)txt);
            fr.func_243248_b(renderStack, (ITextComponent)txt, (float)(74 - width), 44.0f, 0x333333);
        }
    }

    public void setIngredients(LiquidInteraction recipe, IIngredients ingredients) {
        ImmutableList.Builder fluidInputs = ImmutableList.builder();
        fluidInputs.add(Collections.singletonList(recipe.getReactant1()));
        fluidInputs.add(Collections.singletonList(recipe.getReactant2()));
        ingredients.setInputLists(VanillaTypes.FLUID, (List)fluidInputs.build());
        JEIInteractionResultRegistry.get(recipe.getResult().getId()).ifPresent(handler -> handler.addToRecipeIngredients(recipe, ingredients));
    }

    public void setRecipe(IRecipeLayout recipeLayout, LiquidInteraction recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 3, 19, 16, 16, recipe.getReactant1().getAmount(), false, null);
        fluidStacks.init(1, true, 93, 19, 16, 16, recipe.getReactant2().getAmount(), false, null);
        fluidStacks.set(ingredients);
        JEIInteractionResultRegistry.get(recipe.getResult().getId()).ifPresent(handler -> handler.addToRecipeLayout(recipeLayout, recipe, ingredients));
    }
}

