/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.armor;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.model.armor.ModelArmorMantle;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.ConstellationBaseItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectVicio;
import hellfirepvp.astralsorcery.common.item.base.AlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.client.ItemDynamicColor;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.lib.RegistriesAS;
import hellfirepvp.astralsorcery.common.perk.modifier.DynamicAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.provider.equipment.EquipmentAttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.object.CacheReference;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class ItemMantle
extends ArmorItem
implements ItemDynamicColor,
ConstellationBaseItem,
EquipmentAttributeModifierProvider,
AlignmentChargeConsumer {
    private static final UUID MODIFIER_ID = UUID.fromString("aae54b9d-e1c8-4e74-8ac6-efa06093bd1a");
    private static final CacheReference<DynamicAttributeModifier> MINING_SIZE_MODIFIER = new CacheReference<DynamicAttributeModifier>(() -> new DynamicAttributeModifier(MODIFIER_ID, PerkAttributeTypesAS.ATTR_TYPE_MINING_SIZE, ModifierType.ADDITION, 2.0f));
    private static Object modelArmor = null;

    public ItemMantle() {
        super(CommonProxy.ARMOR_MATERIAL_IMBUED_LEATHER, EquipmentSlotType.CHEST, new Item.Properties().func_200917_a(1).func_200916_a(CommonProxy.ITEM_GROUP_AS));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            for (IConstellation cst : RegistriesAS.REGISTRY_CONSTELLATIONS.getValues()) {
                if (!(cst instanceof IWeakConstellation)) continue;
                ItemStack stack = new ItemStack((IItemProvider)this);
                this.setConstellation(stack, cst);
                items.add((Object)stack);
            }
        }
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        return MantleEffectVicio.isUsableElytra(stack, (PlayerEntity)entity);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        return MantleEffectVicio.isUsableElytra(stack, (PlayerEntity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IConstellation cst = this.getConstellation(stack);
        if (cst instanceof IWeakConstellation) {
            tooltip.add((ITextComponent)cst.getConstellationName().func_240699_a_(TextFormatting.BLUE));
        }
    }

    @Override
    public Collection<PerkAttributeModifier> getModifiers(ItemStack stack, PlayerEntity player, LogicalSide side, boolean ignoreRequirements) {
        if (ItemMantle.getEffect(stack, (IWeakConstellation)ConstellationsAS.evorsio) == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(MINING_SIZE_MODIFIER.get());
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        IConstellation cst = this.getConstellation(stack);
        if (cst != null) {
            Color c = cst.getConstellationColor();
            return 0xFF000000 | c.getRGB();
        }
        return -16777216;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (modelArmor == null) {
            modelArmor = new ModelArmorMantle();
        }
        return (A)((BipedModel)modelArmor);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return AstralSorcery.key("textures/model/armor/mantle.png").toString();
    }

    @Nullable
    public static <V extends MantleEffect> V getEffect(@Nullable LivingEntity entity) {
        return ItemMantle.getEffect(entity, null);
    }

    @Nullable
    public static <V extends MantleEffect> V getEffect(@Nullable LivingEntity entity, @Nullable IWeakConstellation expected) {
        if (entity == null) {
            return null;
        }
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMantle)) {
            return null;
        }
        return ItemMantle.getEffect(stack, expected);
    }

    @Nullable
    public static <V extends MantleEffect> V getEffect(@Nonnull ItemStack stack, @Nullable IWeakConstellation expected) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMantle)) {
            return null;
        }
        IConstellation cst = ((ItemMantle)stack.func_77973_b()).getConstellation(stack);
        if (!(cst instanceof IWeakConstellation)) {
            return null;
        }
        if (expected != null && !expected.equals(cst)) {
            return null;
        }
        MantleEffect effect = ((IWeakConstellation)cst).getMantleEffect();
        if (effect == null || !((Boolean)effect.getConfig().enabled.get()).booleanValue()) {
            return null;
        }
        return (V)((Object)effect);
    }

    @Override
    @Nullable
    public IConstellation getConstellation(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return IConstellation.readFromNBT(NBTHelper.getPersistentData(stack), IConstellation.getDefaultSaveKey());
    }

    @Override
    public boolean setConstellation(ItemStack stack, @Nullable IConstellation cst) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (cst == null) {
            NBTHelper.getPersistentData(stack).func_82580_o(IConstellation.getDefaultSaveKey());
        } else {
            cst.writeToNBT(NBTHelper.getPersistentData(stack), IConstellation.getDefaultSaveKey());
        }
        return true;
    }

    @Override
    public float getAlignmentChargeCost(PlayerEntity player, ItemStack stack) {
        return 0.0f;
    }
}

