/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.crystal.CrystalAttributeGenItem;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalGenerator;
import hellfirepvp.astralsorcery.common.entity.item.EntityCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.ItemAttunedCrystalBase;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemCrystalBase
extends Item
implements CrystalAttributeGenItem {
    public ItemCrystalBase(Item.Properties prop) {
        super(prop.func_200918_c(0));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        CrystalAttributes attributes;
        if (!world.func_201670_d() && (attributes = this.getAttributes(stack)) == null && stack.func_77973_b() instanceof CrystalAttributeGenItem) {
            attributes = CrystalGenerator.generateNewAttributes(stack);
            attributes.store(stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> toolTip, ITooltipFlag flag) {
        this.addCrystalPropertyToolTip(stack, toolTip);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected CrystalAttributes.TooltipResult addCrystalPropertyToolTip(ItemStack stack, List<ITextComponent> tooltip) {
        CrystalAttributes attr = this.getAttributes(stack);
        if (attr != null) {
            return attr.addTooltip(tooltip);
        }
        return CrystalAttributes.TooltipResult.ALL_MISSING;
    }

    @Override
    @Nullable
    public CrystalAttributes getAttributes(ItemStack stack) {
        return CrystalAttributes.getCrystalAttributes(stack);
    }

    @Override
    public void setAttributes(ItemStack stack, @Nullable CrystalAttributes attributes) {
        if (attributes != null) {
            attributes.store(stack);
        } else {
            CrystalAttributes.storeNull(stack);
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        EntityCrystal res = new EntityCrystal(EntityTypesAS.ITEM_CRYSTAL, world, location.func_226277_ct_(), location.func_226278_cu_(), location.func_226281_cx_(), itemstack);
        res.func_70020_e(location.func_189511_e(new CompoundNBT()));
        if (location instanceof ItemEntity) {
            res.func_200216_c(((ItemEntity)location).func_200214_m());
            res.func_200217_b(((ItemEntity)location).func_200215_l());
        }
        res.applyColor(this.getItemEntityColor(itemstack));
        return res;
    }

    @Override
    public int getGeneratedPropertyTiers() {
        return 5;
    }

    @Override
    public int getMaxPropertyTiers() {
        return 7;
    }

    protected Color getItemEntityColor(ItemStack stack) {
        return ColorsAS.ROCK_CRYSTAL;
    }

    public abstract ItemAttunedCrystalBase getTunedItemVariant();

    public abstract ItemCrystalBase getInertDuplicateItem();
}

