/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalPerkTree;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournalProgression;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktProgressionUpdate
extends ASPacket<PktProgressionUpdate> {
    public ProgressionTier tier = null;
    public ResearchProgression prog = null;

    public PktProgressionUpdate() {
    }

    public PktProgressionUpdate(ResearchProgression prog) {
        this.prog = prog;
    }

    public PktProgressionUpdate(ProgressionTier tier) {
        this.tier = tier;
    }

    private PktProgressionUpdate(ProgressionTier tier, ResearchProgression prog) {
        this.tier = tier;
        this.prog = prog;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktProgressionUpdate> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.tier, ByteBufUtils::writeEnumValue);
            ByteBufUtils.writeOptional(buffer, packet.prog, ByteBufUtils::writeEnumValue);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktProgressionUpdate> decoder() {
        return buffer -> new PktProgressionUpdate(ByteBufUtils.readOptional(buffer, buf -> ByteBufUtils.readEnumValue(buf, ProgressionTier.class)), ByteBufUtils.readOptional(buffer, buf -> ByteBufUtils.readEnumValue(buf, ResearchProgression.class)));
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktProgressionUpdate> handler() {
        return new ASPacket.Handler<PktProgressionUpdate>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktProgressionUpdate packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    if (packet.tier != null) {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.progress.gain.progress.chat").func_240699_a_(TextFormatting.BLUE), Util.field_240973_b_);
                    }
                    if (packet.prog != null) {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("astralsorcery.progress.gain.research.chat", new Object[]{packet.prog.getName()}).func_240699_a_(TextFormatting.AQUA), Util.field_240973_b_);
                    }
                    packet.refreshJournal();
                });
            }

            @Override
            public void handle(PktProgressionUpdate packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private void refreshJournal() {
        Screen open = Minecraft.func_71410_x().field_71462_r;
        if (open != null && open instanceof ScreenJournal && !(open instanceof ScreenJournalPerkTree)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        ScreenJournalProgression.resetJournal();
    }
}

