/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.tick;

import hellfirepvp.astralsorcery.common.data.research.PlayerPerkData;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.tick.PlayerTickPerk;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class PerkTickHelper
implements ITickHandler {
    public static final PerkTickHelper INSTANCE = new PerkTickHelper();

    private PerkTickHelper() {
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity ticked = (PlayerEntity)context[0];
        LogicalSide side = (LogicalSide)context[1];
        PlayerProgress prog = ResearchHelper.getProgress(ticked, side);
        if (prog.isValid()) {
            PlayerPerkData perkData = prog.getPerkData();
            for (AbstractPerk perk : perkData.getEffectGrantingPerks()) {
                if (!(perk instanceof PlayerTickPerk)) continue;
                ((PlayerTickPerk)((Object)perk)).onPlayerTick(ticked, side);
            }
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PlayerPerkHandler";
    }
}

