/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeBreakSpeed
extends PerkAttributeType {
    public static boolean evaluateBreakSpeedWithoutPerks = false;

    public AttributeTypeBreakSpeed() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_HARVEST_SPEED);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(EventPriority.LOW, this::onBreakSpeed);
    }

    private void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        LogicalSide side;
        if (evaluateBreakSpeedWithoutPerks) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float speed = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, event.getNewSpeed());
        speed = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, speed);
        event.setNewSpeed(speed);
    }
}

