/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.resource.query.SpriteQuery;
import hellfirepvp.astralsorcery.common.data.journal.JournalPage;
import hellfirepvp.astralsorcery.common.data.journal.JournalPageBlockTransmutation;
import hellfirepvp.astralsorcery.common.data.journal.JournalPageLiquidInfusion;
import hellfirepvp.astralsorcery.common.data.journal.JournalPageRecipe;
import hellfirepvp.astralsorcery.common.data.journal.JournalPageStructure;
import hellfirepvp.astralsorcery.common.data.journal.JournalPageText;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.ItemResonator;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class RegistryResearch {
    public static void init() {
        RegistryResearch.registerDiscovery();
        RegistryResearch.registerCrafting();
        RegistryResearch.registerAttunement();
        RegistryResearch.registerConstellation();
        RegistryResearch.registerRadiance();
    }

    private static void registerRadiance() {
        ResearchNode resAttuneCrystalTrait = new ResearchNode((IItemProvider)ItemsAS.ROCK_CRYSTAL, "ATT_TRAIT", 0.0f, 0.0f).addPage(RegistryResearch.text("ATT_TRAIT.1")).addPage(RegistryResearch.text("ATT_TRAIT.2")).register(ResearchProgression.RADIANCE);
        ResearchNode resObservatory = new ResearchNode((IItemProvider)BlocksAS.OBSERVATORY, "OBSERVATORY", 1.5f, 0.25f).addPage(RegistryResearch.text("OBSERVATORY.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.OBSERVATORY)).addTomeLookup((IItemProvider)BlocksAS.OBSERVATORY, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("OBSERVATORY.3")).register(ResearchProgression.RADIANCE);
        ResearchNode resIrradiantStars = new ResearchNode(new IItemProvider[]{ItemsAS.SHIFTING_STAR_AEVITAS, ItemsAS.SHIFTING_STAR_ARMARA, ItemsAS.SHIFTING_STAR_DISCIDIA, ItemsAS.SHIFTING_STAR_EVORSIO, ItemsAS.SHIFTING_STAR_VICIO}, "ENH_SHIFTING_STAR", 3.25f, 0.5f).addPage(RegistryResearch.text("ENH_SHIFTING_STAR.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR_AEVITAS)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR_AEVITAS, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR_ARMARA)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR_ARMARA, 2, ResearchProgression.RADIANCE).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR_DISCIDIA)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR_DISCIDIA, 3, ResearchProgression.RADIANCE).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR_EVORSIO)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR_EVORSIO, 4, ResearchProgression.RADIANCE).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR_VICIO)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR_VICIO, 5, ResearchProgression.RADIANCE).register(ResearchProgression.RADIANCE);
        ResearchNode resRelayCrafting = new ResearchNode((IItemProvider)BlocksAS.ALTAR_RADIANCE, "CRAFTING_FOCUS_HINT", 2.5f, 2.0f).addPage(RegistryResearch.text("CRAFTING_FOCUS_HINT.1")).addPage(RegistryResearch.text("CRAFTING_FOCUS_HINT.2")).addPage(RegistryResearch.text("CRAFTING_FOCUS_HINT.3")).register(ResearchProgression.RADIANCE);
        ResearchNode resMantle = new ResearchNode((IItemProvider)ItemsAS.MANTLE, "ATT_CAPE", 1.25f, 2.5f).addPage(RegistryResearch.text("ATT_CAPE.1")).addPage(RegistryResearch.recipe((ItemStack stack) -> ItemsAS.MANTLE.equals(stack.func_77973_b()) && ItemsAS.MANTLE.getConstellation((ItemStack)stack) == null)).addTomeLookup((IItemProvider)ItemsAS.MANTLE, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("ATT_CAPE.3")).addPage(RegistryResearch.text("ATT_CAPE.4")).register(ResearchProgression.RADIANCE);
        ResearchNode resChalice = new ResearchNode((IItemProvider)BlocksAS.CHALICE, "C_CHALICE", 3.0f, 3.0f).addPage(RegistryResearch.text("C_CHALICE.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.CHALICE)).addTomeLookup((IItemProvider)BlocksAS.CHALICE, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("C_CHALICE.3")).addPage(RegistryResearch.text("C_CHALICE.4")).register(ResearchProgression.RADIANCE);
        ResearchNode resFountain = new ResearchNode((IItemProvider)BlocksAS.FOUNTAIN, "BORE_CORE", 2.25f, 4.0f).addPage(RegistryResearch.text("BORE_CORE.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.FOUNTAIN)).addTomeLookup((IItemProvider)BlocksAS.FOUNTAIN, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("BORE_CORE.3")).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_FOUNTAIN)).register(ResearchProgression.RADIANCE);
        ResearchNode resLiquidBore = new ResearchNode((IItemProvider)BlocksAS.FOUNTAIN_PRIME_LIQUID, "BORE_HEAD_LIQUID", 1.5f, 5.0f).addPage(RegistryResearch.text("BORE_HEAD_LIQUID.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.FOUNTAIN_PRIME_LIQUID)).addTomeLookup((IItemProvider)BlocksAS.FOUNTAIN_PRIME_LIQUID, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("BORE_HEAD_LIQUID.3")).addPage(RegistryResearch.text("BORE_HEAD_LIQUID.4")).register(ResearchProgression.RADIANCE);
        ItemStack liquidResonator = ItemResonator.setUpgradeUnlocked(new ItemStack((IItemProvider)ItemsAS.RESONATOR), ItemResonator.ResonatorUpgrade.STARLIGHT, ItemResonator.ResonatorUpgrade.FLUID_FIELDS);
        ItemResonator.setCurrentUpgradeUnsafe(liquidResonator, ItemResonator.ResonatorUpgrade.FLUID_FIELDS);
        ResearchNode resLiquidResonator = new ResearchNode(liquidResonator, "ICHOSIC", 0.0f, 4.5f).addPage(RegistryResearch.text("ICHOSIC.1")).addPage(RegistryResearch.recipe((ItemStack stack) -> ItemsAS.RESONATOR.equals(stack.func_77973_b()) && ItemResonator.getCurrentUpgrade(null, stack) == ItemResonator.ResonatorUpgrade.FLUID_FIELDS)).register(ResearchProgression.RADIANCE);
        ResearchNode resVortexBore = new ResearchNode((IItemProvider)BlocksAS.FOUNTAIN_PRIME_VORTEX, "BORE_HEAD_VORTEX", 3.5f, 4.75f).addPage(RegistryResearch.text("BORE_HEAD_VORTEX.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.FOUNTAIN_PRIME_VORTEX)).addTomeLookup((IItemProvider)BlocksAS.FOUNTAIN_PRIME_VORTEX, 1, ResearchProgression.RADIANCE).addPage(RegistryResearch.text("BORE_HEAD_VORTEX.3")).register(ResearchProgression.RADIANCE);
        resIrradiantStars.addSourceConnectionFrom(resRelayCrafting);
        resMantle.addSourceConnectionFrom(resRelayCrafting);
        resObservatory.addSourceConnectionFrom(resRelayCrafting);
        resAttuneCrystalTrait.addSourceConnectionFrom(resObservatory);
        resChalice.addSourceConnectionFrom(resRelayCrafting);
        resFountain.addSourceConnectionFrom(resChalice);
        resVortexBore.addSourceConnectionFrom(resFountain);
        resLiquidBore.addSourceConnectionFrom(resFountain);
        resLiquidResonator.addSourceConnectionFrom(resLiquidBore);
    }

    private static void registerConstellation() {
        ResearchNode resLenses = new ResearchNode((IItemProvider)ItemsAS.GLASS_LENS, "LENSES_EFFECTS", 6.25f, 1.75f).addPage(RegistryResearch.text("LENSES_EFFECTS.1")).addPage(RegistryResearch.text("LENSES_EFFECTS.2")).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensFire = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_FIRE, "IGNITION_LENS", 5.5f, 0.5f).addPage(RegistryResearch.text("IGNITION_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_FIRE)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_FIRE, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensBreak = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_BREAK, "BREAK_LENS", 6.75f, 0.25f).addPage(RegistryResearch.text("BREAK_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_BREAK)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_BREAK, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensDamage = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_DAMAGE, "DAMAGE_LENS", 7.5f, 1.25f).addPage(RegistryResearch.text("DAMAGE_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_DAMAGE)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_DAMAGE, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensPush = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_PUSH, "PUSH_LENS", 7.25f, 2.25f).addPage(RegistryResearch.text("PUSH_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_PUSH)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_PUSH, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensRegeneration = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_REGENERATION, "REGENERATION_LENS", 6.75f, 3.0f).addPage(RegistryResearch.text("REGENERATION_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_REGENERATION)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_REGENERATION, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensGrowth = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_GROWTH, "GROWTH_LENS", 5.75f, 2.75f).addPage(RegistryResearch.text("GROWTH_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_GROWTH)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_GROWTH, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resColoredLensSpectral = new ResearchNode((IItemProvider)ItemsAS.COLORED_LENS_SPECTRAL, "SPECTRAL_LENS", 4.75f, 2.0f).addPage(RegistryResearch.text("SPECTRAL_LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.COLORED_LENS_SPECTRAL)).addTomeLookup((IItemProvider)ItemsAS.COLORED_LENS_SPECTRAL, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resInfuser = new ResearchNode((IItemProvider)BlocksAS.INFUSER, "INFUSER", 2.0f, 1.75f).addPage(RegistryResearch.text("INFUSER.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSER)).addTomeLookup((IItemProvider)BlocksAS.INFUSER, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("INFUSER.3")).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_INFUSER)).addPage(RegistryResearch.recipeInfusion((IItemProvider)ItemsAS.RESONATING_GEM)).addTomeLookup((IItemProvider)ItemsAS.RESONATING_GEM, 4, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resEnchantmentAmulet = new ResearchNode((IItemProvider)ItemsAS.ENCHANTMENT_AMULET, "ENCHANTMENT_AMULET", 1.75f, 3.25f).addPage(RegistryResearch.text("ENCHANTMENT_AMULET.1")).addPage(JournalPageRecipe.fromName(AstralSorcery.key("altar/enchantment_amulet_init"))).addTomeLookup((IItemProvider)ItemsAS.ENCHANTMENT_AMULET, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("ENCHANTMENT_AMULET.3")).addPage(JournalPageRecipe.fromName(AstralSorcery.key("altar/enchantment_amulet_reroll"))).register(ResearchProgression.CONSTELLATION);
        ResearchNode resRitualLink = new ResearchNode((IItemProvider)BlocksAS.RITUAL_LINK, "RITUAL_LINK", 0.5f, 3.5f).addPage(RegistryResearch.text("RITUAL_LINK.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.RITUAL_LINK)).addTomeLookup((IItemProvider)BlocksAS.RITUAL_LINK, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resIlluminationWand = new ResearchNode((IItemProvider)ItemsAS.ILLUMINATION_WAND, "ILLUMINATION_WAND", 0.25f, 2.5f).addPage(RegistryResearch.text("ILLUMINATION_WAND.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.ILLUMINATION_WAND)).addTomeLookup((IItemProvider)ItemsAS.ILLUMINATION_WAND, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("ILLUMINATION_WAND.3")).register(ResearchProgression.CONSTELLATION);
        ResearchNode resInfusedTools = new ResearchNode(new IItemProvider[]{ItemsAS.INFUSED_CRYSTAL_SWORD, ItemsAS.INFUSED_CRYSTAL_PICKAXE, ItemsAS.INFUSED_CRYSTAL_AXE, ItemsAS.INFUSED_CRYSTAL_SHOVEL}, "CHARGED_TOOLS", 0.25f, 1.25f).addPage(RegistryResearch.text("CHARGED_TOOLS.1")).addPage(RegistryResearch.text("CHARGED_TOOLS.2")).addPage(RegistryResearch.recipeInfusion((IItemProvider)ItemsAS.INFUSED_CRYSTAL_SWORD)).addTomeLookup((IItemProvider)ItemsAS.INFUSED_CRYSTAL_SWORD, 2, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.recipeInfusion((IItemProvider)ItemsAS.INFUSED_CRYSTAL_PICKAXE)).addTomeLookup((IItemProvider)ItemsAS.INFUSED_CRYSTAL_PICKAXE, 3, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.recipeInfusion((IItemProvider)ItemsAS.INFUSED_CRYSTAL_AXE)).addTomeLookup((IItemProvider)ItemsAS.INFUSED_CRYSTAL_AXE, 4, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.recipeInfusion((IItemProvider)ItemsAS.INFUSED_CRYSTAL_SHOVEL)).addTomeLookup((IItemProvider)ItemsAS.INFUSED_CRYSTAL_SHOVEL, 5, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resTreeBeacon = new ResearchNode((IItemProvider)BlocksAS.TREE_BEACON, "TREEBEACON", 1.25f, 0.5f).addPage(RegistryResearch.text("TREEBEACON.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.TREE_BEACON)).addTomeLookup((IItemProvider)BlocksAS.TREE_BEACON, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("TREEBEACON.3")).register(ResearchProgression.CONSTELLATION);
        ResearchNode resPrism = new ResearchNode((IItemProvider)BlocksAS.PRISM, "PRISM", 2.75f, 0.0f).addPage(RegistryResearch.text("PRISM.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.PRISM)).addTomeLookup((IItemProvider)BlocksAS.PRISM, 1, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resEngravingTable = new ResearchNode((IItemProvider)BlocksAS.REFRACTION_TABLE, "DRAWING_TABLE", 3.5f, 1.0f).addPage(RegistryResearch.text("DRAWING_TABLE.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.REFRACTION_TABLE)).addTomeLookup((IItemProvider)BlocksAS.REFRACTION_TABLE, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("DRAWING_TABLE.3")).addPage(RegistryResearch.text("DRAWING_TABLE.4")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.INFUSED_GLASS)).addTomeLookup((IItemProvider)ItemsAS.INFUSED_GLASS, 4, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("DRAWING_TABLE.6")).register(ResearchProgression.CONSTELLATION);
        ResearchNode resAltar4 = new ResearchNode((IItemProvider)BlocksAS.ALTAR_RADIANCE, "ALTAR4", 3.5f, 3.0f).addPage(RegistryResearch.text("ALTAR4.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ALTAR_RADIANCE)).addTomeLookup((IItemProvider)BlocksAS.ALTAR_RADIANCE, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_ALTAR_TRAIT)).addPage(RegistryResearch.text("ALTAR4.4")).register(ResearchProgression.CONSTELLATION);
        ResearchNode resCollectorCrystal = new ResearchNode((IItemProvider)BlocksAS.ROCK_COLLECTOR_CRYSTAL, "COLL_CRYSTAL", 2.75f, 3.75f).addPage(RegistryResearch.text("COLL_CRYSTAL.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ROCK_COLLECTOR_CRYSTAL)).addTomeLookup((IItemProvider)BlocksAS.ROCK_COLLECTOR_CRYSTAL, 1, ResearchProgression.CONSTELLATION).addTomeLookup((IItemProvider)BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL, 1, ResearchProgression.CONSTELLATION).addPage(RegistryResearch.text("COLL_CRYSTAL.3")).addPage(RegistryResearch.text("COLL_CRYSTAL.4")).register(ResearchProgression.CONSTELLATION);
        ItemStack celestialCrystalCluster = new ItemStack((IItemProvider)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER);
        celestialCrystalCluster.func_196085_b(4);
        ResearchNode resCelestialCrystalCluster = new ResearchNode(celestialCrystalCluster, "CEL_CRYSTAL_GROW", 6.25f, 4.0f).addPage(RegistryResearch.text("CEL_CRYSTAL_GROW.1")).addPage(RegistryResearch.text("CEL_CRYSTAL_GROW.2")).addPage(RegistryResearch.text("CEL_CRYSTAL_GROW.3")).addTomeLookup((IItemProvider)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER, 0, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resCelestialCrystals = new ResearchNode((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL, "CEL_CRYSTALS", 5.0f, 3.75f).addPage(RegistryResearch.text("CEL_CRYSTALS.1")).addTomeLookup((IItemProvider)ItemsAS.CELESTIAL_CRYSTAL, 0, ResearchProgression.CONSTELLATION).register(ResearchProgression.CONSTELLATION);
        ResearchNode resEnhancedCollectorCrystal = new ResearchNode((IItemProvider)BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL, "ENHANCED_COLLECTOR", 4.0f, 4.5f).addPage(RegistryResearch.text("ENHANCED_COLLECTOR.1")).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_ENHANCED_COLLECTOR_CRYSTAL)).register(ResearchProgression.CONSTELLATION);
        resColoredLensFire.addSourceConnectionFrom(resLenses);
        resColoredLensBreak.addSourceConnectionFrom(resLenses);
        resColoredLensDamage.addSourceConnectionFrom(resLenses);
        resColoredLensPush.addSourceConnectionFrom(resLenses);
        resColoredLensRegeneration.addSourceConnectionFrom(resLenses);
        resColoredLensGrowth.addSourceConnectionFrom(resLenses);
        resColoredLensSpectral.addSourceConnectionFrom(resLenses);
        resColoredLensSpectral.addSourceConnectionFrom(resInfuser);
        resEngravingTable.addSourceConnectionFrom(resColoredLensSpectral);
        resEnchantmentAmulet.addSourceConnectionFrom(resInfuser);
        resRitualLink.addSourceConnectionFrom(resInfuser);
        resIlluminationWand.addSourceConnectionFrom(resInfuser);
        resInfusedTools.addSourceConnectionFrom(resInfuser);
        resTreeBeacon.addSourceConnectionFrom(resInfuser);
        resPrism.addSourceConnectionFrom(resInfuser);
        resAltar4.addSourceConnectionFrom(resInfuser);
        resEngravingTable.addSourceConnectionFrom(resInfuser);
        resCollectorCrystal.addSourceConnectionFrom(resInfuser);
        resCelestialCrystals.addSourceConnectionFrom(resCelestialCrystalCluster);
        resAltar4.addSourceConnectionFrom(resCelestialCrystals);
        resEnhancedCollectorCrystal.addSourceConnectionFrom(resCollectorCrystal);
        resEnhancedCollectorCrystal.addSourceConnectionFrom(resCelestialCrystals);
    }

    private static void registerAttunement() {
        ResearchNode resTelescope = new ResearchNode((IItemProvider)BlocksAS.TELESCOPE, "TELESCOPE", 0.5f, 0.0f).addPage(RegistryResearch.text("TELESCOPE.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.TELESCOPE)).addTomeLookup((IItemProvider)BlocksAS.TELESCOPE, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("TELESCOPE.3")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resKnowledgeShare = new ResearchNode((IItemProvider)ItemsAS.KNOWLEDGE_SHARE, "KNOWLEDGE_SHARE", 2.5f, 0.25f).addPage(RegistryResearch.text("KNOWLEDGE_SHARE.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.KNOWLEDGE_SHARE)).addTomeLookup((IItemProvider)ItemsAS.KNOWLEDGE_SHARE, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resLens = new ResearchNode((IItemProvider)BlocksAS.LENS, "LENS", 0.0f, 1.25f).addPage(RegistryResearch.text("LENS.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.LENS)).addTomeLookup((IItemProvider)BlocksAS.LENS, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("LENS.3")).addPage(RegistryResearch.text("LENS.4")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resLinkingTool = new ResearchNode((IItemProvider)ItemsAS.LINKING_TOOL, "LINKTOOL", 0.25f, 2.25f).addPage(RegistryResearch.text("LINKTOOL.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.LINKING_TOOL)).addTomeLookup((IItemProvider)ItemsAS.LINKING_TOOL, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("LINKTOOL.3")).addPage(RegistryResearch.text("LINKTOOL.4")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resStarlightNetwork = new ResearchNode((IItemProvider)BlocksAS.LENS, "STARLIGHT_NETWORK", 1.5f, 1.0f).addPage(RegistryResearch.text("STARLIGHT_NETWORK.1")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resTransmutationOres = new ResearchNode(new IItemProvider[]{Blocks.field_196814_hQ, Blocks.field_150354_m, Blocks.field_150482_ag, Blocks.field_189878_dg, Blocks.field_150423_aK, Blocks.field_150322_A}, "TRANSMUTATION_ORES", 2.75f, 1.5f).addPage(RegistryResearch.text("TRANSMUTATION_ORES.1")).addPage(RegistryResearch.recipeTransmutation((IItemProvider)Blocks.field_150435_aG)).addPage(RegistryResearch.recipeTransmutation((IItemProvider)Blocks.field_150412_bA)).addPage(RegistryResearch.recipeTransmutation((IItemProvider)Blocks.field_150414_aQ)).addPage(RegistryResearch.recipeTransmutation((IItemProvider)Blocks.field_150368_y)).addPage(RegistryResearch.recipeTransmutation((IItemProvider)Blocks.field_150377_bs)).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resStarmetalOre = new ResearchNode((IItemProvider)BlocksAS.STARMETAL_ORE, "STARMETAL_ORE", 4.25f, 1.75f).addPage(RegistryResearch.text("STARMETAL_ORE.1")).addPage(RegistryResearch.recipeTransmutation((IItemProvider)BlocksAS.STARMETAL_ORE)).addTomeLookup((IItemProvider)ItemsAS.STARMETAL_INGOT, 0, ResearchProgression.ATTUNEMENT).addTomeLookup((IItemProvider)BlocksAS.STARMETAL_ORE, 0, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resCuttingTool = new ResearchNode((IItemProvider)ItemsAS.CHISEL, "CUTTING_TOOL", 5.0f, 1.0f).addPage(RegistryResearch.text("CUTTING_TOOL.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.CHISEL)).addTomeLookup((IItemProvider)ItemsAS.CHISEL, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("CUTTING_TOOL.3")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resStardust = new ResearchNode((IItemProvider)ItemsAS.STARDUST, "STARDUST", 6.0f, 0.5f).addPage(RegistryResearch.text("STARDUST.1")).addPage(RegistryResearch.text("STARDUST.2")).addTomeLookup((IItemProvider)ItemsAS.STARDUST, 0, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ItemStack structureResonator = ItemResonator.setUpgradeUnlocked(new ItemStack((IItemProvider)ItemsAS.RESONATOR), ItemResonator.ResonatorUpgrade.STARLIGHT, ItemResonator.ResonatorUpgrade.AREA_SIZE);
        ItemResonator.setCurrentUpgradeUnsafe(structureResonator, ItemResonator.ResonatorUpgrade.AREA_SIZE);
        ResearchNode resResonatorStructure = new ResearchNode(structureResonator, "RESONATOR_AREA_SIZE", 6.5f, 2.0f).addPage(RegistryResearch.text("RESONATOR_AREA_SIZE.1")).addPage(RegistryResearch.recipe((ItemStack stack) -> ItemsAS.RESONATOR.equals(stack.func_77973_b()) && ItemResonator.getCurrentUpgrade(null, stack) == ItemResonator.ResonatorUpgrade.AREA_SIZE)).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resCelestialGateway = new ResearchNode((IItemProvider)BlocksAS.GATEWAY, "CELESTIAL_GATEWAY", 7.5f, 1.5f).addPage(RegistryResearch.text("CELESTIAL_GATEWAY.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.GATEWAY)).addTomeLookup((IItemProvider)BlocksAS.GATEWAY, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("CELESTIAL_GATEWAY.3")).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_CELESTIAL_GATEWAY)).addPage(RegistryResearch.text("CELESTIAL_GATEWAY.5")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resAltar3 = new ResearchNode((IItemProvider)BlocksAS.ALTAR_CONSTELLATION, "ALTAR3", 7.25f, 0.0f).addPage(RegistryResearch.text("ALTAR3.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ALTAR_CONSTELLATION)).addTomeLookup((IItemProvider)BlocksAS.ALTAR_CONSTELLATION, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_ALTAR_CONSTELLATION)).addPage(RegistryResearch.text("ALTAR3.4")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resAttunePlayer = new ResearchNode((IItemProvider)BlocksAS.ATTUNEMENT_ALTAR, "ATT_PLAYER", 3.75f, 2.75f).addPage(RegistryResearch.text("ATT_PLAYER.1")).addPage(RegistryResearch.text("ATT_PLAYER.2")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ATTUNEMENT_ALTAR)).addTomeLookup((IItemProvider)BlocksAS.ATTUNEMENT_ALTAR, 2, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("ATT_PLAYER.4")).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_ATTUNEMENT_ALTAR)).addPage(RegistryResearch.text("ATT_PLAYER.6")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resPerks = new ResearchNode((IItemProvider)BlocksAS.SPECTRAL_RELAY, "ATT_PERKS", 4.5f, 3.5f).addPage(RegistryResearch.text("ATT_PERKS.1")).addPage(RegistryResearch.text("ATT_PERKS.2")).addPage(RegistryResearch.text("ATT_PERKS.3")).addPage(RegistryResearch.text("ATT_PERKS.4")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resShiftingStar = new ResearchNode((IItemProvider)ItemsAS.SHIFTING_STAR, "SHIFT_STAR", 5.75f, 3.25f).addPage(RegistryResearch.text("SHIFT_STAR.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.SHIFTING_STAR)).addTomeLookup((IItemProvider)ItemsAS.SHIFTING_STAR, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resPerkSeal = new ResearchNode((IItemProvider)ItemsAS.PERK_SEAL, "ATT_PERKS_SEAL", 5.5f, 4.5f).addPage(RegistryResearch.text("ATT_PERKS_SEAL.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.PERK_SEAL)).addTomeLookup((IItemProvider)ItemsAS.PERK_SEAL, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resPerkGems = new ResearchNode(new IItemProvider[]{ItemsAS.PERK_GEM_DAY, ItemsAS.PERK_GEM_NIGHT, ItemsAS.PERK_GEM_SKY}, "ATT_PERK_GEMS", 4.75f, 5.25f).addPage(RegistryResearch.text("ATT_PERK_GEMS.1")).addPage(RegistryResearch.text("ATT_PERK_GEMS.2")).addPage(RegistryResearch.text("ATT_PERK_GEMS.3")).addTomeLookup((IItemProvider)ItemsAS.PERK_GEM_DAY, 1, ResearchProgression.ATTUNEMENT).addTomeLookup((IItemProvider)ItemsAS.PERK_GEM_NIGHT, 1, ResearchProgression.ATTUNEMENT).addTomeLookup((IItemProvider)ItemsAS.PERK_GEM_SKY, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resAttuneCrystal = new ResearchNode((IItemProvider)ItemsAS.ROCK_CRYSTAL, "ATT_CRYSTAL", 3.5f, 4.0f).addPage(RegistryResearch.text("ATT_CRYSTAL.1")).addPage(RegistryResearch.text("ATT_CRYSTAL.2")).addTomeLookup((IItemProvider)ItemsAS.ATTUNED_ROCK_CRYSTAL, 0, ResearchProgression.ATTUNEMENT).addTomeLookup((IItemProvider)ItemsAS.ATTUNED_CELESTIAL_CRYSTAL, 0, ResearchProgression.CONSTELLATION).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resRitualPedestal = new ResearchNode((IItemProvider)BlocksAS.RITUAL_PEDESTAL, "RIT_PEDESTAL", 3.0f, 5.0f).addPage(RegistryResearch.text("RIT_PEDESTAL.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.RITUAL_PEDESTAL)).addTomeLookup((IItemProvider)BlocksAS.RITUAL_PEDESTAL, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_RITUAL_PEDESTAL)).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resRitualPedestalAcceleration = new ResearchNode((IItemProvider)BlocksAS.RITUAL_PEDESTAL, "PED_ACCEL", 1.75f, 5.5f).addPage(RegistryResearch.text("PED_ACCEL.1")).addPage(RegistryResearch.text("PED_ACCEL.2")).addPage(RegistryResearch.text("PED_ACCEL.3")).addPage(RegistryResearch.text("PED_ACCEL.4")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resAlignmentCharge = new ResearchNode(new SpriteQuery(AssetLoader.TextureLocation.EFFECT, 6, 8, "relay_flare"), "QUICK_CHARGE", 0.75f, 4.5f).addPage(RegistryResearch.text("QUICK_CHARGE.1")).addPage(RegistryResearch.text("QUICK_CHARGE.2")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resToolChanneling = new ResearchNode((IItemProvider)BlocksAS.SPECTRAL_RELAY, "TOOL_CHANNEL", 1.25f, 3.25f).addPage(RegistryResearch.text("TOOL_CHANNEL.1")).addPage(RegistryResearch.text("TOOL_CHANNEL.2")).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resBlinkWand = new ResearchNode((IItemProvider)ItemsAS.BLINK_WAND, "TRAVERSAL_WAND", 2.25f, 3.5f).addPage(RegistryResearch.text("TRAVERSAL_WAND.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.BLINK_WAND)).addTomeLookup((IItemProvider)ItemsAS.BLINK_WAND, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resGrappleWand = new ResearchNode((IItemProvider)ItemsAS.GRAPPLE_WAND, "GRAPPLE_WAND", 2.5f, 2.5f).addPage(RegistryResearch.text("GRAPPLE_WAND.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.GRAPPLE_WAND)).addTomeLookup((IItemProvider)ItemsAS.GRAPPLE_WAND, 1, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        ResearchNode resToolWands = new ResearchNode(new IItemProvider[]{ItemsAS.ARCHITECT_WAND, ItemsAS.EXCHANGE_WAND}, "TOOL_WANDS", 1.5f, 2.25f).addPage(RegistryResearch.text("TOOL_WANDS.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.ARCHITECT_WAND)).addTomeLookup((IItemProvider)ItemsAS.ARCHITECT_WAND, 1, ResearchProgression.ATTUNEMENT).addPage(RegistryResearch.text("TOOL_WANDS.3")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.EXCHANGE_WAND)).addTomeLookup((IItemProvider)ItemsAS.EXCHANGE_WAND, 3, ResearchProgression.ATTUNEMENT).register(ResearchProgression.ATTUNEMENT);
        resStarlightNetwork.addSourceConnectionFrom(resLens);
        resStarlightNetwork.addSourceConnectionFrom(resLinkingTool);
        resTransmutationOres.addSourceConnectionFrom(resStarlightNetwork);
        resStarmetalOre.addSourceConnectionFrom(resTransmutationOres);
        resCuttingTool.addSourceConnectionFrom(resStarmetalOre);
        resStardust.addSourceConnectionFrom(resCuttingTool);
        resResonatorStructure.addSourceConnectionFrom(resStardust);
        resCelestialGateway.addSourceConnectionFrom(resStardust);
        resAltar3.addSourceConnectionFrom(resStardust);
        resAttunePlayer.addSourceConnectionFrom(resStarmetalOre);
        resPerks.addSourceConnectionFrom(resAttunePlayer);
        resShiftingStar.addSourceConnectionFrom(resPerks);
        resPerkSeal.addSourceConnectionFrom(resPerks);
        resPerkGems.addSourceConnectionFrom(resPerks);
        resAttuneCrystal.addSourceConnectionFrom(resAttunePlayer);
        resRitualPedestal.addSourceConnectionFrom(resAttuneCrystal);
        resRitualPedestalAcceleration.addSourceConnectionFrom(resRitualPedestal);
        resToolChanneling.addSourceConnectionFrom(resAlignmentCharge);
        resBlinkWand.addSourceConnectionFrom(resToolChanneling);
        resGrappleWand.addSourceConnectionFrom(resToolChanneling);
        resToolWands.addSourceConnectionFrom(resToolChanneling);
    }

    private static void registerCrafting() {
        ResearchNode resHandTelescope = new ResearchNode((IItemProvider)ItemsAS.HAND_TELESCOPE, "HAND_TELESCOPE", 0.0f, 1.0f).addPage(RegistryResearch.text("HAND_TELESCOPE.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.GLASS_LENS)).addTomeLookup((IItemProvider)ItemsAS.GLASS_LENS, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.HAND_TELESCOPE)).addTomeLookup((IItemProvider)ItemsAS.HAND_TELESCOPE, 2, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.text("HAND_TELESCOPE.4")).addPage(RegistryResearch.text("HAND_TELESCOPE.5")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resIlluminationPowder = new ResearchNode((IItemProvider)ItemsAS.ILLUMINATION_POWDER, "ILLUM_POWDER", 1.0f, 2.0f).addPage(RegistryResearch.text("ILLUM_POWDER.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.ILLUMINATION_POWDER)).addTomeLookup((IItemProvider)ItemsAS.ILLUMINATION_POWDER, 1, ResearchProgression.BASIC_CRAFT).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resNocturnalPowder = new ResearchNode((IItemProvider)ItemsAS.NOCTURNAL_POWDER, "NOC_POWDER", 0.0f, 2.5f).addPage(RegistryResearch.text("NOC_POWDER.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.NOCTURNAL_POWDER)).addTomeLookup((IItemProvider)ItemsAS.NOCTURNAL_POWDER, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.text("NOC_POWDER.3")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resIlluminator = new ResearchNode((IItemProvider)BlocksAS.ILLUMINATOR, "ILLUMINATOR", 0.75f, 3.0f).addPage(RegistryResearch.text("ILLUMINATOR.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ILLUMINATOR)).addTomeLookup((IItemProvider)BlocksAS.ILLUMINATOR, 1, ResearchProgression.BASIC_CRAFT).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resRockCrystals = new ResearchNode((IItemProvider)ItemsAS.ROCK_CRYSTAL, "ROCK_CRYSTALS", 2.0f, 1.5f).addPage(RegistryResearch.text("ROCK_CRYSTALS.1")).addPage(RegistryResearch.text("ROCK_CRYSTALS.2")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resCrystalGrowth = new ResearchNode((IItemProvider)ItemsAS.ROCK_CRYSTAL, "CRYSTAL_GROWTH", 3.0f, 2.5f).addPage(RegistryResearch.text("CRYSTAL_GROWTH.1")).addPage(RegistryResearch.text("CRYSTAL_GROWTH.2")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resTools = new ResearchNode(new IItemProvider[]{ItemsAS.CRYSTAL_SWORD, ItemsAS.CRYSTAL_PICKAXE, ItemsAS.CRYSTAL_AXE, ItemsAS.CRYSTAL_SHOVEL}, "TOOLS", 4.5f, 3.0f).addPage(RegistryResearch.text("TOOLS.1")).addPage(RegistryResearch.text("TOOLS.3")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.CRYSTAL_SWORD)).addTomeLookup((IItemProvider)ItemsAS.CRYSTAL_SWORD, 2, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.CRYSTAL_PICKAXE)).addTomeLookup((IItemProvider)ItemsAS.CRYSTAL_PICKAXE, 3, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.CRYSTAL_AXE)).addTomeLookup((IItemProvider)ItemsAS.CRYSTAL_AXE, 4, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.CRYSTAL_SHOVEL)).addTomeLookup((IItemProvider)ItemsAS.CRYSTAL_SHOVEL, 5, ResearchProgression.BASIC_CRAFT).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resLightwell = new ResearchNode((IItemProvider)BlocksAS.WELL, "WELL", 3.0f, 1.0f).addPage(RegistryResearch.text("WELL.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.WELL)).addTomeLookup((IItemProvider)BlocksAS.WELL, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.text("WELL.3")).addPage(RegistryResearch.text("WELL.4")).addPage(RegistryResearch.text("WELL.5")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resInfusedWood = new ResearchNode(new IItemProvider[]{BlocksAS.INFUSED_WOOD, BlocksAS.INFUSED_WOOD_ARCH, BlocksAS.INFUSED_WOOD_COLUMN, BlocksAS.INFUSED_WOOD_ENGRAVED, BlocksAS.INFUSED_WOOD_ENRICHED, BlocksAS.INFUSED_WOOD_PLANKS, BlocksAS.INFUSED_WOOD_STAIRS, BlocksAS.INFUSED_WOOD_SLAB}, "INFUSED_WOOD", 4.0f, 0.0f).addPage(RegistryResearch.text("INFUSED_WOOD.1")).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD, 0, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_PLANKS)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_PLANKS, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_ARCH)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_ARCH, 2, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_COLUMN)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_COLUMN, 3, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_ENGRAVED)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_ENGRAVED, 4, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_ENRICHED)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_ENRICHED, 5, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_STAIRS)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_STAIRS, 6, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.INFUSED_WOOD_SLAB)).addTomeLookup((IItemProvider)BlocksAS.INFUSED_WOOD_SLAB, 7, ResearchProgression.BASIC_CRAFT).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resAltar2 = new ResearchNode((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT, "ALTAR2", 4.0f, 1.5f).addPage(RegistryResearch.text("ALTAR2.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT)).addTomeLookup((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_ALTAR_ATTUNEMENT)).addPage(RegistryResearch.text("ALTAR2.4")).register(ResearchProgression.BASIC_CRAFT);
        ItemStack starlightResonator = ItemResonator.setUpgradeUnlocked(new ItemStack((IItemProvider)ItemsAS.RESONATOR), ItemResonator.ResonatorUpgrade.STARLIGHT);
        ItemResonator.setCurrentUpgradeUnsafe(starlightResonator, ItemResonator.ResonatorUpgrade.STARLIGHT);
        ResearchNode resResonator = new ResearchNode(starlightResonator, "SKY_RESO", 5.0f, 0.5f).addPage(RegistryResearch.text("SKY_RESO.1")).addPage(RegistryResearch.recipe((ItemStack stack) -> ItemsAS.RESONATOR.equals(stack.func_77973_b()) && ItemResonator.getCurrentUpgrade(null, stack) == ItemResonator.ResonatorUpgrade.STARLIGHT)).addPage(RegistryResearch.text("SKY_RESO.2")).addPage(RegistryResearch.text("SKY_RESO.3")).register(ResearchProgression.BASIC_CRAFT);
        ResearchNode resSpectralRelay = new ResearchNode((IItemProvider)BlocksAS.SPECTRAL_RELAY, "SPEC_RELAY", 6.0f, 1.0f).addPage(RegistryResearch.text("SPEC_RELAY.1")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.SPECTRAL_RELAY)).addTomeLookup((IItemProvider)BlocksAS.SPECTRAL_RELAY, 1, ResearchProgression.BASIC_CRAFT).addPage(RegistryResearch.structure(StructureTypesAS.PTYPE_SPECTRAL_RELAY)).addPage(RegistryResearch.text("SPEC_RELAY.4")).register(ResearchProgression.BASIC_CRAFT);
        resNocturnalPowder.addSourceConnectionFrom(resIlluminationPowder);
        resIlluminator.addSourceConnectionFrom(resIlluminationPowder);
        resCrystalGrowth.addSourceConnectionFrom(resRockCrystals);
        resTools.addSourceConnectionFrom(resCrystalGrowth);
        resLightwell.addSourceConnectionFrom(resRockCrystals);
        resInfusedWood.addSourceConnectionFrom(resLightwell);
        resAltar2.addSourceConnectionFrom(resLightwell);
        resResonator.addSourceConnectionFrom(resLightwell);
        resSpectralRelay.addSourceConnectionFrom(resResonator);
    }

    private static void registerDiscovery() {
        ResearchNode resWelcome = new ResearchNode((IItemProvider)ItemsAS.TOME, "WELCOME", 1.0f, 1.0f).addPage(RegistryResearch.text("WELCOME.1")).addPage(RegistryResearch.text("WELCOME.2")).register(ResearchProgression.DISCOVERY);
        ResearchNode resShrines = new ResearchNode((IItemProvider)ItemsAS.ROCK_CRYSTAL, "SHRINES", 2.0f, 0.0f).addPage(RegistryResearch.text("SHRINES.1")).addPage(RegistryResearch.text("SHRINES.2")).addPage(RegistryResearch.text("SHRINES.3")).register(ResearchProgression.DISCOVERY);
        ResearchNode resConstellationPaper = new ResearchNode((IItemProvider)ItemsAS.CONSTELLATION_PAPER, "CPAPER", 3.0f, 1.0f).addPage(RegistryResearch.text("CPAPER.1")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.TOME)).addPage(RegistryResearch.text("CPAPER.3")).addPage(RegistryResearch.recipe((IItemProvider)ItemsAS.PARCHMENT)).addTomeLookup((IItemProvider)ItemsAS.CONSTELLATION_PAPER, 0, ResearchProgression.DISCOVERY).addTomeLookup((IItemProvider)ItemsAS.TOME, 1, ResearchProgression.DISCOVERY).addTomeLookup((IItemProvider)ItemsAS.PARCHMENT, 3, ResearchProgression.DISCOVERY).register(ResearchProgression.DISCOVERY);
        ResearchNode resOres = new ResearchNode(new IItemProvider[]{BlocksAS.ROCK_CRYSTAL_ORE, BlocksAS.AQUAMARINE_SAND_ORE}, "ORES", 2.0f, 2.0f).addPage(RegistryResearch.text("ORES.1")).addPage(RegistryResearch.text("ORES.2")).addTomeLookup((IItemProvider)ItemsAS.AQUAMARINE, 0, ResearchProgression.DISCOVERY).addTomeLookup((IItemProvider)ItemsAS.ROCK_CRYSTAL, 0, ResearchProgression.DISCOVERY).addTomeLookup((IItemProvider)BlocksAS.AQUAMARINE_SAND_ORE, 0, ResearchProgression.DISCOVERY).addTomeLookup((IItemProvider)BlocksAS.ROCK_CRYSTAL_ORE, 0, ResearchProgression.DISCOVERY).register(ResearchProgression.DISCOVERY);
        ResearchNode resResonatingWand = new ResearchNode((IItemProvider)ItemsAS.WAND, "WAND", 3.0f, 3.0f).addPage(RegistryResearch.text("WAND.1")).addPage(RegistryResearch.recipeVanilla((IItemProvider)ItemsAS.WAND)).addTomeLookup((IItemProvider)ItemsAS.WAND, 1, ResearchProgression.DISCOVERY).addPage(RegistryResearch.text("WAND.3")).addPage(RegistryResearch.text("WAND.4")).register(ResearchProgression.DISCOVERY);
        ResearchNode resAltar1 = new ResearchNode((IItemProvider)BlocksAS.ALTAR_DISCOVERY, "ALTAR1", 4.0f, 2.0f).addPage(RegistryResearch.text("ALTAR1.1")).addPage(RegistryResearch.text("ALTAR1.2")).addPage(RegistryResearch.recipeTransmutation((IItemProvider)BlocksAS.ALTAR_DISCOVERY)).addTomeLookup((IItemProvider)BlocksAS.ALTAR_DISCOVERY, 1, ResearchProgression.DISCOVERY).addPage(RegistryResearch.text("ALTAR1.4")).addPage(RegistryResearch.text("ALTAR1.5")).addPage(RegistryResearch.text("ALTAR1.6")).register(ResearchProgression.DISCOVERY);
        ResearchNode resMarbles = new ResearchNode(new IItemProvider[]{BlocksAS.MARBLE_RAW, BlocksAS.MARBLE_PILLAR, BlocksAS.MARBLE_ARCH, BlocksAS.MARBLE_BRICKS, BlocksAS.MARBLE_CHISELED, BlocksAS.MARBLE_ENGRAVED, BlocksAS.MARBLE_RUNED, BlocksAS.MARBLE_SLAB, BlocksAS.MARBLE_STAIRS}, "MARBLETYPES", 0.0f, 2.5f).addPage(RegistryResearch.text("MARBLETYPES.1")).addPage(RegistryResearch.text("MARBLETYPES.2")).addTomeLookup((IItemProvider)BlocksAS.MARBLE_RAW, 1, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_PILLAR)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_PILLAR, 2, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_ARCH)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_ARCH, 3, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_BRICKS)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_BRICKS, 4, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_CHISELED)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_CHISELED, 5, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_ENGRAVED)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_ENGRAVED, 6, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_RUNED)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_RUNED, 7, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_SLAB)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_SLAB, 8, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.MARBLE_STAIRS)).addTomeLookup((IItemProvider)BlocksAS.MARBLE_STAIRS, 9, ResearchProgression.DISCOVERY).register(ResearchProgression.DISCOVERY);
        ResearchNode resSootyMarble = new ResearchNode(new IItemProvider[]{BlocksAS.BLACK_MARBLE_RAW, BlocksAS.BLACK_MARBLE_PILLAR, BlocksAS.BLACK_MARBLE_ARCH, BlocksAS.BLACK_MARBLE_BRICKS, BlocksAS.BLACK_MARBLE_CHISELED, BlocksAS.BLACK_MARBLE_ENGRAVED, BlocksAS.BLACK_MARBLE_RUNED, BlocksAS.BLACK_MARBLE_SLAB, BlocksAS.BLACK_MARBLE_STAIRS}, "SOOTYMARBLE", 1.0f, 3.0f).addPage(RegistryResearch.text("SOOTYMARBLE.1")).addPage(RegistryResearch.text("SOOTYMARBLE.2")).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_RAW)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_RAW, 2, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_PILLAR)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_PILLAR, 3, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_ARCH)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_ARCH, 4, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_BRICKS)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_BRICKS, 5, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_CHISELED)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_CHISELED, 6, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_ENGRAVED)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_ENGRAVED, 7, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_RUNED)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_RUNED, 8, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_SLAB)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_SLAB, 9, ResearchProgression.DISCOVERY).addPage(RegistryResearch.recipe((IItemProvider)BlocksAS.BLACK_MARBLE_STAIRS)).addTomeLookup((IItemProvider)BlocksAS.BLACK_MARBLE_STAIRS, 10, ResearchProgression.DISCOVERY).register(ResearchProgression.DISCOVERY);
        resShrines.addSourceConnectionFrom(resWelcome);
        resConstellationPaper.addSourceConnectionFrom(resShrines);
        resMarbles.addSourceConnectionFrom(resWelcome);
        resSootyMarble.addSourceConnectionFrom(resMarbles);
        resOres.addSourceConnectionFrom(resWelcome);
        resResonatingWand.addSourceConnectionFrom(resOres);
        resAltar1.addSourceConnectionFrom(resResonatingWand);
    }

    private static JournalPage recipe(IItemProvider outputItem) {
        return JournalPageRecipe.fromOutputPreferAltarRecipes(stack -> !stack.func_190926_b() && stack.func_77973_b().equals(outputItem.func_199767_j()));
    }

    private static JournalPage recipeVanilla(IItemProvider outputItem) {
        return JournalPageRecipe.fromOutputPreferVanillaRecipes(stack -> !stack.func_190926_b() && stack.func_77973_b().equals(outputItem.func_199767_j()));
    }

    private static JournalPage recipeTransmutation(IItemProvider outputItem) {
        return JournalPageBlockTransmutation.fromOutput(stack -> !stack.func_190926_b() && stack.func_77973_b().equals(outputItem.func_199767_j()));
    }

    private static JournalPage recipeInfusion(IItemProvider outputItem) {
        return JournalPageLiquidInfusion.fromOutput(stack -> !stack.func_190926_b() && stack.func_77973_b().equals(outputItem.func_199767_j()));
    }

    private static JournalPage recipe(Predicate<ItemStack> itemStackFilter) {
        return JournalPageRecipe.fromOutputPreferAltarRecipes(itemStackFilter);
    }

    private static JournalPage recipeVanilla(Predicate<ItemStack> itemStackFilter) {
        return JournalPageRecipe.fromOutputPreferVanillaRecipes(itemStackFilter);
    }

    private static JournalPageBlockTransmutation recipeTransmutation(Predicate<ItemStack> itemStackFilter) {
        return JournalPageBlockTransmutation.fromOutput(itemStackFilter);
    }

    private static JournalPageLiquidInfusion recipeInfusion(Predicate<ItemStack> itemStackFilter) {
        return JournalPageLiquidInfusion.fromOutput(itemStackFilter);
    }

    private static JournalPage structure(StructureType structure) {
        return new JournalPageStructure(structure.getStructure());
    }

    private static JournalPage text(String identifier) {
        return new JournalPageText("astralsorcery".toLowerCase(Locale.ROOT) + ".journal." + identifier + ".text");
    }
}

