/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal;

import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.tile.TileLens;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CrystalTransmissionNode
extends SimpleTransmissionNode {
    private CrystalAttributes attributes;
    private float additionalLoss = 1.0f;

    public CrystalTransmissionNode(BlockPos thisPos, CrystalAttributes attributes) {
        super(thisPos);
        this.attributes = attributes;
    }

    public CrystalTransmissionNode(BlockPos thisPos) {
        super(thisPos);
    }

    public boolean updateAdditionalLoss(float loss) {
        boolean didChange = this.additionalLoss != loss;
        this.additionalLoss = loss;
        return didChange;
    }

    @Override
    public void onTransmissionTick(World world, float starlightAmt, IWeakConstellation type) {
        TileLens lens = MiscUtils.getTileAt((IBlockReader)world, this.getLocationPos(), TileLens.class, false);
        if (lens != null) {
            lens.transmissionTick(starlightAmt, type);
        }
    }

    @Override
    public float getTransmissionConsumptionMultiplier() {
        return this.additionalLoss;
    }

    @Override
    public boolean needsTransmissionUpdate() {
        return true;
    }

    @Override
    public CrystalAttributes getTransmissionProperties() {
        return this.attributes;
    }

    @Override
    public TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.attributes = CrystalAttributes.getCrystalAttributes(compound);
        this.additionalLoss = compound.func_74760_g("lossMultiplier");
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        if (this.attributes != null) {
            this.attributes.store(compound);
        }
        compound.func_74776_a("lossMultiplier", this.additionalLoss);
    }

    public static class Provider
    extends TransmissionProvider {
        @Override
        public IPrismTransmissionNode get() {
            return new CrystalTransmissionNode(null);
        }
    }
}

