/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base;

import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.TileRequiresMultiblock;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObserverHelper;
import hellfirepvp.observerlib.common.change.ChangeObserverStructure;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityTick
extends TileEntitySynchronized
implements ITickableTileEntity,
TileRequiresMultiblock {
    private boolean doesSeeSky = false;
    private int lastUpdateTick = -1;
    private ChangeSubscriber<ChangeObserverStructure> structureMatch;
    private boolean hasMultiblock = false;
    protected int ticksExisted = 0;

    protected TileEntityTick(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.ticksExisted == 0) {
            this.onFirstTick();
        }
        ++this.ticksExisted;
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        return null;
    }

    public boolean seesSkyInNoSkyWorlds() {
        return false;
    }

    protected void onFirstTick() {
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    public boolean doesSeeSky() {
        if (this.func_145831_w().func_201670_d()) {
            return this.doesSeeSky;
        }
        if (this.lastUpdateTick == -1 || this.ticksExisted - this.lastUpdateTick >= 20) {
            this.lastUpdateTick = this.ticksExisted;
            boolean prevSky = this.doesSeeSky;
            boolean newSky = MiscUtils.canSeeSky(this.func_145831_w(), this.func_174877_v().func_177984_a(), true, this.seesSkyInNoSkyWorlds(), this.doesSeeSky);
            if (prevSky != newSky) {
                this.notifySkyStateUpdate(prevSky, newSky);
                this.doesSeeSky = newSky;
                this.markForUpdate();
            }
        }
        return this.doesSeeSky;
    }

    public boolean hasMultiblock() {
        boolean found;
        boolean prevFound;
        if (this.func_145831_w().func_201670_d()) {
            return this.hasMultiblock;
        }
        if (this.getRequiredStructureType() == null) {
            this.refreshMatcher();
            this.resetMultiblockState();
            return false;
        }
        this.refreshMatcher();
        if (this.structureMatch == null) {
            this.structureMatch = this.getRequiredStructureType().observe(this.func_145831_w(), this.func_174877_v());
        }
        if ((prevFound = this.hasMultiblock) != (found = this.structureMatch.isValid(this.func_145831_w()))) {
            LogCategory.STRUCTURE_MATCH.info(() -> "Structure match updated: " + this.getClass().getName() + " at " + this.func_174877_v() + " (" + this.hasMultiblock + " -> " + found + ")");
            this.notifyMultiblockStateUpdate(prevFound, found);
            this.hasMultiblock = found;
            this.markForUpdate();
        }
        return this.hasMultiblock;
    }

    private void refreshMatcher() {
        StructureType struct = this.getRequiredStructureType();
        if (this.structureMatch != null) {
            ResourceLocation key = ((ChangeObserverStructure)this.structureMatch.getObserver()).getProviderRegistryName();
            if (struct == null || !key.equals((Object)struct.getRegistryName())) {
                ObserverHelper.getHelper().removeObserver(this.func_145831_w(), this.func_174877_v());
                this.structureMatch = null;
            }
        }
        if (struct == null && ObserverHelper.getHelper().getSubscriber(this.func_145831_w(), this.func_174877_v()) != null) {
            ObserverHelper.getHelper().removeObserver(this.func_145831_w(), this.func_174877_v());
        }
    }

    private void resetMultiblockState() {
        if (this.hasMultiblock) {
            this.notifyMultiblockStateUpdate(true, false);
            this.hasMultiblock = false;
            this.markForUpdate();
        }
    }

    protected void notifySkyStateUpdate(boolean doesSeeSkyPrev, boolean doesSeeSkyNow) {
    }

    protected void notifyMultiblockStateUpdate(boolean hadMultiblockPrev, boolean hasMultiblockNow) {
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.ticksExisted = compound.func_74762_e("ticksExisted");
        this.doesSeeSky = compound.func_74767_n("doesSeeSky");
        this.hasMultiblock = compound.func_74767_n("hasMultiblock");
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("ticksExisted", this.ticksExisted);
        compound.func_74757_a("doesSeeSky", this.doesSeeSky);
        compound.func_74757_a("hasMultiblock", this.hasMultiblock);
    }
}

