/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block.iterator;

import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;

public abstract class BlockPositionGenerator {
    private BiPredicate<BlockPos, Double> posFilter = (pos, radius) -> true;

    public final BlockPositionGenerator andFilter(Predicate<BlockPos> filter) {
        return this.andFilter((BlockPos pos, Double radius) -> filter.test((BlockPos)pos));
    }

    public final BlockPositionGenerator andFilter(BiPredicate<BlockPos, Double> filter) {
        this.posFilter = this.posFilter.and(filter);
        return this;
    }

    public final BlockPositionGenerator copyFilterFrom(BlockPositionGenerator other) {
        other.andFilter(this.posFilter);
        return this;
    }

    public final BlockPos generateNextPosition(Vector3 offset, double selectionRadius) {
        BlockPos next;
        while (!this.posFilter.test(next = this.genNext(offset, selectionRadius), selectionRadius)) {
        }
        return next;
    }

    protected abstract BlockPos genNext(Vector3 var1, double var2);

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);
}

