/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.time;

import hellfirepvp.astralsorcery.common.data.sync.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.sync.client.ClientTimeFreezeEntities;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEffects;
import hellfirepvp.astralsorcery.common.data.sync.server.DataTimeFreezeEntities;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import hellfirepvp.astralsorcery.common.util.time.TimeStopZone;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;

public class TimeStopController
implements ITickHandler {
    private static final Map<RegistryKey<World>, List<TimeStopZone>> activeTimeStopZones = new HashMap<RegistryKey<World>, List<TimeStopZone>>();
    public static final TimeStopController INSTANCE = new TimeStopController();

    private TimeStopController() {
    }

    @Nullable
    public static TimeStopZone tryGetZoneAt(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return null;
        }
        List zones = activeTimeStopZones.getOrDefault(world.func_234923_W_(), Collections.emptyList());
        for (TimeStopZone zone : zones) {
            if (!zone.offset.equals((Object)pos)) continue;
            return zone;
        }
        return null;
    }

    @Nonnull
    public static TimeStopZone freezeWorldAt(@Nonnull TimeStopZone.EntityTargetController controller, @Nonnull World world, @Nonnull BlockPos offset, float range, int maxAge) {
        TimeStopZone stopZone = new TimeStopZone(controller, range, offset, world, maxAge);
        List zones = activeTimeStopZones.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), id -> new LinkedList());
        zones.add(stopZone);
        SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.addNewEffect((RegistryKey<World>)world.func_234923_W_(), TimeStopEffectHelper.fromZone(stopZone)));
        return stopZone;
    }

    public static void onWorldUnload(World world) {
        if (world.func_201670_d()) {
            return;
        }
        RegistryKey dimKey = world.func_234923_W_();
        for (TimeStopZone stop : activeTimeStopZones.getOrDefault(dimKey, Collections.emptyList())) {
            stop.stopEffect();
        }
        activeTimeStopZones.remove(dimKey);
    }

    public static boolean isFrozenDirectly(Entity e) {
        if (e.func_130014_f_().func_201670_d()) {
            return SyncDataHolder.computeClient(SyncDataHolder.DATA_TIME_FREEZE_ENTITIES, ClientTimeFreezeEntities.class, data -> data.isFrozen(e)).orElse(false);
        }
        return SyncDataHolder.computeServer(SyncDataHolder.DATA_TIME_FREEZE_ENTITIES, DataTimeFreezeEntities.class, data -> data.isFrozen(e)).orElse(false);
    }

    public static boolean skipLivingTick(LivingEntity e) {
        List<TimeStopZone> freezeAreas;
        if (TimeStopController.isFrozenDirectly((Entity)e)) {
            boolean shouldFreeze = true;
            if (!e.func_70089_S() || e.func_110143_aJ() <= 0.0f) {
                shouldFreeze = false;
            }
            if (e instanceof EnderDragonEntity && ((EnderDragonEntity)e).func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188750_j) {
                shouldFreeze = false;
            }
            if (shouldFreeze) {
                if (e.field_70170_p.func_201670_d()) {
                    int amt = (int)MathHelper.func_76129_c((float)(e.func_213311_cf() * e.func_213302_cg()));
                    for (int i = 0; i < amt; ++i) {
                        if (e.field_70170_p.field_73012_v.nextInt(5) != 0) continue;
                        TimeStopEffectHelper.playEntityParticles(e);
                    }
                }
                if (!e.func_130014_f_().func_201670_d()) {
                    TimeStopZone.handleImportantEntityTicks(e);
                    return true;
                }
            }
        }
        if ((freezeAreas = activeTimeStopZones.get(e.func_130014_f_().func_234923_W_())) != null && !freezeAreas.isEmpty()) {
            for (TimeStopZone stop : freezeAreas) {
                if (!stop.interceptEntityTick(e) || e.func_130014_f_().func_201670_d()) continue;
                TimeStopZone.handleImportantEntityTicks(e);
                return true;
            }
        }
        return false;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        for (Map.Entry<RegistryKey<World>, List<TimeStopZone>> zoneMap : activeTimeStopZones.entrySet()) {
            Iterator<TimeStopZone> iterator = zoneMap.getValue().iterator();
            while (iterator.hasNext()) {
                TimeStopZone zone = iterator.next();
                if (zone.shouldDespawn()) {
                    zone.stopEffect();
                    SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.removeEffect((RegistryKey<World>)((RegistryKey)zoneMap.getKey()), TimeStopEffectHelper.fromZone(zone)));
                    iterator.remove();
                    continue;
                }
                zone.onServerTick();
                if (!zone.shouldDespawn()) continue;
                zone.stopEffect();
                SyncDataHolder.executeServer(SyncDataHolder.DATA_TIME_FREEZE_EFFECTS, DataTimeFreezeEffects.class, data -> data.removeEffect((RegistryKey<World>)((RegistryKey)zoneMap.getKey()), TimeStopEffectHelper.fromZone(zone)));
                iterator.remove();
            }
        }
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase.equals((Object)TickEvent.Phase.START);
    }

    public String getName() {
        return "TimeStop Controller";
    }
}

