/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.world.placement.config.WorldFilterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;

public class FeatureGenerationConfig
extends ConfigEntry {
    private List<Biome.Category> categories = new ArrayList<Biome.Category>();
    private List<RegistryKey<World>> worlds = new ArrayList<RegistryKey<World>>();
    private boolean defaultEveryBiome = false;
    private boolean defaultEveryWorld = false;
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.BooleanValue everyBiome;
    private ForgeConfigSpec.BooleanValue everyWorld;
    private ForgeConfigSpec.ConfigValue<List<String>> biomeCategoryNames;
    private ForgeConfigSpec.ConfigValue<List<String>> worldNames;

    public FeatureGenerationConfig(ResourceLocation featureName) {
        this(featureName.func_110623_a());
    }

    public FeatureGenerationConfig(String featureName) {
        super(featureName);
    }

    public <T extends FeatureGenerationConfig> T generatesInBiomes(List<Biome.Category> biomeCategories) {
        this.categories = biomeCategories;
        return (T)this;
    }

    public <T extends FeatureGenerationConfig> T generatesInWorlds(List<RegistryKey<World>> worlds) {
        this.worlds = worlds;
        return (T)this;
    }

    public <T extends FeatureGenerationConfig> T setGenerateEveryBiome() {
        this.defaultEveryBiome = true;
        return (T)this;
    }

    public <T extends FeatureGenerationConfig> T setGenerateEveryWorld() {
        this.defaultEveryWorld = true;
        return (T)this;
    }

    @Override
    public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
        this.enabled = cfgBuilder.comment("Set this to false to disable this worldgen feature.").translation(this.translationKey("enabled")).define("enabled", true);
        this.everyBiome = cfgBuilder.comment("Set this to true to let this feature generate in any biome.").translation(this.translationKey("everyBiome")).define("everyBiome", this.defaultEveryBiome);
        this.everyWorld = cfgBuilder.comment("Set this to true to let this feature generate in any world. (Does NOT work for structures!)").translation(this.translationKey("everyWorld")).define("everyWorld", this.defaultEveryWorld);
        String allCategories = Arrays.stream(Biome.Category.values()).map(Biome.Category::func_176610_l).collect(Collectors.joining(","));
        List defaultCategories = this.categories.stream().map(Biome.Category::func_176610_l).collect(Collectors.toList());
        this.biomeCategoryNames = cfgBuilder.comment("Sets the categories to generate this feature in. Available categories: " + allCategories).translation(this.translationKey("biomeCategoryNames")).define("biomeCategoryNames", defaultCategories);
        List defaultWorlds = this.worlds.stream().map(RegistryKey::func_240901_a_).map(ResourceLocation::func_110623_a).collect(Collectors.toList());
        this.worldNames = cfgBuilder.comment("Sets the worlds to generate this feature in. (Does NOT work for structures!)").translation(this.translationKey("worldNames")).define("worldNames", defaultWorlds);
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean canGenerateIn(Biome.Category category) {
        if (((Boolean)this.everyBiome.get()).booleanValue()) {
            return true;
        }
        return ((List)this.biomeCategoryNames.get()).contains(category.func_176610_l());
    }

    public WorldFilterConfig worldFilterConfig() {
        return new WorldFilterConfig(() -> ((ForgeConfigSpec.BooleanValue)this.everyWorld).get(), () -> ((List)this.worldNames.get()).stream().map(ResourceLocation::new).map(key -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)key)).collect(Collectors.toList()));
    }
}

