/*
 * Decompiled with CFR 0.152.
 */
package com.inforno.backstab;

import com.inforno.backstab.config.Config;
import com.inforno.backstab.config.ConfigHelper;
import com.inforno.backstab.events.Events;
import com.inforno.backstab.gui.ConfigGui;
import com.inforno.backstab.items.BackstabItems;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="backstab")
public class BackStab {
    public static final String MODID = "backstab";
    public static final Logger LOGGER = LogManager.getLogger((String)"backstab");

    public BackStab() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHelper.CONFIG_SPEC);
        BackstabItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    static void onCommonSetup(FMLClientSetupEvent event) {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfigGui());
    }

    public static boolean isValidItem(Item item) {
        return Config.backstabItemsAll ? true : BackStab.containsNoCase(Config.items, item.getRegistryName().toString());
    }

    public static boolean isValidEntity(LivingEntity entity) {
        return entity instanceof PlayerEntity ? Config.backstabPlayers : !BackStab.containsNoCase(Config.entities, entity.func_70022_Q());
    }

    private static boolean containsNoCase(List<String> list, String s) {
        for (int i = 0; i < list.toArray().length; ++i) {
            if (!s.equalsIgnoreCase((String)list.toArray()[i])) continue;
            return true;
        }
        return false;
    }
}

