/*
 * Decompiled with CFR 0.152.
 */
package com.inforno.backstab.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String GENERAL = "general";
    public static ForgeConfigSpec.DoubleValue specMultiplier;
    public static ForgeConfigSpec.DoubleValue specDegrees;
    public static ForgeConfigSpec.BooleanValue specSneaking;
    public static final String ITEMS = "items";
    public static ForgeConfigSpec.ConfigValue<List<String>> specItems;
    public static ForgeConfigSpec.BooleanValue specItemsAll;
    public static final String ENTITIES = "entities";
    public static ForgeConfigSpec.ConfigValue<List<String>> specEntities;
    public static ForgeConfigSpec.BooleanValue specPlayers;
    public static final String SOUNDS = "sounds";
    public static ForgeConfigSpec.ConfigValue<String> specSound;
    public static ForgeConfigSpec.DoubleValue specPitch;
    public static ForgeConfigSpec.DoubleValue specVolume;
    public static String multiplierString;
    public static String degreeString;
    public static String sneakingString;
    public static String itemsString;
    public static String itemsAllString;
    public static String entitiesString;
    public static String playersString;
    public static String soundString;
    public static String pitchString;
    public static String volumeString;
    private static String[] defaultitems;
    private static String[] defaultentities;
    public static double backstabMultiplier;
    public static double backstabDegrees;
    public static boolean backstabSneaking;
    public static boolean backstabItemsAll;
    public static boolean backstabPlayers;
    public static String backstabSound;
    public static double backstabPitch;
    public static double backstabVolume;
    public static List<String> items;
    public static List<String> entities;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.push(GENERAL);
        specMultiplier = builder.comment(multiplierString).translation("backstab.config.multiplier").defineInRange("multiplier", 5.0, 0.0, 1000.0);
        specDegrees = builder.comment(degreeString).translation("backstab.config.degree").defineInRange("degree", 45.0, 0.0, 360.0);
        specSneaking = builder.comment(sneakingString).translation("backstab.config.sneaking").define("sneaking", false);
        builder.pop();
        builder.push(ITEMS);
        specItems = builder.comment(itemsString).translation("backstab.config.items").define(ITEMS, Arrays.asList(defaultitems));
        specItemsAll = builder.comment(itemsAllString).translation("backstab.config.itemsall").define("itemsall", false);
        builder.pop();
        builder.push(ENTITIES);
        specEntities = builder.comment(entitiesString).translation("backstab.config.entities_blacklist").define("entities_blacklist", Arrays.asList(defaultentities));
        specPlayers = builder.comment(playersString).translation("backstab.config.players").define("players", true);
        builder.pop();
        builder.push(SOUNDS);
        specSound = builder.comment(soundString).translation("backstab.config.sound").define("sound", (Object)"minecraft:entity.arrow.hit_player");
        specVolume = builder.comment(volumeString).translation("backstab.config.volume").defineInRange("volume", 0.75, 0.0, 100.0);
        specPitch = builder.comment(pitchString).translation("backstab.config.pitch").defineInRange("pitch", 0.4, 0.0, 2.0);
        builder.pop();
    }

    public static void bakeConfig() {
        backstabMultiplier = (Double)specMultiplier.get();
        backstabDegrees = (Double)specDegrees.get();
        backstabSneaking = (Boolean)specSneaking.get();
        backstabItemsAll = (Boolean)specItemsAll.get();
        backstabPlayers = (Boolean)specPlayers.get();
        backstabSound = (String)specSound.get();
        backstabPitch = (Double)specPitch.get();
        backstabVolume = (Double)specVolume.get();
        items = (List)specItems.get();
        entities = (List)specEntities.get();
    }

    static {
        multiplierString = "Changes the damage multiplier [Default: 5, Range: 0.0-1000.0]";
        degreeString = "Changes the degree needed to backstab [Default: 45, Range: 0.0-360.0]";
        sneakingString = "Requires sneaking to backstab? [Default: false]";
        itemsString = "What items CAN backstab? [Format: modid:itemid]";
        itemsAllString = "Overrides items, will enable everything (including fists) to backstab [Default: false]";
        entitiesString = "What mobs CANNOT be backstabbed? [Format: modid:entityid], [Default: minecraft:ender_dragon] due to messy interactions";
        playersString = "Can players be backstabbed by other players?";
        soundString = "Sound played when the player backstab [Format: Resource Location or /playsound (sound) format, Default: 'minecraft:entity.arrow.hit_player']";
        pitchString = "Changes the pitch of the backstab sound [Default: 0.4, Range: 0.0-100.0]";
        volumeString = "Changes the volume of the backstab sound [Default: 1.0, Range: 0.0-2.0]";
        defaultitems = new String[]{"backstab:wood_dagger", "backstab:stone_dagger", "backstab:iron_dagger", "backstab:gold_dagger", "backstab:diamond_dagger", "backstab:netherite_dagger"};
        defaultentities = new String[]{"minecraft:ender_dragon"};
    }
}

