/*
 * Decompiled with CFR 0.152.
 */
package com.inforno.backstab.events;

import com.inforno.backstab.BackStab;
import com.inforno.backstab.command.Command;
import com.inforno.backstab.config.Config;
import com.inforno.backstab.items.DaggerItem;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class Events {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (!player.field_70170_p.field_72995_K && BackStab.isValidItem(player.func_184614_ca().func_77973_b()) && BackStab.isValidEntity(event.getEntityLiving()) && (!Config.backstabSneaking || player.func_225608_bj_())) {
                double targetYaw = event.getEntityLiving().func_70079_am() % 360.0f;
                double attackerYaw = event.getSource().func_76346_g().func_70079_am() % 360.0f;
                if (attackerYaw < 0.0) {
                    attackerYaw += 360.0;
                }
                if (targetYaw < 0.0) {
                    targetYaw += 360.0;
                }
                if (Math.abs(targetYaw - attackerYaw) < Config.backstabDegrees || 360.0 - Math.abs(targetYaw - attackerYaw) < Config.backstabDegrees) {
                    event.setAmount((float)((double)event.getAmount() * Config.backstabMultiplier));
                    player.func_213823_a(Events.getRegisteredSoundEvent(Config.backstabSound), SoundCategory.PLAYERS, (float)Config.backstabVolume, (float)Config.backstabPitch);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        if (event.getPlayer().func_184614_ca().func_77973_b() instanceof DaggerItem && event.getPlayer().func_233570_aj_()) {
            event.getPlayer().func_230245_c_(false);
        }
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        Command.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private static SoundEvent getRegisteredSoundEvent(String id) {
        SoundEvent soundevent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(id));
        if (soundevent == null) {
            throw new IllegalStateException("Invalid Sound requested: " + id);
        }
        return soundevent;
    }
}

