/*
 * Decompiled with CFR 0.152.
 */
package eliteasian.mods.banneradditions;

import eliteasian.mods.banneradditions.banner.BannerCopyRecipe;
import eliteasian.mods.banneradditions.banner.NewBannerTileEntity;
import eliteasian.mods.banneradditions.banner.ShieldRecipe;
import eliteasian.mods.banneradditions.bannerpattern.NewBannerPatternItem;
import eliteasian.mods.banneradditions.loom.NewLoomContainer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class BannerAdditionsRegistry {

    public static class CraftingRecipes {
        public static final IRecipeSerializer<ShieldRecipe> SHIELD_RECIPE = CraftingRecipes.reg(new ShieldRecipe.Serializer(), "shield_recipe");
        public static final IRecipeSerializer<BannerCopyRecipe> BANNER_COPY_RECIPE = CraftingRecipes.reg(new BannerCopyRecipe.Serializer(), "banner_copy_recipe");

        private static <T extends ICraftingRecipe> IRecipeSerializer<T> reg(IRecipeSerializer<T> recipeSerializer, String name) {
            return (IRecipeSerializer)recipeSerializer.setRegistryName(new ResourceLocation("banneradditions", name));
        }

        public static void registerAllRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{SHIELD_RECIPE, BANNER_COPY_RECIPE});
        }
    }

    public static class Items {
        public static final Item SWORD_BANNER_PATTERN = Items.reg(new NewBannerPatternItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)), "sword_banner_pattern");
        public static final Item ANIMATED_BANNER_PATTERN = Items.reg(new NewBannerPatternItem(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f)), "animated_banner_pattern");

        private static Item reg(Item item, String name) {
            return (Item)item.setRegistryName(new ResourceLocation("banneradditions", name));
        }

        public static void registerAllItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{SWORD_BANNER_PATTERN, ANIMATED_BANNER_PATTERN});
        }
    }

    public static class Containers {
        public static final ContainerType<NewLoomContainer> LOOM = Containers.reg(NewLoomContainer::new, "loom");

        private static <T extends Container> ContainerType<T> reg(ContainerType.IFactory<T> factory, String name) {
            return (ContainerType)new ContainerType(factory).setRegistryName(new ResourceLocation("minecraft", name));
        }

        public static void registerAllContainers(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(LOOM);
        }
    }

    public static class TileEntities {
        public static final TileEntityType<NewBannerTileEntity> BANNER = TileEntities.reg(TileEntityType.Builder.func_223042_a(NewBannerTileEntity::new, (Block[])new Block[]{Blocks.field_196784_gT, Blocks.field_196786_gU, Blocks.field_196788_gV, Blocks.field_196790_gW, Blocks.field_196792_gX, Blocks.field_196794_gY, Blocks.field_196796_gZ, Blocks.field_196826_ha, Blocks.field_196827_hb, Blocks.field_196829_hc, Blocks.field_196831_hd, Blocks.field_196833_he, Blocks.field_196835_hf, Blocks.field_196837_hg, Blocks.field_196839_hh, Blocks.field_196841_hi, Blocks.field_196843_hj, Blocks.field_196845_hk, Blocks.field_196847_hl, Blocks.field_196849_hm, Blocks.field_196851_hn, Blocks.field_196853_ho, Blocks.field_196855_hp, Blocks.field_196857_hq, Blocks.field_196859_hr, Blocks.field_196861_hs, Blocks.field_196863_ht, Blocks.field_196865_hu, Blocks.field_196867_hv, Blocks.field_196869_hw, Blocks.field_196871_hx, Blocks.field_196873_hy}), "banner");

        private static <T extends TileEntity> TileEntityType<T> reg(TileEntityType.Builder<T> builder, String name) {
            return (TileEntityType)builder.func_206865_a(null).setRegistryName(new ResourceLocation("minecraft", name));
        }

        public static void registerAllTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(BANNER);
        }
    }
}

