/*
 * Decompiled with CFR 0.152.
 */
package eliteasian.mods.banneradditions.banner;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import eliteasian.mods.banneradditions.BannerAdditionsRegistry;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatternHolder;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatterns;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeTileEntity;

public class NewBannerTileEntity
extends TileEntity
implements INameable,
IForgeTileEntity {
    @Nullable
    private ITextComponent name;
    @Nullable
    private DyeColor baseColor = DyeColor.WHITE;
    @Nullable
    private ListNBT patterns;
    private boolean patternDataSet;
    @Nullable
    private List<Pair<BannerPatternHolder, DyeColor>> patternList;

    public NewBannerTileEntity() {
        super(BannerAdditionsRegistry.TileEntities.BANNER);
    }

    public NewBannerTileEntity(DyeColor p_i47731_1_) {
        this();
        this.baseColor = p_i47731_1_;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ListNBT getPatternsFromItemStack(ItemStack p_230139_0_) {
        ListNBT listnbt = null;
        CompoundNBT compoundnbt = p_230139_0_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_150297_b("Patterns", 9)) {
            listnbt = compoundnbt.func_150295_c("Patterns", 10).func_74737_b();
        }
        return listnbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void loadFromItemStack(ItemStack p_195534_1_, DyeColor p_195534_2_) {
        this.patterns = NewBannerTileEntity.getPatternsFromItemStack(p_195534_1_);
        this.baseColor = p_195534_2_;
        this.patternList = null;
        this.patternDataSet = true;
        this.name = p_195534_1_.func_82837_s() ? p_195534_1_.func_200301_q() : null;
    }

    public ITextComponent func_200200_C_() {
        return this.name != null ? this.name : new TranslationTextComponent("block.minecraft.banner");
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.name;
    }

    public void func_213136_a(ITextComponent p_213136_1_) {
        this.name = p_213136_1_;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.patterns != null) {
            compound.func_218657_a("Patterns", (INBT)this.patterns);
        }
        if (this.name != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compound;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        if (p_230337_2_.func_150297_b("CustomName", 8)) {
            this.name = ITextComponent.Serializer.func_240643_a_((String)p_230337_2_.func_74779_i("CustomName"));
        }
        this.baseColor = this.func_145830_o() ? ((AbstractBannerBlock)this.func_195044_w().func_177230_c()).func_196285_M_() : null;
        this.patterns = p_230337_2_.func_150295_c("Patterns", 10);
        this.patternList = null;
        this.patternDataSet = true;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 6, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(this.getTileEntity().func_195044_w(), pkt.func_148857_g());
    }

    public static int getPatterns(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        return compoundnbt != null && compoundnbt.func_74764_b("Patterns") ? compoundnbt.func_150295_c("Patterns", 10).size() : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<BannerPatternHolder, DyeColor>> getPatternList() {
        if (this.patternList == null && this.patternDataSet) {
            this.patternList = NewBannerTileEntity.createPatternList(this.getBaseColor(() -> ((NewBannerTileEntity)this).func_195044_w()), this.patterns);
        }
        return this.patternList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Pair<BannerPatternHolder, DyeColor>> createPatternList(DyeColor p_230138_0_, @Nullable ListNBT p_230138_1_) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)BannerPatterns.get(0), (Object)p_230138_0_));
        if (p_230138_1_ != null) {
            for (int i = 0; i < p_230138_1_.size(); ++i) {
                CompoundNBT compoundnbt = p_230138_1_.func_150305_b(i);
                BannerPatternHolder bannerpattern = BannerPatterns.get(compoundnbt.func_74779_i("Pattern"));
                if (bannerpattern == null) continue;
                int j = compoundnbt.func_74762_e("Color");
                list.add(Pair.of((Object)bannerpattern, (Object)DyeColor.func_196056_a((int)j)));
            }
        }
        return list;
    }

    public static void removeBannerData(ItemStack stack) {
        ListNBT listnbt;
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_150297_b("Patterns", 9) && !(listnbt = compoundnbt.func_150295_c("Patterns", 10)).isEmpty()) {
            listnbt.remove(listnbt.size() - 1);
            if (listnbt.isEmpty()) {
                stack.func_196083_e("BlockEntityTag");
            }
        }
    }

    public ItemStack getItem(BlockState p_190615_1_) {
        ItemStack itemstack = new ItemStack((IItemProvider)BannerBlock.func_196287_a((DyeColor)this.getBaseColor(() -> p_190615_1_)));
        if (this.patterns != null && !this.patterns.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)this.patterns.func_74737_b());
        }
        if (this.name != null) {
            itemstack.func_200302_a(this.name);
        }
        return itemstack;
    }

    public DyeColor getBaseColor(Supplier<BlockState> p_195533_1_) {
        if (this.baseColor == null) {
            this.baseColor = ((AbstractBannerBlock)p_195533_1_.get().func_177230_c()).func_196285_M_();
        }
        return this.baseColor;
    }
}

