/*
 * Decompiled with CFR 0.152.
 */
package eliteasian.mods.banneradditions.network;

import eliteasian.mods.banneradditions.bannerpattern.BannerPatternHolder;
import eliteasian.mods.banneradditions.bannerpattern.BannerPatterns;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class BannerPatternsMessage {
    private final List<BannerPatternHolder> bannerPatterns;

    public BannerPatternsMessage(List<BannerPatternHolder> bannerPatterns) {
        this.bannerPatterns = bannerPatterns;
    }

    public static void encode(BannerPatternsMessage message, PacketBuffer buffer) {
        buffer.writeShort(message.bannerPatterns.size());
        for (BannerPatternHolder bannerPattern : message.bannerPatterns) {
            buffer.func_192572_a(bannerPattern.getBannerTexture());
            buffer.func_192572_a(bannerPattern.getShieldTexture());
            buffer.func_180714_a(bannerPattern.getHashname());
            buffer.func_180714_a(bannerPattern.getFullName());
            buffer.func_192572_a(bannerPattern.getItem());
        }
    }

    public static BannerPatternsMessage decode(PacketBuffer buffer) {
        ArrayList<BannerPatternHolder> bannerPatterns = new ArrayList<BannerPatternHolder>();
        int size = buffer.readShort();
        for (int i = 0; i < size; ++i) {
            ResourceLocation bannerTexture = buffer.func_192575_l();
            ResourceLocation shieldTexture = buffer.func_192575_l();
            String hashname = buffer.func_218666_n();
            String fullName = buffer.func_218666_n();
            ResourceLocation item = buffer.func_192575_l();
            bannerPatterns.add(new BannerPatternHolder(bannerTexture, shieldTexture, hashname, fullName, item));
        }
        return new BannerPatternsMessage(bannerPatterns);
    }

    public static void handle(BannerPatternsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new UnsupportedOperationException("Banner Pattern packet side is wrong!");
        }
        context.enqueueWork(() -> {
            BannerPatterns.clear();
            for (BannerPatternHolder bannerPattern : message.bannerPatterns) {
                BannerPatterns.add(bannerPattern);
            }
        });
    }
}

