/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.integration.rei;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.TransferDisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import ru.betterend.blocks.basis.EndAnvilBlock;
import ru.betterend.integration.rei.REIAnvilDisplay;
import ru.betterend.integration.rei.REIPlugin;

public class REIAnvilCategory
implements TransferDisplayCategory<REIAnvilDisplay> {
    private final EntryStack<?>[] ANVILS;

    REIAnvilCategory(EntryStack<?>[] anvils) {
        this.ANVILS = anvils;
    }

    public CategoryIdentifier<REIAnvilDisplay> getCategoryIdentifier() {
        return REIPlugin.SMITHING;
    }

    @NotNull
    public class_2561 getTitle() {
        return new class_2588(class_2246.field_10535.method_9539());
    }

    @NotNull
    public EntryStack<?> getIcon() {
        return this.ANVILS[0];
    }

    @NotNull
    public List<Widget> setupDisplay(REIAnvilDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        int x = startPoint.x + 10;
        int y = startPoint.y;
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(x + 61, y + 5)));
        List inputEntries = display.getInputEntries();
        EntryIngredient materials = (EntryIngredient)inputEntries.get(1);
        int anvilLevel = display.getAnvilLevel();
        List anvils = Arrays.stream(this.ANVILS).filter(anvil -> {
            class_2248 block;
            Object value = anvil.getValue();
            if (value instanceof class_1799) {
                value = ((class_1799)value).method_7909();
            }
            if ((block = ((class_1747)value).method_7711()) instanceof EndAnvilBlock) {
                return ((EndAnvilBlock)block).getCraftingLevel() >= anvilLevel;
            }
            return anvilLevel == 1;
        }).collect(Collectors.toList());
        widgets.add(Widgets.createArrow((Point)new Point(x + 24, y + 4)));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 7, bounds.y + bounds.height - 15), (class_2561)new class_2588("category.rei.damage.amount&dmg", new Object[]{display.getDamage()})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createSlot((Point)new Point(x - 20, y + 4)).entries((Collection)materials).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 1, y + 4)).entries((Collection)inputEntries.get(0)).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 61, y + 5)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(x - 9, y + 25)).entries(anvils));
        return widgets;
    }

    public void renderRedSlots(class_4587 matrices, List<Widget> widgets, Rectangle bounds, REIAnvilDisplay display, IntList redSlots) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 27);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 400.0);
        if (redSlots.contains(0)) {
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x - 20), (int)(startPoint.y + 3), (int)(startPoint.x - 20 + 16), (int)(startPoint.y + 3 + 16), (int)0x40FF0000);
            class_332.method_25294((class_4587)matrices, (int)(startPoint.x + 1), (int)(startPoint.y + 3), (int)(startPoint.x + 1 + 16), (int)(startPoint.y + 3 + 16), (int)0x40FF0000);
        }
        matrices.method_22909();
    }

    public int getDisplayHeight() {
        return 60;
    }
}

