/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.impl.biome.InternalBiomeData;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import ru.bclib.BCLib;
import ru.bclib.api.BiomeAPI;
import ru.bclib.api.ModIntegrationAPI;
import ru.bclib.util.JsonFactory;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomeMap;
import ru.bclib.world.generator.BiomePicker;
import ru.betterend.config.Configs;
import ru.betterend.integration.EndBiomeIntegration;
import ru.betterend.interfaces.IBiomeList;
import ru.betterend.world.biome.EndBiome;
import ru.betterend.world.biome.air.BiomeIceStarfield;
import ru.betterend.world.biome.cave.EmptyAuroraCaveBiome;
import ru.betterend.world.biome.cave.EmptyEndCaveBiome;
import ru.betterend.world.biome.cave.EmptySmaragdantCaveBiome;
import ru.betterend.world.biome.cave.EndCaveBiome;
import ru.betterend.world.biome.cave.JadeCaveBiome;
import ru.betterend.world.biome.cave.LushAuroraCaveBiome;
import ru.betterend.world.biome.cave.LushSmaragdantCaveBiome;
import ru.betterend.world.biome.land.AmberLandBiome;
import ru.betterend.world.biome.land.BlossomingSpiresBiome;
import ru.betterend.world.biome.land.ChorusForestBiome;
import ru.betterend.world.biome.land.CrystalMountainsBiome;
import ru.betterend.world.biome.land.DragonGraveyardsBiome;
import ru.betterend.world.biome.land.DryShrublandBiome;
import ru.betterend.world.biome.land.DustWastelandsBiome;
import ru.betterend.world.biome.land.FoggyMushroomlandBiome;
import ru.betterend.world.biome.land.GlowingGrasslandsBiome;
import ru.betterend.world.biome.land.LanternWoodsBiome;
import ru.betterend.world.biome.land.MegalakeBiome;
import ru.betterend.world.biome.land.MegalakeGroveBiome;
import ru.betterend.world.biome.land.NeonOasisBiome;
import ru.betterend.world.biome.land.PaintedMountainsBiome;
import ru.betterend.world.biome.land.ShadowForestBiome;
import ru.betterend.world.biome.land.SulphurSpringsBiome;
import ru.betterend.world.biome.land.UmbraValleyBiome;
import ru.betterend.world.biome.land.UmbrellaJungleBiome;
import ru.betterend.world.generator.BiomeType;
import ru.betterend.world.generator.GeneratorOptions;

public class EndBiomes {
    public static final Set<class_2960> FABRIC_VOID = Sets.newHashSet();
    private static final Set<class_2960> SUBBIOMES_UNMUTABLES = Sets.newHashSet();
    public static final BiomePicker LAND_BIOMES = new BiomePicker();
    public static final BiomePicker VOID_BIOMES = new BiomePicker();
    public static final BiomePicker CAVE_BIOMES = new BiomePicker();
    public static final List<BCLBiome> SUBBIOMES = Lists.newArrayList();
    private static final JsonObject EMPTY_JSON = new JsonObject();
    private static BiomeMap caveBiomeMap;
    public static final EndBiome END;
    public static final EndBiome END_MIDLANDS;
    public static final EndBiome END_HIGHLANDS;
    public static final EndBiome END_BARRENS;
    public static final EndBiome SMALL_END_ISLANDS;
    public static final EndBiome FOGGY_MUSHROOMLAND;
    public static final EndBiome CHORUS_FOREST;
    public static final EndBiome DUST_WASTELANDS;
    public static final EndBiome MEGALAKE;
    public static final EndBiome MEGALAKE_GROVE;
    public static final EndBiome CRYSTAL_MOUNTAINS;
    public static final EndBiome PAINTED_MOUNTAINS;
    public static final EndBiome SHADOW_FOREST;
    public static final EndBiome AMBER_LAND;
    public static final EndBiome BLOSSOMING_SPIRES;
    public static final EndBiome SULPHUR_SPRINGS;
    public static final EndBiome UMBRELLA_JUNGLE;
    public static final EndBiome GLOWING_GRASSLANDS;
    public static final EndBiome DRAGON_GRAVEYARDS;
    public static final EndBiome DRY_SHRUBLAND;
    public static final EndBiome LANTERN_WOODS;
    public static final EndBiome NEON_OASIS;
    public static final EndBiome UMBRA_VALLEY;
    public static final EndBiome ICE_STARFIELD;
    public static final EndCaveBiome EMPTY_END_CAVE;
    public static final EndCaveBiome EMPTY_SMARAGDANT_CAVE;
    public static final EndCaveBiome LUSH_SMARAGDANT_CAVE;
    public static final EndCaveBiome EMPTY_AURORA_CAVE;
    public static final EndCaveBiome LUSH_AURORA_CAVE;
    public static final EndCaveBiome JADE_CAVE;

    public static void register() {
        CAVE_BIOMES.rebuild();
    }

    public static void onWorldLoad(long seed) {
        if (caveBiomeMap == null || caveBiomeMap.getSeed() != seed) {
            caveBiomeMap = new BiomeMap(seed, GeneratorOptions.getBiomeSizeCaves(), CAVE_BIOMES);
        }
    }

    public static void mutateRegistry(class_2378<class_1959> biomeRegistry) {
        LAND_BIOMES.clearMutables();
        VOID_BIOMES.clearMutables();
        CAVE_BIOMES.clearMutables();
        if (FABRIC_VOID.isEmpty()) {
            EndBiomes.loadFabricAPIBiomes();
        }
        HashMap configs = Maps.newHashMap();
        biomeRegistry.forEach(biome -> {
            class_2960 id;
            if (!(biome.method_8688() != class_1959.class_1961.field_9360 || (id = biomeRegistry.method_10221(biome)).method_12836().equals("ultra_amplified_dimension") || !Configs.BIOME_CONFIG.getBoolean(id, "enabled", true) || LAND_BIOMES.containsImmutable(id) || VOID_BIOMES.containsImmutable(id) || SUBBIOMES_UNMUTABLES.contains(id))) {
                JsonObject config = (JsonObject)configs.get(id.method_12836());
                if (config == null) {
                    config = EndBiomes.loadJsonConfig(id.method_12836());
                    configs.put(id.method_12836(), config);
                }
                float fog = 1.0f;
                float chance = 1.0f;
                boolean isVoid = FABRIC_VOID.contains(id);
                boolean hasCaves = true;
                JsonElement element = config.get(id.method_12832());
                if (element != null && element.isJsonObject()) {
                    fog = JsonFactory.getFloat((JsonObject)element.getAsJsonObject(), (String)"fog_density", (float)1.0f);
                    chance = JsonFactory.getFloat((JsonObject)element.getAsJsonObject(), (String)"generation_chance", (float)1.0f);
                    isVoid = JsonFactory.getString((JsonObject)element.getAsJsonObject(), (String)"type", (String)"land").equals("void");
                    hasCaves = JsonFactory.getBoolean((JsonObject)element.getAsJsonObject(), (String)"has_caves", (boolean)true);
                }
                EndBiome endBiome = new EndBiome(id, (class_1959)biome, fog, chance, hasCaves);
                if (isVoid) {
                    VOID_BIOMES.addBiomeMutable((BCLBiome)endBiome);
                } else {
                    LAND_BIOMES.addBiomeMutable((BCLBiome)endBiome);
                }
                BiomeAPI.registerBiome((BCLBiome)endBiome);
            }
        });
        ModIntegrationAPI.getIntegrations().forEach(integration -> {
            if (integration instanceof EndBiomeIntegration && integration.modIsInstalled()) {
                ((EndBiomeIntegration)integration).addBiomes();
            }
        });
        Configs.BIOME_CONFIG.saveChanges();
        EndBiomes.rebuildPicker(LAND_BIOMES, biomeRegistry);
        EndBiomes.rebuildPicker(VOID_BIOMES, biomeRegistry);
        EndBiomes.rebuildPicker(CAVE_BIOMES, biomeRegistry);
        SUBBIOMES.forEach(endBiome -> endBiome.updateActualBiomes(biomeRegistry));
    }

    private static void rebuildPicker(BiomePicker picker, class_2378<class_1959> biomeRegistry) {
        picker.rebuild();
        picker.getBiomes().forEach(endBiome -> endBiome.updateActualBiomes(biomeRegistry));
    }

    private static void loadFabricAPIBiomes() {
        ArrayList biomes = Lists.newArrayList();
        biomes.addAll(EndBiomes.getBiomes((WeightedBiomePicker)InternalBiomeData.getEndBiomesMap().get(class_1972.field_9457)));
        biomes.addAll(EndBiomes.getBiomes((WeightedBiomePicker)InternalBiomeData.getEndBarrensMap().get(class_1972.field_9465)));
        biomes.forEach(key -> FABRIC_VOID.add(key.method_29177()));
        FABRIC_VOID.removeIf(id -> id.method_12836().equals("endplus"));
        if (BCLib.isDevEnvironment()) {
            System.out.println("==================================");
            System.out.println("Added void biomes from Fabric API:");
            FABRIC_VOID.forEach(id -> System.out.println(id));
            System.out.println("==================================");
        }
    }

    private static List<class_5321<class_1959>> getBiomes(WeightedBiomePicker picker) {
        IBiomeList biomeList = (IBiomeList)picker;
        return biomeList == null ? Collections.emptyList() : biomeList.getBiomes();
    }

    private static JsonObject loadJsonConfig(String namespace) {
        InputStream inputstream = EndBiomes.class.getResourceAsStream("/data/" + namespace + "/end_biome_properties.json");
        if (inputstream != null) {
            return JsonFactory.getJsonObject((InputStream)inputstream);
        }
        return EMPTY_JSON;
    }

    public static EndBiome registerBiome(class_1959 biome, BiomeType type, float genChance) {
        return EndBiomes.registerBiome(biome, type, 1.0f, genChance);
    }

    public static EndBiome registerBiome(class_1959 biome, BiomeType type, float fogDensity, float genChance) {
        EndBiome endBiome = new EndBiome(class_5458.field_25933.method_10221((Object)biome), biome, fogDensity, genChance, true);
        BiomeAPI.registerBiome((BCLBiome)endBiome);
        if (Configs.BIOME_CONFIG.getBoolean(endBiome.getID(), "enabled", true)) {
            EndBiomes.addToPicker(endBiome, type);
        }
        return endBiome;
    }

    public static EndBiome registerSubBiome(class_1959 biome, EndBiome parent, float genChance, boolean hasCaves) {
        return EndBiomes.registerSubBiome(biome, parent, 1.0f, genChance, hasCaves);
    }

    public static EndBiome registerSubBiome(class_1959 biome, EndBiome parent, float fogDensity, float genChance, boolean hasCaves) {
        EndBiome endBiome = new EndBiome(class_5458.field_25933.method_10221((Object)biome), biome, fogDensity, genChance, hasCaves);
        BiomeAPI.registerBiome((BCLBiome)endBiome);
        if (Configs.BIOME_CONFIG.getBoolean(endBiome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)endBiome);
            parent.addSubBiome(endBiome);
            SUBBIOMES.add(endBiome);
            SUBBIOMES_UNMUTABLES.add(endBiome.getID());
        }
        return endBiome;
    }

    public static EndBiome registerSubBiome(EndBiome biome, EndBiome parent) {
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
            parent.addSubBiome(biome);
            SUBBIOMES.add(biome);
            SUBBIOMES_UNMUTABLES.add(biome.getID());
            BiomeAPI.addEndLandBiomeToFabricApi((BCLBiome)biome);
        }
        return biome;
    }

    public static EndBiome registerBiome(EndBiome biome, BiomeType type) {
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
            EndBiomes.addToPicker(biome, type);
            if (type == BiomeType.LAND) {
                BiomeAPI.addEndLandBiomeToFabricApi((BCLBiome)biome);
            } else {
                BiomeAPI.addEndVoidBiomeToFabricApi((BCLBiome)biome);
            }
        }
        return biome;
    }

    public static EndBiome registerSubBiomeIntegration(EndBiome biome) {
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
            SUBBIOMES.add(biome);
            SUBBIOMES_UNMUTABLES.add(biome.getID());
            BiomeAPI.addEndLandBiomeToFabricApi((BCLBiome)biome);
        }
        return biome;
    }

    public static void addSubBiomeIntegration(EndBiome biome, class_2960 parent) {
        BCLBiome parentBiome;
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true) && (parentBiome = BiomeAPI.getBiome((class_2960)parent)) != null && !parentBiome.containsSubBiome((BCLBiome)biome)) {
            parentBiome.addSubBiome((BCLBiome)biome);
        }
    }

    public static EndBiome registerBiome(class_5321<class_1959> key, BiomeType type, float genChance) {
        return EndBiomes.registerBiome((class_1959)class_5458.field_25933.method_29107(key), type, genChance);
    }

    public static EndBiome registerSubBiome(class_5321<class_1959> key, EndBiome parent, float genChance) {
        return EndBiomes.registerSubBiome((class_1959)class_5458.field_25933.method_29107(key), parent, genChance, true);
    }

    private static void addToPicker(EndBiome biome, BiomeType type) {
        if (type == BiomeType.LAND) {
            LAND_BIOMES.addBiome((BCLBiome)biome);
        } else {
            VOID_BIOMES.addBiome((BCLBiome)biome);
        }
    }

    public static EndCaveBiome registerCaveBiome(EndCaveBiome biome) {
        if (Configs.BIOME_CONFIG.getBoolean(biome.getID(), "enabled", true)) {
            BiomeAPI.registerBiome((BCLBiome)biome);
            CAVE_BIOMES.addBiome((BCLBiome)biome);
        }
        return biome;
    }

    public static EndCaveBiome getCaveBiome(int x, int z) {
        return (EndCaveBiome)caveBiomeMap.getBiome(x, z);
    }

    static {
        END = EndBiomes.registerBiome((class_5321<class_1959>)class_1972.field_9411, BiomeType.LAND, 1.0f);
        END_MIDLANDS = EndBiomes.registerSubBiome((class_5321<class_1959>)class_1972.field_9447, END, 0.5f);
        END_HIGHLANDS = EndBiomes.registerSubBiome((class_5321<class_1959>)class_1972.field_9442, END, 0.5f);
        END_BARRENS = EndBiomes.registerBiome((class_5321<class_1959>)class_1972.field_9465, BiomeType.VOID, 1.0f);
        SMALL_END_ISLANDS = EndBiomes.registerBiome((class_5321<class_1959>)class_1972.field_9457, BiomeType.VOID, 1.0f);
        FOGGY_MUSHROOMLAND = EndBiomes.registerBiome(new FoggyMushroomlandBiome(), BiomeType.LAND);
        CHORUS_FOREST = EndBiomes.registerBiome(new ChorusForestBiome(), BiomeType.LAND);
        DUST_WASTELANDS = EndBiomes.registerBiome(new DustWastelandsBiome(), BiomeType.LAND);
        MEGALAKE = EndBiomes.registerBiome(new MegalakeBiome(), BiomeType.LAND);
        MEGALAKE_GROVE = EndBiomes.registerSubBiome(new MegalakeGroveBiome(), MEGALAKE);
        CRYSTAL_MOUNTAINS = EndBiomes.registerBiome(new CrystalMountainsBiome(), BiomeType.LAND);
        PAINTED_MOUNTAINS = EndBiomes.registerSubBiome(new PaintedMountainsBiome(), DUST_WASTELANDS);
        SHADOW_FOREST = EndBiomes.registerBiome(new ShadowForestBiome(), BiomeType.LAND);
        AMBER_LAND = EndBiomes.registerBiome(new AmberLandBiome(), BiomeType.LAND);
        BLOSSOMING_SPIRES = EndBiomes.registerBiome(new BlossomingSpiresBiome(), BiomeType.LAND);
        SULPHUR_SPRINGS = EndBiomes.registerBiome(new SulphurSpringsBiome(), BiomeType.LAND);
        UMBRELLA_JUNGLE = EndBiomes.registerBiome(new UmbrellaJungleBiome(), BiomeType.LAND);
        GLOWING_GRASSLANDS = EndBiomes.registerBiome(new GlowingGrasslandsBiome(), BiomeType.LAND);
        DRAGON_GRAVEYARDS = EndBiomes.registerBiome(new DragonGraveyardsBiome(), BiomeType.LAND);
        DRY_SHRUBLAND = EndBiomes.registerBiome(new DryShrublandBiome(), BiomeType.LAND);
        LANTERN_WOODS = EndBiomes.registerBiome(new LanternWoodsBiome(), BiomeType.LAND);
        NEON_OASIS = EndBiomes.registerSubBiome(new NeonOasisBiome(), DUST_WASTELANDS);
        UMBRA_VALLEY = EndBiomes.registerBiome(new UmbraValleyBiome(), BiomeType.LAND);
        ICE_STARFIELD = EndBiomes.registerBiome(new BiomeIceStarfield(), BiomeType.VOID);
        EMPTY_END_CAVE = EndBiomes.registerCaveBiome(new EmptyEndCaveBiome());
        EMPTY_SMARAGDANT_CAVE = EndBiomes.registerCaveBiome(new EmptySmaragdantCaveBiome());
        LUSH_SMARAGDANT_CAVE = EndBiomes.registerCaveBiome(new LushSmaragdantCaveBiome());
        EMPTY_AURORA_CAVE = EndBiomes.registerCaveBiome(new EmptyAuroraCaveBiome());
        LUSH_AURORA_CAVE = EndBiomes.registerCaveBiome(new LushAuroraCaveBiome());
        JADE_CAVE = EndBiomes.registerCaveBiome(new JadeCaveBiome());
    }
}

