/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3111;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import ru.bclib.api.TagAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.world.features.DefaultFeature;
import ru.betterend.blocks.EndBlockProperties;
import ru.betterend.blocks.SulphurCrystalBlock;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndBlocks;
import ru.betterend.util.BlockFixer;

public class SulphuricCaveFeature
extends DefaultFeature {
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2350[] HORIZONTAL = BlocksHelper.makeHorizontal();

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        Random random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        int radius = MHelper.randRange((int)10, (int)30, (Random)random);
        int top = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
        class_2338.class_2339 bpos = new class_2338.class_2339();
        bpos.method_33097(pos.method_10263());
        bpos.method_33099(pos.method_10260());
        bpos.method_33098(top - 1);
        class_2680 state = world.method_8320((class_2338)bpos);
        while (!state.method_26164((class_3494)TagAPI.BLOCK_GEN_TERRAIN) && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        if (bpos.method_10264() < 10) {
            return false;
        }
        top = (int)((float)bpos.method_10264() - ((float)radius * 1.3f + 5.0f));
        while (state.method_26164((class_3494)TagAPI.BLOCK_GEN_TERRAIN) || !state.method_26227().method_15769() && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        int bottom = (int)((float)bpos.method_10264() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        class_2338.class_2339 mut = new class_2338.class_2339();
        pos = new class_2338(pos.method_10263(), MHelper.randRange((int)bottom, (int)top, (Random)random), pos.method_10260());
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)pos.method_10263(), (int)pos.method_10260()));
        int x1 = pos.method_10263() - radius - 5;
        int z1 = pos.method_10260() - radius - 5;
        int x2 = pos.method_10263() + radius + 5;
        int z2 = pos.method_10260() + radius + 5;
        int y1 = MHelper.floor((double)((double)pos.method_10264() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)pos.method_10264() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet brimstone = Sets.newHashSet();
        class_2680 rock = EndBlocks.SULPHURIC_ROCK.stone.method_9564();
        int waterLevel = pos.method_10264() + MHelper.randRange((int)MHelper.floor((double)((double)radius * 0.8)), (int)radius, (Random)random);
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.method_10263();
            xsq *= xsq;
            mut.method_33097(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.method_10260();
                zsq *= zsq;
                mut.method_33099(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - pos.method_10264();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    mut.method_33098(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.method_8320((class_2338)mut);
                        if (!this.isReplaceable(state)) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)(y < waterLevel ? WATER : CAVE_AIR));
                        continue;
                    }
                    if (!(dist < r2 * r2) || !(state = world.method_8320((class_2338)mut)).method_26164((class_3494)TagAPI.BLOCK_GEN_TERRAIN) && !state.method_27852(class_2246.field_10124)) continue;
                    double v = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) + noise.eval((double)x * 0.03, (double)y * 0.03, (double)z * 0.03) * 0.5;
                    if (v > 0.4) {
                        brimstone.add(mut.method_10062());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)rock);
                }
            }
        }
        brimstone.forEach(blockPos -> this.placeBrimstone(world, (class_2338)blockPos, random));
        if (random.nextInt(4) == 0) {
            int count = MHelper.randRange((int)5, (int)20, (Random)random);
            for (int i = 0; i < count; ++i) {
                mut.method_10101((class_2382)pos).method_10100(MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)), 0, MHelper.floor((double)(random.nextGaussian() * 2.0 + 0.5)));
                int dist = MHelper.floor((double)(3.0f - MHelper.length((float)(mut.method_10263() - pos.method_10263()), (float)(mut.method_10260() - pos.method_10260())))) + random.nextInt(2);
                if (dist <= 0) continue;
                state = world.method_8320((class_2338)mut);
                while (!state.method_26227().method_15769() || state.method_26207().equals(class_3614.field_15947)) {
                    mut.method_33098(mut.method_10264() - 1);
                    state = world.method_8320((class_2338)mut);
                }
                if (!state.method_26164((class_3494)TagAPI.BLOCK_GEN_TERRAIN) || world.method_8320(mut.method_10084()).method_27852(EndBlocks.HYDROTHERMAL_VENT)) continue;
                for (int j = 0; j <= dist; ++j) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2248)EndBlocks.SULPHURIC_ROCK.stone);
                    MHelper.shuffle((Object[])HORIZONTAL, (Random)random);
                    for (class_2350 dir : HORIZONTAL) {
                        class_2338 p = mut.method_10093(dir);
                        if (!random.nextBoolean() || !world.method_8320(p).method_27852(class_2246.field_10382)) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)p, (class_2680)((class_2680)EndBlocks.TUBE_WORM.method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)dir)));
                    }
                    mut.method_33098(mut.method_10264() + 1);
                }
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2248)EndBlocks.HYDROTHERMAL_VENT);
                mut.method_33098(mut.method_10264() + 1);
                state = world.method_8320((class_2338)mut);
                while (state.method_27852(class_2246.field_10382)) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)EndBlocks.VENT_BUBBLE_COLUMN.method_9564());
                    world.method_8397().method_8676((class_2338)mut, (Object)EndBlocks.VENT_BUBBLE_COLUMN, MHelper.randRange((int)8, (int)32, (Random)random));
                    mut.method_33098(mut.method_10264() + 1);
                    state = world.method_8320((class_2338)mut);
                }
            }
        }
        BlockFixer.fixBlocks((class_1936)world, new class_2338(x1, y1, z1), new class_2338(x2, y2, z2));
        return true;
    }

    private boolean isReplaceable(class_2680 state) {
        return state.method_26164((class_3494)TagAPI.BLOCK_GEN_TERRAIN) || state.method_27852(EndBlocks.HYDROTHERMAL_VENT) || state.method_27852(EndBlocks.VENT_BUBBLE_COLUMN) || state.method_27852(EndBlocks.SULPHUR_CRYSTAL) || state.method_26207().method_15800() || state.method_26207().equals(class_3614.field_15935) || state.method_26207().equals(class_3614.field_15947) || state.method_26207().equals(class_3614.field_15923);
    }

    private void placeBrimstone(class_5281 world, class_2338 pos, Random random) {
        class_2680 state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)state);
        if (((Boolean)state.method_11654((class_2769)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private class_2680 getBrimstone(class_5281 world, class_2338 pos) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (!world.method_8320(pos.method_10093(dir)).method_27852(class_2246.field_10382)) continue;
            return (class_2680)EndBlocks.BRIMSTONE.method_9564().method_11657((class_2769)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.method_9564();
    }

    private void makeShards(class_5281 world, class_2338 pos, Random random) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            class_2338 side;
            if (random.nextInt(16) != 0 || !world.method_8320(side = pos.method_10093(dir)).method_27852(class_2246.field_10382)) continue;
            class_2680 state = (class_2680)((class_2680)((class_2680)EndBlocks.SULPHUR_CRYSTAL.method_9564().method_11657((class_2769)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)SulphurCrystalBlock.FACING, (Comparable)dir)).method_11657((class_2769)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(3)));
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)side, (class_2680)state);
        }
    }
}

