/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.features.trees;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5821;
import ru.bclib.api.TagAPI;
import ru.bclib.sdf.PosInfo;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFRotation;
import ru.bclib.sdf.operator.SDFScale;
import ru.bclib.sdf.operator.SDFSmoothUnion;
import ru.bclib.sdf.operator.SDFTranslate;
import ru.bclib.sdf.operator.SDFUnary;
import ru.bclib.sdf.operator.SDFUnion;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.util.SplineHelper;
import ru.bclib.world.features.DefaultFeature;
import ru.betterend.blocks.HelixTreeLeavesBlock;
import ru.betterend.registry.EndBlocks;

public class HelixTreeFeature
extends DefaultFeature {
    private static final Function<PosInfo, class_2680> POST = info -> {
        if (EndBlocks.HELIX_TREE.isTreeLog(info.getStateUp()) && EndBlocks.HELIX_TREE.isTreeLog(info.getStateDown())) {
            return EndBlocks.HELIX_TREE.getLog().method_9564();
        }
        return info.getState();
    };

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        float dz;
        float dx;
        Random random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (!world.method_8320(pos.method_10074()).method_26164((class_3494)TagAPI.BLOCK_END_GROUND)) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)AIR);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        float radiusRange = MHelper.randRange((float)4.5f, (float)6.0f, (Random)random);
        float scale = MHelper.randRange((float)0.5f, (float)1.0f, (Random)random);
        ArrayList<class_1160> spline = new ArrayList<class_1160>(10);
        for (int i = 0; i < 10; ++i) {
            float radius = (0.9f - (float)i * 0.1f) * radiusRange;
            dx = (float)Math.sin((float)i + angle) * radius;
            dz = (float)Math.cos((float)i + angle) * radius;
            spline.add(new class_1160(dx, (float)(i * 2), dz));
        }
        SDF sdf = SplineHelper.buildSDF(spline, (float)1.7f, (float)0.5f, p -> EndBlocks.HELIX_TREE.getBark().method_9564());
        SDFUnary rotated = new SDFRotation().setRotation(class_1160.field_20705, (float)Math.PI).setSource(sdf);
        sdf = new SDFUnion().setSourceA((SDF)rotated).setSourceB(sdf);
        class_1160 lastPoint = (class_1160)spline.get(spline.size() - 1);
        List spline2 = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)20.0f, (float)0.0f, (int)5);
        SDF stem = SplineHelper.buildSDF((List)spline2, (float)1.0f, (float)0.5f, p -> EndBlocks.HELIX_TREE.getBark().method_9564());
        stem = new SDFTranslate().setTranslate(lastPoint.method_4943(), lastPoint.method_4945(), lastPoint.method_4947()).setSource(stem);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(stem);
        sdf = new SDFScale().setScale(scale).setSource(sdf);
        dx = 30.0f * scale;
        float dy1 = -20.0f * scale;
        float dy2 = 100.0f * scale;
        sdf.addPostProcess(POST).fillArea((class_5425)world, pos, new class_238(pos.method_10080((double)(-dx), (double)dy1, (double)(-dx)), pos.method_10080((double)dx, (double)dy2, (double)dx)));
        SplineHelper.scale(spline, (float)scale);
        SplineHelper.fillSplineForce(spline, (class_5281)world, (class_2680)EndBlocks.HELIX_TREE.getBark().method_9564(), (class_2338)pos, state -> state.method_26207().method_15800());
        SplineHelper.rotateSpline(spline, (float)((float)Math.PI));
        SplineHelper.fillSplineForce(spline, (class_5281)world, (class_2680)EndBlocks.HELIX_TREE.getBark().method_9564(), (class_2338)pos, state -> state.method_26207().method_15800());
        SplineHelper.scale((List)spline2, (float)scale);
        class_2338 leafStart = pos.method_10080((double)lastPoint.method_4943() + 0.5, (double)lastPoint.method_4945() + 0.5, (double)lastPoint.method_4947() + 0.5);
        SplineHelper.fillSplineForce((List)spline2, (class_5281)world, (class_2680)EndBlocks.HELIX_TREE.getLog().method_9564(), (class_2338)leafStart, state -> state.method_26207().method_15800());
        spline.clear();
        float rad = MHelper.randRange((float)8.0f, (float)11.0f, (Random)random);
        int count = MHelper.randRange((int)20, (int)30, (Random)random);
        float scaleM = 20.0f / (float)count * scale * 1.75f;
        float hscale = 20.0f / (float)count * 0.05f;
        for (int i = 0; i <= count; ++i) {
            float radius = 1.0f - (float)i * hscale;
            radius = radius * radius * 2.0f - 1.0f;
            radius *= radius;
            radius = (1.0f - radius) * rad * scale;
            dx = (float)Math.sin((float)i * 0.45f + angle) * radius;
            dz = (float)Math.cos((float)i * 0.45f + angle) * radius;
            spline.add(new class_1160(dx, (float)i * scaleM, dz));
        }
        class_1160 start = new class_1160();
        class_1160 end = new class_1160();
        lastPoint = (class_1160)spline.get(0);
        class_2680 leaf = EndBlocks.HELIX_TREE_LEAVES.method_9564();
        for (int i = 1; i < spline.size(); ++i) {
            class_1160 point = (class_1160)spline.get(i);
            int minY = MHelper.floor((double)lastPoint.method_4945());
            int maxY = MHelper.floor((double)point.method_4945());
            float div = point.method_4945() - lastPoint.method_4945();
            for (float py = (float)minY; py <= (float)maxY; py += 0.2f) {
                start.method_4949(0.0f, py, 0.0f);
                float delta = (py - (float)minY) / div;
                float px = class_3532.method_16439((float)delta, (float)lastPoint.method_4943(), (float)point.method_4943());
                float pz = class_3532.method_16439((float)delta, (float)lastPoint.method_4947(), (float)point.method_4947());
                end.method_4949(px, py, pz);
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
                float ax = Math.abs(px);
                float az = Math.abs(pz);
                if (ax > az) {
                    start.method_4949(start.method_4943(), start.method_4945(), start.method_4947() + az > 0.0f ? 1.0f : -1.0f);
                    end.method_4949(end.method_4943(), end.method_4945(), end.method_4947() + az > 0.0f ? 1.0f : -1.0f);
                } else {
                    start.method_4949(start.method_4943() + ax > 0.0f ? 1.0f : -1.0f, start.method_4945(), start.method_4947());
                    end.method_4949(end.method_4943() + ax > 0.0f ? 1.0f : -1.0f, end.method_4945(), end.method_4947());
                }
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
            }
            lastPoint = point;
        }
        leaf = (class_2680)leaf.method_11657((class_2769)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7));
        if (world.method_8320(leafStart = leafStart.method_10080(0.0, (double)lastPoint.method_4945(), 0.0)).method_26215()) {
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)leafStart, (class_2680)leaf);
            leafStart = leafStart.method_10084();
            if (world.method_8320(leafStart).method_26215()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)leafStart, (class_2680)leaf);
                leafStart = leafStart.method_10084();
                if (world.method_8320(leafStart).method_26215()) {
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)leafStart, (class_2680)leaf);
                }
            }
        }
        return true;
    }

    private void fillLine(class_1160 start, class_1160 end, class_5281 world, class_2680 state, class_2338 pos, int offset) {
        float dx = end.method_4943() - start.method_4943();
        float dy = end.method_4945() - start.method_4945();
        float dz = end.method_4947() - start.method_4947();
        float max = MHelper.max((float)Math.abs(dx), (float)Math.abs(dy), (float)Math.abs(dz));
        int count = MHelper.floor((double)(max + 1.0f));
        dx /= max;
        dy /= max;
        dz /= max;
        float x = start.method_4943();
        float y = start.method_4945();
        float z = start.method_4947();
        class_2338.class_2339 bPos = new class_2338.class_2339();
        for (int i = 0; i < count; ++i) {
            bPos.method_10102((double)(x + (float)pos.method_10263()), (double)(y + (float)pos.method_10264()), (double)(z + (float)pos.method_10260()));
            int color = MHelper.floor((double)((float)i / (float)count * 7.0f + 0.5f)) + offset;
            color = class_3532.method_15340((int)color, (int)0, (int)7);
            if (world.method_8320((class_2338)bPos).method_26207().method_15800()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, (class_2680)((class_2680)state.method_11657((class_2769)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(color))));
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.method_10102((double)(end.method_4943() + (float)pos.method_10263()), (double)(end.method_4945() + (float)pos.method_10264()), (double)(end.method_4947() + (float)pos.method_10260()));
        if (world.method_8320((class_2338)bPos).method_26207().method_15800()) {
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)bPos, (class_2680)((class_2680)state.method_11657((class_2769)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7))));
        }
    }
}

