/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.generator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2338;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFBinary;
import ru.bclib.sdf.operator.SDFRadialNoiseMap;
import ru.bclib.sdf.operator.SDFScale;
import ru.bclib.sdf.operator.SDFSmoothUnion;
import ru.bclib.sdf.operator.SDFTranslate;
import ru.bclib.sdf.primitive.SDFCappedCone;
import ru.bclib.util.MHelper;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.world.generator.GeneratorOptions;
import ru.betterend.world.generator.LayerOptions;

public class IslandLayer {
    private static final Random RANDOM = new Random();
    private final SDFRadialNoiseMap noise;
    private final SDF island;
    private final List<class_2338> positions = new ArrayList<class_2338>(9);
    private final Map<class_2338, SDF> islands = Maps.newHashMap();
    private final OpenSimplexNoise density;
    private final int seed;
    private int lastX = Integer.MIN_VALUE;
    private int lastZ = Integer.MIN_VALUE;
    private final LayerOptions options;

    public IslandLayer(int seed, LayerOptions options) {
        this.density = new OpenSimplexNoise(seed);
        this.options = options;
        this.seed = seed;
        SDF cone1 = IslandLayer.makeCone(0.0f, 0.4f, 0.2f, -0.3f);
        SDF cone2 = IslandLayer.makeCone(0.4f, 0.5f, 0.1f, -0.1f);
        SDF cone3 = IslandLayer.makeCone(0.5f, 0.45f, 0.03f, 0.0f);
        SDF cone4 = IslandLayer.makeCone(0.45f, 0.0f, 0.02f, 0.03f);
        SDFBinary coneBottom = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone1).setSourceB(cone2);
        SDFBinary coneTop = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone3).setSourceB(cone4);
        this.noise = (SDFRadialNoiseMap)new SDFRadialNoiseMap().setSeed((long)seed).setRadius(0.5f).setIntensity(0.2f).setSource((SDF)coneTop);
        this.island = new SDFSmoothUnion().setRadius(0.01f).setSourceA((SDF)this.noise).setSourceB((SDF)coneBottom);
    }

    private int getSeed(int x, int z) {
        int h = this.seed + x * 374761393 + z * 668265263;
        h = (h ^ h >> 13) * 1274126177;
        return h ^ h >> 16;
    }

    public void updatePositions(double x, double z) {
        int ix = MHelper.floor((double)(x / (double)this.options.distance));
        int iz = MHelper.floor((double)(z / (double)this.options.distance));
        if (this.lastX != ix || this.lastZ != iz) {
            this.lastX = ix;
            this.lastZ = iz;
            this.positions.clear();
            for (int pox = -1; pox < 2; ++pox) {
                int px = pox + ix;
                long px2 = px;
                for (int poz = -1; poz < 2; ++poz) {
                    int pz = poz + iz;
                    long pz2 = pz;
                    if (!GeneratorOptions.noRingVoid() && px2 * px2 + pz2 * pz2 <= this.options.centerDist) continue;
                    RANDOM.setSeed(this.getSeed(px, pz));
                    double posX = ((float)px + RANDOM.nextFloat()) * this.options.distance;
                    double posY = MHelper.randRange((int)this.options.minY, (int)this.options.maxY, (Random)RANDOM);
                    double posZ = ((float)pz + RANDOM.nextFloat()) * this.options.distance;
                    if (!(this.density.eval(posX * 0.01, posZ * 0.01) > (double)this.options.coverage)) continue;
                    this.positions.add(new class_2338(posX, posY, posZ));
                }
            }
        }
        if (GeneratorOptions.hasCentralIsland() && Math.abs(ix) < GeneratorOptions.getIslandDistChunk() && Math.abs(iz) < GeneratorOptions.getIslandDistChunk()) {
            int count = this.positions.size();
            for (int n = 0; n < count; ++n) {
                class_2338 pos = this.positions.get(n);
                long d = (long)pos.method_10263() * (long)pos.method_10263() + (long)pos.method_10260() * (long)pos.method_10260();
                if (d >= GeneratorOptions.getIslandDistBlock()) continue;
                this.positions.remove(n);
                --count;
                --n;
            }
            if (this.options.hasCentralIsland) {
                this.positions.add(new class_2338(0, 64, 0));
            }
        }
    }

    private SDF getIsland(class_2338 pos) {
        SDF island = this.islands.get(pos);
        if (island == null) {
            if (pos.method_10263() == 0 && pos.method_10260() == 0) {
                island = new SDFScale().setScale(1.3f).setSource(this.island);
            } else {
                RANDOM.setSeed(this.getSeed(pos.method_10263(), pos.method_10260()));
                island = new SDFScale().setScale(RANDOM.nextFloat() + 0.5f).setSource(this.island);
            }
            this.islands.put(pos, island);
        }
        this.noise.setOffset(pos.method_10263(), pos.method_10260());
        return island;
    }

    private float getRelativeDistance(SDF sdf, class_2338 center, double px, double py, double pz) {
        float x = (float)(px - (double)center.method_10263()) / this.options.scale;
        float y = (float)(py - (double)center.method_10264()) / this.options.scale;
        float z = (float)(pz - (double)center.method_10260()) / this.options.scale;
        return sdf.getDistance(x, y, z);
    }

    private float calculateSDF(double x, double y, double z) {
        float distance = 10.0f;
        for (class_2338 pos : this.positions) {
            SDF island = this.getIsland(pos);
            float dist = this.getRelativeDistance(island, pos, x, y, z);
            distance = MHelper.min((float)distance, (float)dist);
        }
        return distance;
    }

    public float getDensity(double x, double y, double z) {
        return -this.calculateSDF(x, y, z);
    }

    public float getDensity(double x, double y, double z, float height) {
        this.noise.setIntensity(height);
        this.noise.setRadius(0.5f / (1.0f + height));
        return -this.calculateSDF(x, y, z);
    }

    public void clearCache() {
        if (this.islands.size() > 128) {
            this.islands.clear();
        }
    }

    private static SDF makeCone(float radiusBottom, float radiusTop, float height, float minY) {
        float hh = height * 0.5f;
        SDFCappedCone sdf = new SDFCappedCone().setHeight(hh).setRadius1(radiusBottom).setRadius2(radiusTop);
        return new SDFTranslate().setTranslate(0.0f, minY + hh, 0.0f).setSource((SDF)sdf);
    }
}

