/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_3532;
import ru.bclib.util.MHelper;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.world.generator.BetterEndBiomeSource;
import ru.betterend.world.generator.GeneratorOptions;
import ru.betterend.world.generator.IslandLayer;
import ru.betterend.world.generator.TerrainBoolCache;

public class TerrainGenerator {
    private static final Map<Point, TerrainBoolCache> TERRAIN_BOOL_CACHE_MAP = Maps.newHashMap();
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final Point POS = new Point();
    private static final double SCALE_XZ = 8.0;
    private static final double SCALE_Y = 4.0;
    private static final float[] COEF;
    private static final Point[] OFFS;
    private static IslandLayer largeIslands;
    private static IslandLayer mediumIslands;
    private static IslandLayer smallIslands;
    private static OpenSimplexNoise noise1;
    private static OpenSimplexNoise noise2;

    public static void initNoise(long seed) {
        Random random = new Random(seed);
        largeIslands = new IslandLayer(random.nextInt(), GeneratorOptions.bigOptions);
        mediumIslands = new IslandLayer(random.nextInt(), GeneratorOptions.mediumOptions);
        smallIslands = new IslandLayer(random.nextInt(), GeneratorOptions.smallOptions);
        noise1 = new OpenSimplexNoise(random.nextInt());
        noise2 = new OpenSimplexNoise(random.nextInt());
        TERRAIN_BOOL_CACHE_MAP.clear();
    }

    public static void fillTerrainDensity(double[] buffer, int x, int z, class_1966 biomeSource) {
        LOCKER.lock();
        largeIslands.clearCache();
        mediumIslands.clearCache();
        smallIslands.clearCache();
        double distortion1 = noise1.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise2.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise1.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double distortion2 = noise2.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise1.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise2.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double px = (double)x * 8.0 + distortion1;
        double pz = (double)z * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        float height = TerrainGenerator.getAverageDepth(biomeSource, x << 1, z << 1) * 0.5f;
        for (int y = 0; y < buffer.length; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz, height);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz, height));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz, height));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            buffer[y] = dist;
        }
        LOCKER.unlock();
    }

    private static float getAverageDepth(class_1966 biomeSource, int x, int z) {
        if (TerrainGenerator.getBiome(biomeSource, x, z).method_8695() < 0.1f) {
            return 0.0f;
        }
        float depth = 0.0f;
        for (int i = 0; i < OFFS.length; ++i) {
            int px = x + TerrainGenerator.OFFS[i].x;
            int pz = z + TerrainGenerator.OFFS[i].y;
            depth += TerrainGenerator.getBiome(biomeSource, px, pz).method_8695() * COEF[i];
        }
        return depth;
    }

    private static class_1959 getBiome(class_1966 biomeSource, int x, int z) {
        if (biomeSource instanceof BetterEndBiomeSource) {
            return ((BetterEndBiomeSource)biomeSource).getLandBiome(x, 0, z);
        }
        return biomeSource.method_16359(x, 0, z);
    }

    public static boolean isLand(int x, int z) {
        byte value;
        int sectionX = TerrainBoolCache.scaleCoordinate(x);
        int sectionZ = TerrainBoolCache.scaleCoordinate(z);
        LOCKER.lock();
        POS.setLocation(sectionX, sectionZ);
        TerrainBoolCache section = TERRAIN_BOOL_CACHE_MAP.get(POS);
        if (section == null) {
            if (TERRAIN_BOOL_CACHE_MAP.size() > 64) {
                TERRAIN_BOOL_CACHE_MAP.clear();
            }
            section = new TerrainBoolCache();
            TERRAIN_BOOL_CACHE_MAP.put(new Point(TerrainGenerator.POS.x, TerrainGenerator.POS.y), section);
        }
        if ((value = section.getData(x, z)) > 0) {
            LOCKER.unlock();
            return value > 1;
        }
        double px = (double)(x >> 1) + 0.5;
        double pz = (double)(z >> 1) + 0.5;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = px * 8.0 + distortion1;
        pz = pz * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        boolean result = false;
        for (int y = 0; y < 32; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (!((double)dist > -0.01)) continue;
            result = true;
            break;
        }
        section.setData(x, z, (byte)(result ? 2 : 1));
        LOCKER.unlock();
        return result;
    }

    public static int getHeight(int x, int z) {
        LOCKER.lock();
        double px = (double)x / 8.0;
        double pz = (double)z / 8.0;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = (double)x * 8.0 + distortion1;
        pz = (double)z * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        for (int y = 32; y >= 0; --y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (!(dist > 0.0f)) continue;
            LOCKER.unlock();
            return class_3532.method_15357((double)((double)class_3532.method_15363((float)((float)y + dist), (float)y, (float)(y + 1)) * 4.0));
        }
        LOCKER.unlock();
        return 0;
    }

    static {
        float sum = 0.0f;
        ArrayList coef = Lists.newArrayList();
        ArrayList pos = Lists.newArrayList();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                float dist = MHelper.length((float)x, (float)z) / 3.0f;
                if (!(dist <= 1.0f)) continue;
                sum += dist;
                coef.add(Float.valueOf(dist));
                pos.add(new Point(x, z));
            }
        }
        OFFS = pos.toArray(new Point[0]);
        COEF = new float[coef.size()];
        for (int i = 0; i < COEF.length; ++i) {
            TerrainGenerator.COEF[i] = ((Float)coef.get(i)).floatValue() / sum;
        }
    }
}

