/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.blocks.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2609;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3000;
import net.minecraft.class_3532;
import net.minecraft.class_3859;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import ru.betterend.blocks.EndStoneSmelter;
import ru.betterend.client.gui.EndStoneSmelterScreenHandler;
import ru.betterend.recipe.builders.AlloyingRecipe;
import ru.betterend.registry.EndBlockEntities;

public class EndStoneSmelterBlockEntity
extends class_2624
implements class_1278,
class_1732,
class_1737,
class_3000 {
    private static final int[] TOP_SLOTS = new int[]{0, 1};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 3};
    private static final int[] SIDE_SLOTS = new int[]{1, 2};
    private static final Map<class_1792, Integer> AVAILABLE_FUELS = Maps.newHashMap();
    private final Object2IntOpenHashMap<class_2960> recipesUsed;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    private class_1860<?> lastRecipe;
    private int smeltTimeTotal;
    private int smeltTime;
    private int burnTime;
    private int fuelTime;

    public EndStoneSmelterBlockEntity() {
        super(EndBlockEntities.END_STONE_SMELTER);
        this.recipesUsed = new Object2IntOpenHashMap();
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    case 0: {
                        return EndStoneSmelterBlockEntity.this.burnTime;
                    }
                    case 1: {
                        return EndStoneSmelterBlockEntity.this.fuelTime;
                    }
                    case 2: {
                        return EndStoneSmelterBlockEntity.this.smeltTime;
                    }
                    case 3: {
                        return EndStoneSmelterBlockEntity.this.smeltTimeTotal;
                    }
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        EndStoneSmelterBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        EndStoneSmelterBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        EndStoneSmelterBlockEntity.this.smeltTime = value;
                        break;
                    }
                    case 3: {
                        EndStoneSmelterBlockEntity.this.smeltTimeTotal = value;
                    }
                }
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator iterator = this.inventory.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)iterator.next()).method_7960());
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 itemStack = (class_1799)this.inventory.get(slot);
        boolean stackValid = !stack.method_7960() && stack.method_7962(itemStack) && class_1799.method_7975((class_1799)stack, (class_1799)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!(slot != 0 && slot != 1 || stackValid)) {
            this.smeltTimeTotal = this.getSmeltTime();
            this.smeltTime = 0;
            this.method_5431();
        }
    }

    protected int getSmeltTime() {
        if (this.field_11863 == null) {
            return 200;
        }
        int smeltTime = this.field_11863.method_8433().method_8132(AlloyingRecipe.TYPE, (class_1263)this, this.field_11863).map(AlloyingRecipe::getSmeltTime).orElse(0);
        if (smeltTime == 0) {
            smeltTime = this.field_11863.method_8433().method_8132(class_3956.field_17547, (class_1263)this, this.field_11863).map(class_1874::method_8167).orElse(200);
            smeltTime = (int)((double)smeltTime / 1.5);
        }
        return smeltTime;
    }

    public void dropExperience(class_1657 player) {
        if (this.field_11863 == null) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.field_11863.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                if (recipe instanceof AlloyingRecipe) {
                    AlloyingRecipe alloying = (AlloyingRecipe)recipe;
                    this.dropExperience(player.field_6002, player.method_19538(), entry.getIntValue(), alloying.getExperience());
                } else {
                    class_3859 blasting = (class_3859)recipe;
                    this.dropExperience(player.field_6002, player.method_19538(), entry.getIntValue(), blasting.method_8171());
                }
            });
        }
        player.method_7254((Collection)list);
        this.recipesUsed.clear();
    }

    private void dropExperience(class_1937 world, class_243 vec3d, int count, float amount) {
        int expTotal = class_3532.method_15375((float)((float)count * amount));
        float g = class_3532.method_22450((float)((float)count * amount));
        if (g != 0.0f && Math.random() < (double)g) {
            ++expTotal;
        }
        while (expTotal > 0) {
            int expVal = class_1303.method_5918((int)expTotal);
            expTotal -= expVal;
            world.method_8649((class_1297)new class_1303(world, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, expVal));
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    protected class_2561 method_17823() {
        return new class_2588(String.format("block.%s.%s", "betterend", "end_stone_smelter"));
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new EndStoneSmelterScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public void method_16896() {
        if (this.field_11863 == null) {
            return;
        }
        boolean initialBurning = this.isBurning();
        if (initialBurning) {
            --this.burnTime;
        }
        boolean burning = initialBurning;
        if (!this.field_11863.field_9236) {
            class_1799 fuel = (class_1799)this.inventory.get(2);
            if (!burning && (fuel.method_7960() || ((class_1799)this.inventory.get(0)).method_7960() && ((class_1799)this.inventory.get(1)).method_7960())) {
                if (this.smeltTime > 0) {
                    this.smeltTime = class_3532.method_15340((int)(this.smeltTime - 2), (int)0, (int)this.smeltTimeTotal);
                }
            } else {
                class_1860 recipe = this.field_11863.method_8433().method_8132(AlloyingRecipe.TYPE, (class_1263)this, this.field_11863).orElse(null);
                if (recipe == null) {
                    recipe = this.field_11863.method_8433().method_8132(class_3956.field_17547, (class_1263)this, this.field_11863).orElse(null);
                }
                boolean accepted = this.canAcceptRecipeOutput(recipe);
                if (!burning && accepted) {
                    this.fuelTime = this.burnTime = this.getFuelTime(fuel);
                    burning = this.isBurning();
                    if (burning) {
                        if (!fuel.method_7960()) {
                            class_1792 item = fuel.method_7909();
                            fuel.method_7934(1);
                            if (fuel.method_7960()) {
                                class_1792 remainFuel = item.method_7858();
                                this.inventory.set(2, (Object)(remainFuel == null ? class_1799.field_8037 : new class_1799((class_1935)remainFuel)));
                            }
                        }
                        this.method_5431();
                    }
                }
                if (burning && accepted) {
                    ++this.smeltTime;
                    if (this.smeltTime == this.smeltTimeTotal) {
                        this.smeltTime = 0;
                        this.smeltTimeTotal = this.getSmeltTime();
                        this.craftRecipe(recipe);
                        this.method_5431();
                    }
                } else {
                    this.smeltTime = 0;
                }
            }
            if (initialBurning != burning) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)EndStoneSmelter.LIT, (Comparable)Boolean.valueOf(burning)), 3);
                this.method_5431();
            }
        }
    }

    protected boolean canAcceptRecipeOutput(class_1860<?> recipe) {
        boolean validInput;
        if (recipe == null) {
            return false;
        }
        if (recipe instanceof AlloyingRecipe) {
            validInput = !((class_1799)this.inventory.get(0)).method_7960() && !((class_1799)this.inventory.get(1)).method_7960();
        } else {
            boolean bl = validInput = !((class_1799)this.inventory.get(0)).method_7960() || !((class_1799)this.inventory.get(1)).method_7960();
        }
        if (validInput) {
            class_1799 result = recipe.method_8110();
            if (result.method_7960()) {
                return false;
            }
            class_1799 output = (class_1799)this.inventory.get(3);
            int outCount = output.method_7947();
            int total = outCount + result.method_7947();
            if (output.method_7960()) {
                return true;
            }
            if (!output.method_7962(result)) {
                return false;
            }
            if (outCount < this.method_5444() && outCount < output.method_7914()) {
                return this.method_5444() >= total;
            }
            return output.method_7947() < result.method_7914();
        }
        return false;
    }

    private void craftRecipe(class_1860<?> recipe) {
        if (recipe == null || !this.canAcceptRecipeOutput(recipe)) {
            return;
        }
        class_1799 result = recipe.method_8110();
        class_1799 output = (class_1799)this.inventory.get(3);
        if (output.method_7960()) {
            this.inventory.set(3, (Object)result.method_7972());
        } else if (output.method_7909() == result.method_7909()) {
            output.method_7933(result.method_7947());
        }
        assert (this.field_11863 != null);
        if (!this.field_11863.field_9236) {
            this.method_7662(recipe);
        }
        if (recipe instanceof AlloyingRecipe) {
            ((class_1799)this.inventory.get(0)).method_7934(1);
            ((class_1799)this.inventory.get(1)).method_7934(1);
        } else if (!((class_1799)this.inventory.get(0)).method_7960()) {
            ((class_1799)this.inventory.get(0)).method_7934(1);
        } else {
            ((class_1799)this.inventory.get(1)).method_7934(1);
        }
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 itemStack : this.inventory) {
            finder.method_7400(itemStack);
        }
    }

    public void method_7662(class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 recipeId = recipe.method_8114();
            this.recipesUsed.addTo((Object)recipeId, 1);
            this.lastRecipe = recipe;
        }
    }

    public class_1860<?> method_7663() {
        return this.lastRecipe;
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        return side == class_2350.field_11036 ? TOP_SLOTS : SIDE_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (dir == class_2350.field_11033 && slot == 2) {
            return stack.method_7909() == class_1802.field_8550;
        }
        return true;
    }

    protected int getFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return AVAILABLE_FUELS.getOrDefault(item, EndStoneSmelterBlockEntity.getFabricFuel(fuel));
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.burnTime = tag.method_10568("BurnTime");
        this.fuelTime = tag.method_10568("FuelTime");
        this.smeltTime = tag.method_10568("SmeltTime");
        this.smeltTimeTotal = tag.method_10568("SmeltTimeTotal");
        class_2487 compoundTag = tag.method_10562("RecipesUsed");
        for (String id : compoundTag.method_10541()) {
            this.recipesUsed.put((Object)new class_2960(id), compoundTag.method_10550(id));
        }
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10575("BurnTime", (short)this.burnTime);
        tag.method_10575("FuelTime", (short)this.fuelTime);
        tag.method_10575("SmeltTime", (short)this.smeltTime);
        tag.method_10575("SmeltTimeTotal", (short)this.smeltTimeTotal);
        class_1262.method_5426((class_2487)tag, this.inventory);
        class_2487 usedRecipes = new class_2487();
        this.recipesUsed.forEach((identifier, integer) -> usedRecipes.method_10569(identifier.toString(), integer.intValue()));
        tag.method_10566("RecipesUsed", (class_2520)usedRecipes);
        return tag;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 3) {
            return false;
        }
        if (slot != 2) {
            return true;
        }
        class_1799 itemStack = (class_1799)this.inventory.get(2);
        return EndStoneSmelterBlockEntity.canUseAsFuel(stack) || stack.method_7909() == class_1802.field_8550 && itemStack.method_7909() != class_1802.field_8550;
    }

    public static boolean canUseAsFuel(class_1799 stack) {
        return AVAILABLE_FUELS.containsKey(stack.method_7909()) || EndStoneSmelterBlockEntity.getFabricFuel(stack) > 2000;
    }

    public static void registerFuel(class_1935 fuel, int time) {
        AVAILABLE_FUELS.put(fuel.method_8389(), time);
    }

    public static Map<class_1792, Integer> availableFuels() {
        return AVAILABLE_FUELS;
    }

    private static int getFabricFuel(class_1799 stack) {
        Integer ticks = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return ticks == null ? 0 : ticks;
    }

    static {
        class_2609.method_11196().forEach((item, time) -> {
            if (time >= 2000) {
                EndStoneSmelterBlockEntity.registerFuel((class_1935)item, time);
            }
        });
    }
}

