/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.widgets.Slot;
import me.shedaniel.rei.api.widgets.Tooltip;
import me.shedaniel.rei.api.widgets.Widgets;
import me.shedaniel.rei.gui.entries.RecipeEntry;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1074;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.betterend.integration.rei.REIAlloyingFuelDisplay;
import ru.betterend.integration.rei.REIPlugin;

public class REIAlloyingFuelCategory
implements RecipeCategory<REIAlloyingFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @NotNull
    public class_2960 getIdentifier() {
        return REIPlugin.ALLOYING_FUEL;
    }

    @NotNull
    public String getCategoryName() {
        return class_1074.method_4662((String)"category.rei.fuel", (Object[])new Object[0]);
    }

    public int getDisplayHeight() {
        return 49;
    }

    @NotNull
    public EntryStack getLogo() {
        return EntryStack.create((class_1935)class_1802.field_8713);
    }

    @NotNull
    public List<Widget> setupDisplay(REIAlloyingFuelDisplay recipeDisplay, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnTime = DECIMAL_FORMAT.format(recipeDisplay.getFuelTime());
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + 26, bounds.getMaxY() - 15), (class_2561)new class_2588("category.rei.fuel.time", new Object[]{burnTime})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire((Point)new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks((double)recipeDisplay.getFuelTime()));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + 6, startPoint.y + 18)).entries((Collection)recipeDisplay.getInputEntries().get(0)).markInput());
        return widgets;
    }

    @NotNull
    public RecipeEntry getSimpleRenderer(REIAlloyingFuelDisplay recipe) {
        final Slot slot = Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)recipe.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)recipe.getFuelTime() / 200.0);
        return new RecipeEntry(){
            private class_2588 text;
            {
                this.text = new class_2588("category.rei.fuel.time_short.items", new Object[]{burnItems});
            }

            public int getHeight() {
                return 22;
            }

            @Nullable
            public Tooltip getTooltip(Point point) {
                if (slot.containsMouse(point)) {
                    return slot.getCurrentTooltip(point);
                }
                return null;
            }

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.setZ(this.getZ() + 50);
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.method_25394(matrices, mouseX, mouseY, delta);
                class_310.method_1551().field_1772.method_27517(matrices, this.text.method_30937(), (float)(bounds.x + 25), (float)(bounds.y + 8), -1);
            }
        };
    }
}

