/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.recipe.builders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import ru.bclib.recipes.BCLRecipeManager;
import ru.betterend.BetterEnd;
import ru.betterend.config.Configs;
import ru.betterend.interfaces.BetterEndRecipe;
import ru.betterend.rituals.InfusionRitual;
import ru.betterend.util.ItemUtil;

public class InfusionRecipe
implements class_1860<InfusionRitual>,
BetterEndRecipe {
    public static final String GROUP = "infusion";
    public static final class_3956<InfusionRecipe> TYPE = BCLRecipeManager.registerType((String)"betterend", (String)"infusion");
    public static final Serializer SERIALIZER = (Serializer)BCLRecipeManager.registerSerializer((String)"betterend", (String)"infusion", (class_1865)new Serializer());
    public static final class_2960 ID = BetterEnd.makeID("infusion");
    private final class_2960 id;
    private final class_1856[] catalysts;
    private class_1856 input;
    private class_1799 output;
    private int time = 1;
    private String group;

    private InfusionRecipe(class_2960 id) {
        this(id, null, null);
    }

    private InfusionRecipe(class_2960 id, class_1856 input, class_1799 output) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.catalysts = new class_1856[8];
        Arrays.fill(this.catalysts, class_1856.field_9017);
    }

    public int getInfusionTime() {
        return this.time;
    }

    public boolean matches(InfusionRitual inv, class_1937 world) {
        boolean valid = this.input.method_8093(inv.method_5438(0));
        if (!valid) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            valid &= this.catalysts[i].method_8093(inv.method_5438(i + 1));
        }
        return valid;
    }

    public class_1799 assemble(InfusionRitual ritual) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)this.input);
        defaultedList.addAll(Arrays.asList(this.catalysts));
        return defaultedList;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public static class Serializer
    implements class_1865<InfusionRecipe> {
        public InfusionRecipe fromJson(class_2960 id, JsonObject json) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            recipe.input = class_1856.method_8102((JsonElement)json.get("input"));
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            recipe.output = ItemUtil.fromJsonRecipe(result);
            if (recipe.output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            recipe.group = class_3518.method_15253((JsonObject)json, (String)"group", (String)InfusionRecipe.GROUP);
            recipe.time = class_3518.method_15282((JsonObject)json, (String)"time", (int)1);
            JsonObject catalysts = class_3518.method_15296((JsonObject)json, (String)"catalysts");
            class_1799 catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"north", (String)""));
            ((InfusionRecipe)recipe).catalysts[0] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"north_east", (String)""));
            ((InfusionRecipe)recipe).catalysts[1] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"east", (String)""));
            ((InfusionRecipe)recipe).catalysts[2] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"south_east", (String)""));
            ((InfusionRecipe)recipe).catalysts[3] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"south", (String)""));
            ((InfusionRecipe)recipe).catalysts[4] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"south_west", (String)""));
            ((InfusionRecipe)recipe).catalysts[5] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"west", (String)""));
            ((InfusionRecipe)recipe).catalysts[6] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            catalyst = ItemUtil.fromStackString(class_3518.method_15253((JsonObject)catalysts, (String)"north_west", (String)""));
            ((InfusionRecipe)recipe).catalysts[7] = catalyst != null && !catalyst.method_7960() ? class_1856.method_8091((class_1935[])new class_1935[]{catalyst.method_7909()}) : class_1856.field_9017;
            return recipe;
        }

        public InfusionRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            InfusionRecipe recipe = new InfusionRecipe(id);
            recipe.input = class_1856.method_8086((class_2540)buffer);
            recipe.output = buffer.method_10819();
            recipe.group = buffer.method_19772();
            recipe.time = buffer.method_10816();
            for (int i = 0; i < 8; ++i) {
                ((InfusionRecipe)recipe).catalysts[i] = class_1856.method_8086((class_2540)buffer);
            }
            return recipe;
        }

        public void toNetwork(class_2540 buffer, InfusionRecipe recipe) {
            recipe.input.method_8088(buffer);
            buffer.method_10793(recipe.output);
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.time);
            for (int i = 0; i < 8; ++i) {
                recipe.catalysts[i].method_8088(buffer);
            }
        }
    }

    public static class Builder {
        private static final Builder INSTANCE = new Builder();
        private static boolean exist;
        private final class_1856[] catalysts = new class_1856[8];
        private class_2960 id;
        private class_1856 input;
        private class_1799 output;
        private String group;
        private int time = 1;

        public static Builder create(String id) {
            return Builder.create(BetterEnd.makeID(id));
        }

        public static Builder create(class_2960 id) {
            Builder.INSTANCE.id = id;
            Builder.INSTANCE.input = null;
            Builder.INSTANCE.output = null;
            Builder.INSTANCE.time = 1;
            exist = Configs.RECIPE_CONFIG.getBoolean(InfusionRecipe.GROUP, id.method_12832(), true);
            Arrays.fill(Builder.INSTANCE.catalysts, class_1856.field_9017);
            return INSTANCE;
        }

        private Builder() {
            Arrays.fill(this.catalysts, class_1856.field_9017);
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder setInput(class_1935 input) {
            this.input = class_1856.method_8091((class_1935[])new class_1935[]{input});
            return this;
        }

        public Builder setOutput(class_1935 output) {
            this.output = new class_1799(output);
            this.output.method_7939(1);
            return this;
        }

        public Builder setOutput(class_1799 output) {
            this.output = output;
            this.output.method_7939(1);
            return this;
        }

        public Builder setTime(int time) {
            this.time = time;
            return this;
        }

        public Builder addCatalyst(int slot, class_1935 ... items) {
            if (slot > 7) {
                return this;
            }
            this.catalysts[slot] = class_1856.method_8091((class_1935[])items);
            return this;
        }

        public void build() {
            if (exist) {
                if (this.input == null) {
                    BetterEnd.LOGGER.warning("Input for Infusion recipe can't be 'null', recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                if (this.output == null) {
                    BetterEnd.LOGGER.warning("Output for Infusion recipe can't be 'null', recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                InfusionRecipe recipe = new InfusionRecipe(this.id, this.input, this.output);
                recipe.group = this.group != null ? this.group : InfusionRecipe.GROUP;
                recipe.time = this.time;
                int empty = 0;
                for (int i = 0; i < this.catalysts.length; ++i) {
                    if (this.catalysts[i].method_8103()) {
                        ++empty;
                        continue;
                    }
                    ((InfusionRecipe)recipe).catalysts[i] = this.catalysts[i];
                }
                if (empty == this.catalysts.length) {
                    BetterEnd.LOGGER.warning("At least one catalyst must be non empty, recipe {} will be ignored!", new Object[]{this.id});
                    return;
                }
                BCLRecipeManager.addRecipe(TYPE, (class_1860)recipe);
            }
        }
    }
}

