/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.generator;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_5321;
import net.minecraft.class_5505;
import ru.bclib.api.BiomeAPI;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomeMap;
import ru.betterend.BetterEnd;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndBiomes;
import ru.betterend.registry.EndTags;
import ru.betterend.util.FeaturesHelper;
import ru.betterend.world.biome.EndBiome;
import ru.betterend.world.generator.GeneratorOptions;
import ru.betterend.world.generator.TerrainGenerator;

public class BetterEndBiomeSource
extends class_1966 {
    public static final Codec<BetterEndBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BetterEndBiomeSource::new)));
    private static final OpenSimplexNoise SMALL_NOISE = new OpenSimplexNoise(8324L);
    private final class_2378<class_1959> biomeRegistry;
    private final class_3541 noise;
    private final class_1959 centerBiome;
    private final class_1959 barrens;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private final long seed;

    public BetterEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(BetterEndBiomeSource.getBiomes(biomeRegistry));
        this.mapLand = new BiomeMap(seed, GeneratorOptions.getBiomeSizeLand(), EndBiomes.LAND_BIOMES);
        this.mapVoid = new BiomeMap(seed, GeneratorOptions.getBiomeSizeVoid(), EndBiomes.VOID_BIOMES);
        this.centerBiome = (class_1959)biomeRegistry.method_31140(class_1972.field_9411);
        this.barrens = (class_1959)biomeRegistry.method_31140(class_1972.field_9465);
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        class_2919 chunkRandom = new class_2919(seed);
        chunkRandom.method_12660(17292);
        this.noise = new class_3541((Random)chunkRandom);
        EndBiomes.mutateRegistry(biomeRegistry);
        EndTags.addTerrainTags(biomeRegistry);
        FeaturesHelper.addFeatures(biomeRegistry);
    }

    private static List<class_1959> getBiomes(class_2378<class_1959> biomeRegistry) {
        ArrayList list = Lists.newArrayList();
        biomeRegistry.forEach(biome -> {
            BCLBiome bclBiome = BiomeAPI.getBiome((class_2960)biomeRegistry.method_10221(biome));
            if (bclBiome instanceof EndBiome) {
                list.add(biome);
            }
        });
        return list;
    }

    public class_1959 method_16359(int biomeX, int biomeY, int biomeZ) {
        boolean hasVoid = !GeneratorOptions.useNewGenerator() || !GeneratorOptions.noRingVoid();
        long i = (long)biomeX * (long)biomeX;
        long j = (long)biomeZ * (long)biomeZ;
        long dist = i + j;
        if (hasVoid ? dist <= 65536L : dist <= 625L && (dist = (long)((double)dist + this.noise.method_15433((double)i * 0.2, (double)j * 0.2) * 10.0)) <= 625L) {
            return this.centerBiome;
        }
        if (biomeX == 0 && biomeZ == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
        }
        EndBiome endBiome = null;
        if (GeneratorOptions.useNewGenerator()) {
            if (TerrainGenerator.isLand(biomeX, biomeZ)) {
                endBiome = (EndBiome)this.mapLand.getBiome(biomeX << 2, biomeZ << 2);
            } else {
                if (!GeneratorOptions.noRingVoid() && dist <= 65536L) {
                    return this.barrens;
                }
                endBiome = this.mapVoid.getBiome(biomeX << 2, biomeZ << 2);
            }
        } else {
            float height = class_2169.method_8757((class_3541)this.noise, (int)((biomeX >> 1) + 1), (int)((biomeZ >> 1) + 1)) + (float)SMALL_NOISE.eval(biomeX, biomeZ) * 5.0f;
            if (height > -20.0f && height < -5.0f) {
                return this.barrens;
            }
            endBiome = height < -10.0f ? this.mapVoid.getBiome(biomeX << 2, biomeZ << 2) : this.mapLand.getBiome(biomeX << 2, biomeZ << 2);
        }
        return BiomeAPI.getActualBiome((BCLBiome)endBiome);
    }

    public class_1959 getLandBiome(int biomeX, int biomeY, int biomeZ) {
        boolean hasVoid = !GeneratorOptions.useNewGenerator() || !GeneratorOptions.noRingVoid();
        long i = (long)biomeX * (long)biomeX;
        long j = (long)biomeZ * (long)biomeZ;
        long dist = i + j;
        if (hasVoid ? dist <= 65536L : dist <= 625L && (dist = (long)((double)dist + this.noise.method_15433((double)i * 0.2, (double)j * 0.2) * 10.0)) <= 625L) {
            return this.centerBiome;
        }
        return BiomeAPI.getActualBiome((BCLBiome)this.mapLand.getBiome(biomeX << 2, biomeZ << 2));
    }

    public class_1966 method_27985(long seed) {
        return new BetterEndBiomeSource(this.biomeRegistry, seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BetterEnd.makeID("better_end_biome_source"), CODEC);
    }
}

