/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn;

import de.maxhenkel.better_respawn.Config;
import de.maxhenkel.better_respawn.Main;
import de.maxhenkel.better_respawn.capabilities.RespawnPosition;
import de.maxhenkel.better_respawn.capabilities.SpawnPointCapabilityProvider;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RespawnEvents {
    private static final int FIND_SPAWN_ATTEMPTS = 16;
    private static final ResourceLocation RESPAWN_CAPABILITY_ID = new ResourceLocation("better_respawn", "respawn_location");
    private Random random = new Random();

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        BlockPos respawnPos;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (!player.field_70170_p.field_73011_w.func_76567_e()) {
            return;
        }
        BlockPos bedLocation = player.getBedLocation(player.field_71093_bK);
        if (bedLocation != null) {
            Optional vec3d = PlayerEntity.func_213822_a((IWorldReader)player.field_70170_p, (BlockPos)bedLocation, (boolean)false);
            if (vec3d.isPresent()) {
                Vec3d spawn = (Vec3d)vec3d.get();
                if (player.func_180425_c().func_218139_n(new Vec3i(spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c)) <= (Integer)Config.SERVER.BED_RANGE.get()) {
                    Main.LOGGER.debug("Player {} is within the range of its bed", (Object)player.func_200200_C_().func_150261_e());
                    return;
                }
            }
        }
        if ((respawnPos = this.findValidRespawnLocation(player.field_70170_p, player.func_180425_c())) == null) {
            return;
        }
        player.setSpawnPoint(respawnPos, true, player.field_71093_bK);
        Main.LOGGER.debug("Set temporary respawn location to [{}, {}, {}]", (Object)respawnPos.func_177958_n(), (Object)respawnPos.func_177956_o(), (Object)respawnPos.func_177952_p());
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        RespawnPosition respawnPosition = (RespawnPosition)player.getCapability(Main.RESPAWN_CAPABILITY).orElse(null);
        DimensionType type = player.field_71093_bK;
        if (respawnPosition == null) {
            player.setSpawnPoint(null, false, type);
            Main.LOGGER.error("Player {} has no respawn location capability", (Object)player.func_200200_C_().func_150261_e());
            return;
        }
        BlockPos respawn = respawnPosition.getPos(type);
        player.setSpawnPoint(respawn, false, type);
        if (respawn == null) {
            Main.LOGGER.debug("Setting the players respawn position back to world spawn");
        } else {
            Main.LOGGER.debug("Setting the players respawn position back to [{}, {}, {}]", (Object)respawn.func_177958_n(), (Object)respawn.func_177956_o(), (Object)respawn.func_177952_p());
        }
    }

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent event) {
        if (event.isForced()) {
            return;
        }
        BlockPos newSpawn = event.getNewSpawn();
        if (newSpawn != null) {
            event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> respawnPosition.setPos(event.getPlayer().field_71093_bK, newSpawn));
            Main.LOGGER.debug("Updating the respawn location of player {} to [{}, {}, {}]", (Object)event.getPlayer().func_200200_C_().func_150261_e(), (Object)newSpawn.func_177958_n(), (Object)newSpawn.func_177956_o(), (Object)newSpawn.func_177952_p());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        event.getOriginal().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition1 -> {
            respawnPosition1.copyFrom((RespawnPosition)respawnPosition);
            Main.LOGGER.debug("Copying respawn location capability of player {}", (Object)event.getPlayer().func_200200_C_().func_150261_e());
        }));
    }

    @SubscribeEvent
    public void onPlayerCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer) && !((Entity)event.getObject()).getCapability(Main.RESPAWN_CAPABILITY).isPresent()) {
            event.addCapability(RESPAWN_CAPABILITY_ID, (ICapabilityProvider)new SpawnPointCapabilityProvider());
            Main.LOGGER.debug("Attaching respawn capability to player");
        }
    }

    @Nullable
    public BlockPos findValidRespawnLocation(World world, BlockPos deathLocation) {
        int min = (Integer)Config.SERVER.MIN_RESPAWN_DISTANCE.get();
        int max = (Integer)Config.SERVER.MAX_RESPAWN_DISTANCE.get();
        BlockPos pos = null;
        for (int i = 0; i < 16 && pos == null; ++i) {
            Main.LOGGER.debug("Searching for respawn location - Attempt {}/{}", (Object)(i + 1), (Object)16);
            pos = world.field_73011_w.func_206921_a(this.getRandomRange(deathLocation.func_177958_n(), min, max), this.getRandomRange(deathLocation.func_177952_p(), min, max), true);
        }
        if (pos == null) {
            Main.LOGGER.debug("Found no valid respawn location after {} attempts", (Object)16);
        } else {
            Main.LOGGER.debug("Found valid respawn location: [{}, {}, {}]", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        return pos;
    }

    private int getRandomRange(int actual, int minDistance, int maxDistance) {
        return actual + (this.random.nextBoolean() ? -1 : 1) * (minDistance + this.random.nextInt(maxDistance - minDistance));
    }
}

