/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn.capabilities;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;

public class RespawnPosition {
    private Map<ResourceLocation, BlockPos> posmap = new HashMap<ResourceLocation, BlockPos>();

    public void copyFrom(RespawnPosition respawnPosition) {
        this.posmap = respawnPosition.posmap;
    }

    public BlockPos getPos(DimensionType dimension) {
        return this.posmap.get(dimension.getRegistryName());
    }

    public void setPos(DimensionType dimension, BlockPos pos) {
        this.posmap.put(dimension.getRegistryName(), pos);
    }

    public CompoundNBT toNBT() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT spawnList = new ListNBT();
        this.posmap.forEach((dim, pos) -> {
            if (pos != null) {
                CompoundNBT data = new CompoundNBT();
                data.func_74778_a("Dim", dim.toString());
                data.func_74768_a("SpawnX", pos.func_177958_n());
                data.func_74768_a("SpawnY", pos.func_177956_o());
                data.func_74768_a("SpawnZ", pos.func_177952_p());
                spawnList.add((Object)data);
            }
        });
        compound.func_218657_a("Spawns", (INBT)spawnList);
        return compound;
    }

    public void fromNBT(CompoundNBT compound) {
        compound.func_150295_c("Spawns", 10).forEach(e -> {
            CompoundNBT data = (CompoundNBT)e;
            this.posmap.put(new ResourceLocation(data.func_74779_i("Dim")), new BlockPos(data.func_74762_e("SpawnX"), data.func_74762_e("SpawnY"), data.func_74762_e("SpawnZ")));
        });
    }

    public String toString() {
        return "RespawnPosition{" + this.posmap + "}";
    }
}

